/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerProblemsDecorator;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;

public class PackageExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    private PackageExplorerContentProvider fContentProvider;
    private Map<ImageDescriptor, Image> fWorkingSetImages;
    private boolean fIsFlatLayout;
    private PackageExplorerProblemsDecorator fProblemDecorator = new PackageExplorerProblemsDecorator();

    public PackageExplorerLabelProvider(PackageExplorerContentProvider cp) {
        super(0x212000200029L | JavaElementLabels.ALL_CATEGORY, 3);
        this.addLabelDecorator(this.fProblemDecorator);
        Assert.isNotNull((Object)cp);
        this.fContentProvider = cp;
        this.fWorkingSetImages = null;
    }

    @Override
    public StyledString getStyledText(Object element) {
        String text = this.getSpecificText(element);
        if (text != null) {
            return new StyledString(this.decorateText(text, element));
        }
        return super.getStyledText(element);
    }

    private String getSpecificText(Object element) {
        if (!this.fIsFlatLayout && element instanceof IPackageFragment) {
            IPackageFragment fragment = (IPackageFragment)element;
            Object parent = this.fContentProvider.getHierarchicalPackageParent(fragment);
            if (parent instanceof IPackageFragment) {
                return this.getNameDelta((IPackageFragment)parent, fragment);
            }
            if (parent instanceof IFolder) {
                return this.getNameDelta((IFolder)parent, fragment);
            }
        } else if (element instanceof IWorkingSet) {
            return ((IWorkingSet)element).getLabel();
        }
        return null;
    }

    @Override
    public String getText(Object element) {
        String text = this.getSpecificText(element);
        if (text != null) {
            return this.decorateText(text, element);
        }
        return super.getText(element);
    }

    private String getNameDelta(IPackageFragment parent, IPackageFragment fragment) {
        String prefix = String.valueOf(parent.getElementName()) + '.';
        String fullName = fragment.getElementName();
        if (fullName.startsWith(prefix)) {
            return fullName.substring(prefix.length());
        }
        return fullName;
    }

    private String getNameDelta(IFolder parent, IPackageFragment fragment) {
        IPath fullPath;
        IPath prefix = parent.getFullPath();
        if (prefix.isPrefixOf(fullPath = fragment.getPath())) {
            StringBuffer buf = new StringBuffer();
            int i = prefix.segmentCount();
            while (i < fullPath.segmentCount()) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(fullPath.segment(i));
                ++i;
            }
            return buf.toString();
        }
        return fragment.getElementName();
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof IWorkingSet) {
            Image result;
            ImageDescriptor image = ((IWorkingSet)element).getImageDescriptor();
            if (image == null) {
                return null;
            }
            if (this.fWorkingSetImages == null) {
                this.fWorkingSetImages = new HashMap<ImageDescriptor, Image>();
            }
            if ((result = this.fWorkingSetImages.get(image)) == null) {
                result = image.createImage();
                this.fWorkingSetImages.put(image, result);
            }
            return this.decorateImage(result, element);
        }
        return super.getImage(element);
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
        this.fProblemDecorator.setIsFlatLayout(state);
    }

    @Override
    public void dispose() {
        if (this.fWorkingSetImages != null) {
            Iterator<Image> iter = this.fWorkingSetImages.values().iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
        }
        super.dispose();
    }
}

