/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.css2;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontPropertiesImpl;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSS2FontPropertiesHelpers {
    public static final String CSS2FONT_KEY = "org.eclipse.e4.ui.css.core.css2.CSS2FONT_KEY";

    public static CSS2FontProperties getCSS2FontProperties(CSSElementContext context) {
        return (CSS2FontProperties)context.getData(CSS2FONT_KEY);
    }

    public static void setCSS2FontProperties(CSS2FontProperties fontProperties, CSSElementContext context) {
        if (fontProperties == null) {
            return;
        }
        context.setData(CSS2FONT_KEY, fontProperties);
    }

    public static CSS2FontProperties createCSS2FontProperties(CSSValue value, String property) {
        CSS2FontPropertiesImpl fontProperties = new CSS2FontPropertiesImpl();
        CSS2FontPropertiesHelpers.updateCSSPropertyFont(fontProperties, property, value);
        return fontProperties;
    }

    public static void updateCSSPropertyFont(CSS2FontProperties fontProperties, String property, CSSValue value) {
        if ("font-family".equals(property)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontFamily(fontProperties, value);
        } else if ("font-size".equals(property)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontSize(fontProperties, value);
        } else if ("font-style".equals(property)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontStyle(fontProperties, value);
        } else if ("font-weight".equals(property)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontWeight(fontProperties, value);
        } else if ("font".equals(property)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontComposite(fontProperties, value);
        }
    }

    public static void updateCSSPropertyFontComposite(CSS2FontProperties font, CSSValue value) {
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            int i = 0;
            while (i < length) {
                CSSValue value2 = valueList.item(i);
                CSS2FontPropertiesHelpers.updateCSSPropertyFontComposite(font, value2);
                ++i;
            }
        } else if (value.getCssValueType() == 1) {
            String property = CSS2FontHelper.getCSSFontPropertyName((CSSPrimitiveValue)value);
            CSS2FontPropertiesHelpers.updateCSSPropertyFont(font, property, value);
        }
    }

    public static void updateCSSPropertyFontFamily(CSS2FontProperties font, CSSValue value) {
        if (value.getCssValueType() == 1) {
            font.setFamily((CSSPrimitiveValue)value);
        }
    }

    public static void updateCSSPropertyFontSize(CSS2FontProperties font, CSSValue value) {
        if (value.getCssValueType() == 1) {
            font.setSize((CSSPrimitiveValue)value);
        }
    }

    public static void updateCSSPropertyFontStyle(CSS2FontProperties font, CSSValue value) {
        if (value.getCssValueType() == 1) {
            font.setStyle((CSSPrimitiveValue)value);
        }
    }

    public static void updateCSSPropertyFontWeight(CSS2FontProperties font, CSSValue value) {
        if (value.getCssValueType() == 1) {
            font.setWeight((CSSPrimitiveValue)value);
        }
    }
}

