/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.aspects;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rcptt.tesla.recording.aspects.ActionType;
import org.eclipse.rcptt.tesla.recording.aspects.IWorkbenchEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.RecordingWorkbenchActivator;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.statushandlers.StatusAdapter;

public final class WorkbenchEventManager {
    private static Set<IWorkbenchEventListener> listeners = new HashSet<IWorkbenchEventListener>();
    private static boolean freezeState;

    private WorkbenchEventManager() {
    }

    public static void addListener(IWorkbenchEventListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(IWorkbenchEventListener listener) {
        listeners.remove(listener);
    }

    public static boolean getFreeze() {
        return freezeState;
    }

    public static void setFreeze(boolean value) {
        freezeState = value;
    }

    public static void closeEditors(IEditorReference[] refArray) {
        for (IWorkbenchEventListener listener : listeners) {
            listener.closeEditors(refArray);
        }
    }

    public static void restartEclipse() {
        for (IWorkbenchEventListener listener : listeners) {
            listener.restartEclipse();
        }
    }

    public static void recordAction(ActionType type) {
        try {
            for (IWorkbenchEventListener listener : listeners) {
                listener.recordAction(type);
            }
        }
        catch (Throwable e) {
            RecordingWorkbenchActivator.log(e);
        }
    }

    public static void recordAddStatus(StatusAdapter adapter, boolean modal) {
        for (IWorkbenchEventListener listener : listeners) {
            listener.recordAddStatus(adapter, modal);
        }
    }

    public static void recordStatusCleanup() {
        for (IWorkbenchEventListener listener : listeners) {
            listener.recordStatusCleanup();
        }
    }
}

