/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.resources;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rcptt.ctx.impl.internal.resources.Activator;
import org.eclipse.rcptt.ctx.resources.IFileBufferUtils;

public class FileBuffersUtilsImpl
implements IFileBufferUtils {
    @Override
    public void clearAll() {
        try {
            int counter = 10;
            do {
                IFileBuffer[] fileBuffers;
                if ((fileBuffers = FileBuffers.getTextFileBufferManager().getFileBuffers()).length == 0) {
                    return;
                }
                IFileBuffer[] iFileBufferArray = fileBuffers;
                int n = fileBuffers.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileBuffer iFileBuffer = iFileBufferArray[n2];
                    try {
                        FileBuffers.getTextFileBufferManager().disconnect(iFileBuffer.getLocation(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                    }
                    ++n2;
                }
            } while (--counter != 0);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    @Override
    public void syncLocation(IPath location) {
        try {
            ITextFileBufferManager mgr = FileBuffers.getTextFileBufferManager();
            IFileBuffer buffer = mgr.getFileBuffer(location, LocationKind.IFILE);
            if (buffer != null) {
                buffer.revert((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }
}

