/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.ws.TriggerPointAdvisorDescriptor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.RegistryReader;

public class TriggerPointAdvisorRegistry {
    private static TriggerPointAdvisorRegistry instance;

    private TriggerPointAdvisorRegistry() {
    }

    public static TriggerPointAdvisorRegistry getInstance() {
        if (instance == null) {
            instance = new TriggerPointAdvisorRegistry();
        }
        return instance;
    }

    public TriggerPointAdvisorDescriptor[] getAdvisors() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
        if (point == null) {
            return new TriggerPointAdvisorDescriptor[0];
        }
        IExtension[] extensions = point.getExtensions();
        extensions = RegistryReader.orderExtensions(extensions);
        ArrayList<TriggerPointAdvisorDescriptor> list = new ArrayList<TriggerPointAdvisorDescriptor>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("triggerPointAdvisor")) {
                    try {
                        TriggerPointAdvisorDescriptor descriptor = new TriggerPointAdvisorDescriptor(element);
                        list.add(descriptor);
                    }
                    catch (IllegalArgumentException e) {
                        WorkbenchPlugin.log("invalid trigger point advisor extension", StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new TriggerPointAdvisorDescriptor[list.size()]);
    }

    public TriggerPointAdvisorDescriptor getAdvisorForProduct(String productId) {
        TriggerPointAdvisorDescriptor[] advisors;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
        if (point == null) {
            return null;
        }
        IExtension[] extensions = point.getExtensions();
        String targetIntroId = this.getAdvisorForProduct(productId, extensions = RegistryReader.orderExtensions(extensions));
        if (targetIntroId == null) {
            return null;
        }
        TriggerPointAdvisorDescriptor[] triggerPointAdvisorDescriptorArray = advisors = this.getAdvisors();
        int n = advisors.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerPointAdvisorDescriptor advisor = triggerPointAdvisorDescriptorArray[n2];
            if (advisor.getId().equals(targetIntroId)) {
                return advisor;
            }
            ++n2;
        }
        return null;
    }

    private String getAdvisorForProduct(String targetProductId, IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("triggerPointAdvisorProductBinding")) {
                    String advisorId = element.getAttribute("triggerPointAdvisorId");
                    String productId = element.getAttribute("productId");
                    if (advisorId == null || productId == null) {
                        Status status = new Status(4, element.getDeclaringExtension().getNamespace(), 4, "triggerPointAdvisorId and productId must be defined.", (Throwable)new IllegalArgumentException());
                        WorkbenchPlugin.log("Invalid trigger point advisor binding", (IStatus)status);
                    } else if (targetProductId.equals(productId)) {
                        return advisorId;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

