/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.TextProcessor;

public class Strings
extends org.eclipse.jdt.internal.core.manipulation.util.Strings {
    private Strings() {
    }

    public static void markMatchingRegions(StyledString styledString, int index, int[] matchingRegions, StyledString.Styler styler) {
        if (matchingRegions != null) {
            int offset = -1;
            int length = 0;
            int i = 0;
            while (i + 1 < matchingRegions.length) {
                if (offset == -1) {
                    offset = index + matchingRegions[i];
                }
                if (i + 2 < matchingRegions.length && matchingRegions[i] + matchingRegions[i + 1] == matchingRegions[i + 2]) {
                    length += matchingRegions[i + 1];
                } else {
                    styledString.setStyle(offset, length + matchingRegions[i + 1], styler);
                    offset = -1;
                    length = 0;
                }
                i += 2;
            }
        }
    }

    public static StyledString markLTR(StyledString styledString) {
        if (!USE_TEXT_PROCESSOR) {
            return styledString;
        }
        String inputString = styledString.getString();
        String string = TextProcessor.process((String)inputString);
        if (string != inputString) {
            Strings.insertMarks(styledString, inputString, string);
        }
        return styledString;
    }

    public static StyledString markJavaElementLabelLTR(StyledString styledString) {
        if (!USE_TEXT_PROCESSOR) {
            return styledString;
        }
        String inputString = styledString.getString();
        String string = TextProcessor.process((String)inputString, (String)JAVA_ELEMENT_DELIMITERS);
        if (string != inputString) {
            Strings.insertMarks(styledString, inputString, string);
        }
        return styledString;
    }

    public static StyledString markLTR(StyledString styledString, String delimiters) {
        if (!USE_TEXT_PROCESSOR) {
            return styledString;
        }
        String inputString = styledString.getString();
        String string = TextProcessor.process((String)inputString, (String)delimiters);
        if (string != inputString) {
            Strings.insertMarks(styledString, inputString, string);
        }
        return styledString;
    }

    private static void insertMarks(StyledString styledString, String originalString, String processedString) {
        int originalLength = originalString.length();
        int processedStringLength = processedString.length();
        char orig = originalLength > 0 ? originalString.charAt(0) : (char)'\u0000';
        int o = 0;
        int p = 0;
        while (p < processedStringLength) {
            char processed = processedString.charAt(p);
            if (o < originalLength && orig == processed) {
                if (++o < originalLength) {
                    orig = originalString.charAt(o);
                }
            } else {
                styledString.insert(processed, p);
            }
            ++p;
        }
    }

    public static String removeMnemonicIndicator(String string) {
        return LegacyActionTools.removeMnemonics((String)string);
    }
}

