/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.cheatsheets.composite.parser.IStatusContainer;
import org.eclipse.ui.internal.cheatsheets.composite.parser.ITaskParseStrategy;
import org.eclipse.ui.internal.cheatsheets.composite.parser.MarkupParser;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParserException;
import org.eclipse.ui.internal.cheatsheets.data.ParserStatusUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CompositeCheatSheetParser
implements IStatusContainer {
    private DocumentBuilder documentBuilder;
    private IStatus status;
    private int nextTaskId = 0;

    public IStatus getStatus() {
        return this.status;
    }

    public DocumentBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            try {
                this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                this.documentBuilder.setEntityResolver((EntityResolver)new LocalEntityResolver());
            }
            catch (Exception e) {
                this.addStatus(4, Messages.ERROR_CREATING_DOCUMENT_BUILDER, e);
            }
        }
        return this.documentBuilder;
    }

    @Override
    public void addStatus(int severity, String message, Throwable exception) {
        this.status = ParserStatusUtility.addStatus(this.status, severity, message, exception);
    }

    /*
     * Loose catch block
     */
    public CompositeCheatSheetModel parseGuide(URL url) {
        Document document;
        this.status = Status.OK_STATUS;
        if (url == null) {
            String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{""});
            this.addStatus(4, message, null);
            return null;
        }
        InputStream is = null;
        try {
            is = url.openStream();
            if (is == null) {
                String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{url.getFile()});
                this.addStatus(4, message, null);
                return null;
            }
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{url.getFile()});
            this.addStatus(4, message, e);
            return null;
        }
        String filename = url.getFile();
        try {
            InputSource inputSource = new InputSource(is);
            document = this.getDocumentBuilder().parse(inputSource);
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.ERROR_OPENING_FILE_IN_PARSER, (Object[])new Object[]{filename});
            this.addStatus(4, message, e);
            try {
                is.close();
            }
            catch (Exception exception) {}
            return null;
        }
        catch (SAXParseException spe) {
            String message = NLS.bind((String)Messages.ERROR_SAX_PARSING_WITH_LOCATION, (Object[])new Object[]{filename, new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber())});
            this.addStatus(4, message, spe);
            try {
                is.close();
            }
            catch (Exception exception) {}
            return null;
        }
        catch (SAXException se) {
            String message = NLS.bind((String)Messages.ERROR_SAX_PARSING, (Object[])new Object[]{filename});
            this.addStatus(4, message, se);
            {
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (Exception exception) {}
            return null;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        CompositeCheatSheetModel result = this.parseCompositeCheatSheet(document, url);
        return result;
    }

    public CompositeCheatSheetModel parseCompositeCheatSheet(Document document, URL url) {
        this.status = Status.OK_STATUS;
        try {
            if (document != null) {
                Element rootnode = document.getDocumentElement();
                if (!rootnode.getNodeName().equals("compositeCheatsheet")) {
                    String message = NLS.bind((String)Messages.ERROR_PARSING_ROOT_NODE_TYPE, (Object[])new Object[]{"compositeCheatsheet"});
                    throw new CheatSheetParserException(message);
                }
                String name = "";
                boolean nameFound = false;
                String explorerId = "tree";
                NamedNodeMap attributes = rootnode.getAttributes();
                if (attributes != null) {
                    int x = 0;
                    while (x < attributes.getLength()) {
                        Node attribute = attributes.item(x);
                        String attributeName = attribute.getNodeName();
                        if (attributeName != null && attributeName.equals("name")) {
                            nameFound = true;
                            name = attribute.getNodeValue();
                        }
                        if (attributeName.equals("explorer")) {
                            explorerId = attribute.getNodeValue();
                        }
                        ++x;
                    }
                }
                CompositeCheatSheetModel compositeCS = new CompositeCheatSheetModel(name, name, explorerId);
                this.parseCompositeCheatSheetChildren(rootnode, compositeCS);
                compositeCS.getDependencies().resolveDependencies(this);
                if (compositeCS.getRootTask() == null) {
                    this.addStatus(4, Messages.ERROR_PARSING_NO_ROOT, null);
                }
                if (!nameFound) {
                    this.addStatus(4, Messages.ERROR_PARSING_CCS_NO_NAME, null);
                }
                if (this.status.getSeverity() != 4) {
                    compositeCS.setContentUrl(url);
                    return compositeCS;
                }
            }
            return null;
        }
        catch (CheatSheetParserException e) {
            this.addStatus(4, e.getMessage(), null);
            return null;
        }
    }

    private void parseCompositeCheatSheetChildren(Node compositeCSNode, CompositeCheatSheetModel model) {
        this.nextTaskId = 0;
        NodeList childNodes = compositeCSNode.getChildNodes();
        int index = 0;
        while (index < childNodes.getLength()) {
            Node nextNode = childNodes.item(index);
            if (CompositeCheatSheetParser.isAbstractTask(nextNode.getNodeName())) {
                AbstractTask task = this.parseAbstractTask(nextNode, model);
                if (model.getRootTask() == null) {
                    model.setRootTask(task);
                    this.parseTaskChildren(nextNode, task, model);
                } else {
                    this.addStatus(4, Messages.ERROR_PARSING_MULTIPLE_ROOT, null);
                }
            }
            ++index;
        }
    }

    public static boolean isAbstractTask(String nodeName) {
        return nodeName == "task" || nodeName == "taskGroup";
    }

    private void parseTaskChildren(Node parentNode, AbstractTask parentTask, CompositeCheatSheetModel model) {
        NodeList childNodes = parentNode.getChildNodes();
        ITaskParseStrategy strategy = parentTask.getParserStrategy();
        strategy.init();
        int index = 0;
        while (index < childNodes.getLength()) {
            Node childNode = childNodes.item(index);
            if (childNode.getNodeType() == 1) {
                String nodeName = childNode.getNodeName();
                if (nodeName == "param") {
                    this.addParameter(parentTask, childNode.getAttributes());
                } else if (nodeName == "intro") {
                    parentTask.setDescription(MarkupParser.parseAndTrimTextMarkup(childNode));
                } else if (nodeName == "onCompletion") {
                    parentTask.setCompletionMessage(MarkupParser.parseAndTrimTextMarkup(childNode));
                } else if (nodeName == "dependsOn") {
                    this.parseDependency(childNode, parentTask, model);
                } else if (CompositeCheatSheetParser.isAbstractTask(nodeName)) {
                    if (parentTask instanceof TaskGroup) {
                        AbstractTask task = this.parseAbstractTask(childNode, model);
                        ((TaskGroup)parentTask).addSubtask(task);
                        this.parseTaskChildren(childNode, task, model);
                    }
                } else if (!strategy.parseElementNode(childNode, parentNode, parentTask, this)) {
                    String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{nodeName, parentNode.getNodeName()});
                    this.addStatus(2, message, null);
                }
            }
            ++index;
        }
        strategy.parsingComplete(parentTask, this);
    }

    private void parseDependency(Node taskNode, AbstractTask task, CompositeCheatSheetModel model) {
        NamedNodeMap attributes = taskNode.getAttributes();
        if (attributes != null) {
            Node taskAttribute = attributes.getNamedItem("task");
            if (taskAttribute != null) {
                String requiredTaskId = taskAttribute.getNodeValue();
                model.getDependencies().addDependency(task, requiredTaskId);
            } else {
                this.addStatus(4, Messages.ERROR_PARSING_NO_ID, null);
            }
        }
    }

    private void addParameter(AbstractTask parentTask, NamedNodeMap attributes) {
        String name = null;
        String value = null;
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("name")) {
                        name = attribute.getNodeValue();
                    }
                    if (attributeName.equals("value")) {
                        value = attribute.getNodeValue();
                    }
                }
                ++x;
            }
        }
        if (name == null) {
            this.addStatus(2, Messages.ERROR_PARSING_NO_NAME, null);
            return;
        }
        if (value == null) {
            this.addStatus(2, Messages.ERROR_PARSING_NO_VALUE, null);
            return;
        }
        parentTask.getParameters().put(name, value);
    }

    private AbstractTask parseAbstractTask(Node taskNode, CompositeCheatSheetModel model) {
        String message;
        NamedNodeMap attributes = taskNode.getAttributes();
        String kind = null;
        String name = null;
        String id = null;
        boolean skippable = false;
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("kind")) {
                        kind = attribute.getNodeValue();
                    }
                    if (attributeName.equals("name")) {
                        name = attribute.getNodeValue();
                    }
                    if (attributeName.equals("id")) {
                        id = attribute.getNodeValue();
                    }
                    if (attributeName.equals("skip")) {
                        skippable = "true".equalsIgnoreCase(attribute.getNodeValue());
                    }
                }
                ++x;
            }
        }
        String nodeName = taskNode.getNodeName();
        if (id == null) {
            id = this.autoGenerateId();
        }
        if (name == null) {
            message = NLS.bind((String)Messages.ERROR_PARSING_TASK_NO_NAME, (Object[])new Object[]{nodeName});
            this.addStatus(4, message, null);
        }
        AbstractTask task = this.createTask(nodeName, model, kind, id, name);
        task.setSkippable(skippable);
        if (model.getDependencies().getTask(id) != null) {
            message = NLS.bind((String)Messages.ERROR_PARSING_DUPLICATE_TASK_ID, (Object[])new Object[]{id});
            this.addStatus(4, message, null);
        } else {
            model.getDependencies().saveId(task);
        }
        return task;
    }

    private AbstractTask createTask(String nodeKind, CompositeCheatSheetModel model, String kind, String id, String name) {
        AbstractTask task = "taskGroup".equals(nodeKind) ? new TaskGroup(model, id, name, kind) : new EditableTask(model, id, name, kind);
        task.setCompletionMessage(Messages.COMPLETED_TASK);
        return task;
    }

    private String autoGenerateId() {
        return "TaskId_" + this.nextTaskId++;
    }
}

