/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.VerificationExecutable;
import org.eclipse.rcptt.internal.launching.reporting.ReportMaker;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ReportHelper;

public class UnresolvedVerificationExecutable
extends VerificationExecutable {
    public UnresolvedVerificationExecutable(AutLaunch launch, IVerification verification, boolean debug, ExecutionPhase phase) {
        super(launch, verification, debug, phase);
    }

    @Override
    protected IStatus doExecute() throws CoreException, InterruptedException {
        Verification verification = (Verification)this.getActualElement().getModifiedNamedElement();
        Q7Info info = ReportHelper.createInfo();
        info.setType(ItemKind.VERIFICATION);
        info.setTags(verification.getTags());
        info.setId(verification.getId());
        info.setDescription(verification.getDescription());
        ImmutableMap props = ImmutableMap.of((Object)"q7", (Object)info);
        ReportMaker.beginReportNode(this.getName(), (Map<String, EObject>)props, this.launch);
        ReportMaker.endReportNode(false, this.launch, RcpttPlugin.createProcessStatus((int)4, (String)"Verification is unresolved"));
        return new Status(4, "org.eclipse.rcptt.launching", "Verification could not be resolved:" + this.getName());
    }
}

