/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public class IteratorService {
    public static WorkingTreeIterator createInitialIterator(Repository repository) {
        if (repository.isBare()) {
            return null;
        }
        return new FileTreeIterator(repository);
    }

    public static IContainer findContainer(IWorkspaceRoot root, File file) {
        IContainer[] containers;
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("file " + file.getAbsolutePath() + " is no directory");
        }
        IContainer resource = root.getContainerForLocation((IPath)new Path(file.getAbsolutePath()));
        if (resource == null) {
            return null;
        }
        if (IteratorService.isValid(resource)) {
            return resource;
        }
        IContainer[] iContainerArray = containers = root.findContainersForLocationURI(file.toURI());
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            if (IteratorService.isValid(container)) {
                return container;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isValid(IContainer container) {
        return container.isAccessible() && !container.isLinked(512) && IteratorService.isProjectSharedWithGit(container);
    }

    private static boolean isProjectSharedWithGit(IContainer container) {
        return RepositoryMapping.getMapping((IResource)container) != null;
    }
}

