/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.DetailFormatterDialog;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditDetailFormatterAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection != null && selection.size() == 1) {
            IJavaType type;
            Object element = selection.getFirstElement();
            try {
                IJavaValue value;
                if (element instanceof IJavaVariable) {
                    value = (IJavaValue)((IJavaVariable)element).getValue();
                } else if (element instanceof JavaInspectExpression) {
                    value = (IJavaValue)((JavaInspectExpression)((Object)element)).getValue();
                } else {
                    return;
                }
                type = value.getJavaType();
            }
            catch (DebugException debugException) {
                return;
            }
            JavaDetailFormattersManager fm = JavaDetailFormattersManager.getDefault();
            DetailFormatter formatter = fm.getAssociatedDetailFormatter(type);
            if (formatter == null & type instanceof IJavaClassType && (formatter = fm.getDetailFormatterFromInterface((IJavaClassType)type)) == null) {
                formatter = fm.getDetailFormatterFromSuperclass((IJavaClassType)type);
            }
            if (new DetailFormatterDialog(JDIDebugUIPlugin.getActivePage().getWorkbenchWindow().getShell(), formatter, null, false, true).open() == 0) {
                fm.setAssociatedDetailFormatter(formatter);
            }
        }
    }
}

