/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ProfileModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;

public class SystemApiDetector
extends AbstractProblemDetector {
    private Map<IReference, Integer> referenceEEs;

    @Override
    protected int getElementType(IReference reference) {
        IApiMember member = reference.getMember();
        switch (member.getType()) {
            case 2: {
                return 2;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiMember member = reference.getMember();
        String eeValue = ProfileModifiers.getName(this.referenceEEs.get(reference));
        String simpleTypeName = Signatures.getSimpleTypeName(reference.getReferencedTypeName());
        if (simpleTypeName.indexOf(36) != -1) {
            simpleTypeName = simpleTypeName.replace('$', '.');
        }
        switch (reference.getReferenceType()) {
            case 1: {
                return new String[]{this.getDisplay(member, false), simpleTypeName, eeValue};
            }
            case 2: {
                return new String[]{this.getDisplay(member, false), simpleTypeName, reference.getReferencedMemberName(), eeValue};
            }
            case 3: {
                String referenceMemberName = reference.getReferencedMemberName();
                if (Util.isConstructor(referenceMemberName)) {
                    return new String[]{this.getDisplay(member, false), Signature.toString((String)reference.getReferencedSignature(), (String)simpleTypeName, null, (boolean)false, (boolean)false), eeValue};
                }
                return new String[]{this.getDisplay(member, false), simpleTypeName, Signature.toString((String)reference.getReferencedSignature(), (String)referenceMemberName, null, (boolean)false, (boolean)false), eeValue};
            }
        }
        return null;
    }

    private String getDisplay(IApiMember member, boolean qualified) throws CoreException {
        String typeName;
        String string = typeName = qualified ? this.getTypeName(member) : this.getSimpleTypeName(member);
        if (typeName.indexOf(36) != -1) {
            typeName = typeName.replace('$', '.');
        }
        switch (member.getType()) {
            case 5: {
                StringBuffer buffer = new StringBuffer();
                IApiField field = (IApiField)member;
                buffer.append(typeName).append('.').append(field.getName());
                return String.valueOf(buffer);
            }
            case 6: {
                IApiMethod method = (IApiMethod)member;
                if (qualified) {
                    return Signatures.getMethodSignature(method);
                }
                return Signatures.getQualifiedMethodSignature(method);
            }
        }
        return typeName;
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        switch (reference.getReferenceType()) {
            case 1: {
                return 0;
            }
            case 3: {
                if (Util.isConstructor(reference.getReferencedMemberName())) {
                    return 7;
                }
                return 8;
            }
            case 2: {
                return 9;
            }
        }
        return 0;
    }

    @Override
    protected int getProblemKind() {
        return 9;
    }

    @Override
    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiMember member = reference.getMember();
        String eeValue = ProfileModifiers.getName(this.referenceEEs.get(reference));
        String simpleTypeName = reference.getReferencedTypeName();
        if (simpleTypeName.indexOf(36) != -1) {
            simpleTypeName = simpleTypeName.replace('$', '.');
        }
        switch (reference.getReferenceType()) {
            case 1: {
                return new String[]{this.getDisplay(member, false), simpleTypeName, eeValue};
            }
            case 2: {
                return new String[]{this.getDisplay(member, false), simpleTypeName, reference.getReferencedMemberName(), eeValue};
            }
            case 3: {
                String referenceMemberName = reference.getReferencedMemberName();
                if (Util.isConstructor(referenceMemberName)) {
                    return new String[]{this.getDisplay(member, false), Signature.toString((String)reference.getReferencedSignature(), (String)simpleTypeName, null, (boolean)false, (boolean)false), eeValue};
                }
                return new String[]{this.getDisplay(member, false), simpleTypeName, Signature.toString((String)reference.getReferencedSignature(), (String)referenceMemberName, null, (boolean)false, (boolean)false), eeValue};
            }
        }
        return null;
    }

    @Override
    protected String getSeverityKey() {
        return "INVALID_REFERENCE_IN_SYSTEM_LIBRARIES";
    }

    @Override
    protected Position getSourceRange(IType type, IDocument document, IReference reference) throws CoreException, BadLocationException {
        switch (reference.getReferenceType()) {
            case 1: {
                int linenumber = reference.getLineNumber();
                if (linenumber > 0) {
                    --linenumber;
                }
                if (linenumber > 0) {
                    String qname;
                    int offset = document.getLineOffset(linenumber);
                    String line = document.get(offset, document.getLineLength(linenumber));
                    int first = line.indexOf(qname = reference.getReferencedTypeName().replace('$', '.'));
                    if (first < 0) {
                        qname = Signatures.getSimpleTypeName(reference.getReferencedTypeName());
                        qname = qname.replace('$', '.');
                        first = line.indexOf(qname);
                    }
                    Position pos = null;
                    pos = first > -1 ? new Position(offset + first, qname.length()) : new Position(offset, line.length());
                    return pos;
                }
                IApiMember apiMember = reference.getMember();
                switch (apiMember.getType()) {
                    case 5: {
                        IApiField field = (IApiField)reference.getMember();
                        return this.getSourceRangeForField(type, reference, field);
                    }
                    case 6: {
                        IApiMethod method = (IApiMethod)reference.getMember();
                        return this.getSourceRangeForMethod(type, reference, method);
                    }
                }
                ISourceRange range = type.getNameRange();
                Position pos = null;
                if (range != null) {
                    pos = new Position(range.getOffset(), range.getLength());
                }
                if (pos == null) {
                    return this.defaultSourcePosition(type, reference);
                }
                return pos;
            }
            case 2: {
                int linenumber = reference.getLineNumber();
                if (linenumber > 0) {
                    return this.getFieldNameRange(reference.getReferencedTypeName(), reference.getReferencedMemberName(), document, reference);
                }
                IApiField field = (IApiField)reference.getMember();
                return this.getSourceRangeForField(type, reference, field);
            }
            case 3: {
                if (reference.getLineNumber() >= 0) {
                    boolean isConstructor;
                    String referenceMemberName = reference.getReferencedMemberName();
                    String methodName = null;
                    methodName = (isConstructor = Util.isConstructor(referenceMemberName)) ? Signatures.getSimpleTypeName(reference.getReferencedTypeName().replace('$', '.')) : referenceMemberName;
                    Position pos = this.getMethodNameRange(isConstructor, methodName, document, reference);
                    if (pos == null) {
                        return this.defaultSourcePosition(type, reference);
                    }
                    return pos;
                }
                IApiMethod method = (IApiMethod)reference.getMember();
                return this.getSourceRangeForMethod(type, reference, method);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isProblem(IReference reference) {
        try {
            IApiMember member = reference.getMember();
            IApiComponent apiComponent = member.getApiComponent();
            String[] lowestEEs = apiComponent.getLowestEEs();
            if (lowestEEs == null) {
                return false;
            }
            int i = 0;
            int max = lowestEEs.length;
            while (true) {
                if (i >= max) {
                    return false;
                }
                String lowestEE = lowestEEs[i];
                int eeValue = ProfileModifiers.getValue(lowestEE);
                if (eeValue == 0) {
                    return false;
                }
                if (!((Reference)reference).resolve(eeValue)) {
                    if (apiComponent instanceof BundleComponent) {
                        BundleDescription bundle = ((BundleComponent)apiComponent).getBundleDescription();
                        ImportPackageSpecification[] importPackages = bundle.getImportPackages();
                        String referencedTypeName = reference.getReferencedTypeName();
                        int index = referencedTypeName.lastIndexOf(46);
                        String packageName = referencedTypeName.substring(0, index);
                        int j = 0;
                        int max2 = importPackages.length;
                        while (j < max2) {
                            ImportPackageSpecification importPackageSpecification = importPackages[j];
                            String importPackageName = importPackageSpecification.getName();
                            if (!importPackageName.equals(packageName)) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        if (this.referenceEEs == null) {
                            this.referenceEEs = new HashMap<IReference, Integer>(3);
                        }
                        this.referenceEEs.put(reference, eeValue);
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean considerReference(IReference reference) {
        try {
            IApiComponent apiComponent = reference.getMember().getApiComponent();
            IApiBaseline baseline = apiComponent.getBaseline();
            if (baseline == null) {
                return false;
            }
            String referencedTypeName = reference.getReferencedTypeName();
            int index = referencedTypeName.lastIndexOf(46);
            if (index == -1) {
                return false;
            }
            String substring = referencedTypeName.substring(0, index);
            IApiComponent[] resolvePackages = baseline.resolvePackage(apiComponent, substring);
            switch (resolvePackages.length) {
                case 1: {
                    if (!resolvePackages[0].isSystemComponent()) return false;
                    switch (reference.getReferenceKind()) {
                        case 0x4000000: 
                        case 0x10000000: {
                            return false;
                        }
                    }
                    ((Reference)reference).setResolveStatus(false);
                    this.retainReference(reference);
                    return true;
                }
            }
            return false;
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        return false;
    }

    @Override
    public int getReferenceKinds() {
        return 0x6FFFFFFF;
    }

    @Override
    public List<IApiProblem> createProblems() {
        List<IReference> references = this.getRetainedReferences();
        LinkedList<IApiProblem> problems = new LinkedList<IApiProblem>();
        for (IReference reference : references) {
            if (!this.isProblem(reference)) continue;
            try {
                IApiProblem problem = null;
                IApiComponent component = reference.getMember().getApiComponent();
                if (component instanceof ProjectComponent) {
                    ProjectComponent ppac = (ProjectComponent)component;
                    IJavaProject project = ppac.getJavaProject();
                    problem = this.createProblem(reference, project);
                } else {
                    problem = this.createProblem(reference);
                }
                if (problem == null) continue;
                problems.add(problem);
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
            }
        }
        return problems;
    }
}

