/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import com.ibm.icu.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.ProblemDetectorBuilder;
import org.eclipse.pde.api.tools.internal.builder.ReferenceResolver;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiProblemDetector;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;

public class ReferenceAnalyzer {
    private static final double LOG2 = Math.log(2.0);
    private static final IApiProblem[] EMPTY_RESULT = new IApiProblem[0];
    private static final IApiProblemDetector[] NO_PROBLEM_DETECTORS = new IApiProblemDetector[0];
    MultiStatus fStatus;
    int fAllReferenceKinds = 0;
    List<IReference> fReferences = new LinkedList<IReference>();
    IApiProblemDetector[][] fIndexedDetectors;

    void indexProblemDetectors(IApiProblemDetector[] detectors) {
        this.fIndexedDetectors = new IApiProblemDetector[32][];
        IApiProblemDetector[] iApiProblemDetectorArray = detectors;
        int n = detectors.length;
        int n2 = 0;
        while (n2 < n) {
            IApiProblemDetector detector = iApiProblemDetectorArray[n2];
            int kinds = detector.getReferenceKinds();
            this.fAllReferenceKinds |= kinds;
            int mask = 1;
            int bit = 0;
            while (bit < 32) {
                if ((mask & kinds) > 0) {
                    IApiProblemDetector[] indexed = this.fIndexedDetectors[bit];
                    if (indexed == null) {
                        this.fIndexedDetectors[bit] = new IApiProblemDetector[]{detector};
                    } else {
                        IApiProblemDetector[] next = new IApiProblemDetector[indexed.length + 1];
                        System.arraycopy(indexed, 0, next, 0, indexed.length);
                        next[indexed.length] = detector;
                        this.fIndexedDetectors[bit] = next;
                    }
                }
                mask <<= 1;
                ++bit;
            }
            ++n2;
        }
    }

    int getLog2(int bitConstant) {
        double logX = Math.log(bitConstant);
        double pow = logX / LOG2;
        return (int)Math.round(pow);
    }

    void extractReferences(IApiTypeContainer scope, IProgressMonitor monitor) throws CoreException {
        this.fStatus = new MultiStatus("org.eclipse.pde.api.tools", 0, BuilderMessages.ReferenceAnalyzer_api_analysis_error, null);
        String[] packageNames = scope.getPackageNames();
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)packageNames.length);
        Visitor visitor = new Visitor((IProgressMonitor)localMonitor);
        long start = System.currentTimeMillis();
        try {
            scope.accept(visitor);
        }
        catch (CoreException e) {
            this.fStatus.add(e.getStatus());
        }
        long end = System.currentTimeMillis();
        if (!this.fStatus.isOK()) {
            throw new CoreException((IStatus)this.fStatus);
        }
        localMonitor.done();
        if (ApiPlugin.DEBUG_REFERENCE_ANALYZER) {
            System.out.println("Reference Analyzer: extracted " + this.fReferences.size() + " references in " + (end - start) + "ms");
        }
    }

    public IApiProblem[] analyze(IApiComponent component, IApiTypeContainer scope, IProgressMonitor monitor) throws CoreException {
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IApiProblemDetector[] detectors = this.buildProblemDetectors(component, ProblemDetectorBuilder.K_ALL, (IProgressMonitor)localMonitor.split(1));
        try {
            IApiProblem[] array;
            localMonitor.subTask(BuilderMessages.ReferenceAnalyzer_analyzing_api_checking_use);
            this.extractReferences(scope, (IProgressMonitor)localMonitor.split(1));
            localMonitor.subTask(BuilderMessages.ReferenceAnalyzer_analyzing_api_checking_use);
            if (this.fReferences.size() != 0) {
                ReferenceResolver.resolveReferences(this.fReferences, (IProgressMonitor)localMonitor.split(1));
            }
            LinkedList<IApiProblem> allProblems = new LinkedList<IApiProblem>();
            localMonitor.subTask(BuilderMessages.ReferenceAnalyzer_analyzing_api_checking_use);
            SubMonitor loopMonitor = localMonitor.split(1).setWorkRemaining(detectors.length);
            IApiProblemDetector[] iApiProblemDetectorArray = detectors;
            int n = detectors.length;
            int n2 = 0;
            while (n2 < n) {
                IApiProblemDetector detector = iApiProblemDetectorArray[n2];
                loopMonitor.split(1);
                allProblems.addAll(detector.createProblems());
                ++n2;
            }
            IApiProblem[] iApiProblemArray = array = allProblems.toArray(new IApiProblem[allProblems.size()]);
            return iApiProblemArray;
        }
        catch (OperationCanceledException operationCanceledException) {
            IApiProblem[] iApiProblemArray = EMPTY_RESULT;
            return iApiProblemArray;
        }
        finally {
            this.fIndexedDetectors = null;
            this.fReferences.clear();
        }
    }

    public IApiProblemDetector[] getProblemDetectors(int referencekind) {
        if (this.fIndexedDetectors != null) {
            IApiProblemDetector[] detectors;
            int index = this.getLog2(referencekind);
            if (index > -1 && index < this.fIndexedDetectors.length && (detectors = this.fIndexedDetectors[index]) != null) {
                return detectors;
            }
            return NO_PROBLEM_DETECTORS;
        }
        return NO_PROBLEM_DETECTORS;
    }

    public IApiProblemDetector[] buildProblemDetectors(IApiComponent component, int kindmask, IProgressMonitor monitor) {
        try {
            long start = System.currentTimeMillis();
            IApiComponent[] components = component.getBaseline().getPrerequisiteComponents(new IApiComponent[]{component});
            final ProblemDetectorBuilder visitor = new ProblemDetectorBuilder(component, kindmask);
            SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)components.length);
            IApiComponent[] iApiComponentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                IApiComponent componentLoop = iApiComponentArray[n2];
                SubMonitor iterationMonitor = loopMonitor.split(1);
                IApiComponent prereq = componentLoop;
                if (!prereq.equals(component)) {
                    visitor.setOwningComponent(prereq);
                    try {
                        prereq.getApiDescription().accept(visitor, (IProgressMonitor)iterationMonitor);
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e.getStatus());
                    }
                }
                ++n2;
            }
            long end = System.currentTimeMillis();
            if (ApiPlugin.DEBUG_REFERENCE_ANALYZER) {
                System.out.println("Time to build problem detectors: " + (end - start) + "ms");
            }
            ApiDescriptionVisitor nameVisitor = new ApiDescriptionVisitor(){

                @Override
                public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
                    if (element.getElementType() == 1 && VisibilityModifiers.isPrivate(description.getVisibility())) {
                        visitor.addNonApiPackageName(((IPackageDescriptor)element).getName());
                    }
                    return false;
                }
            };
            component.getApiDescription().accept(nameVisitor, null);
            List<IApiProblemDetector> detectors = visitor.getProblemDetectors();
            int size = detectors.size();
            if (size == 0) {
                return NO_PROBLEM_DETECTORS;
            }
            IApiProblemDetector[] array = detectors.toArray(new IApiProblemDetector[size]);
            this.indexProblemDetectors(array);
            return array;
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return NO_PROBLEM_DETECTORS;
        }
    }

    class Visitor
    extends ApiTypeContainerVisitor {
        private IProgressMonitor fMonitor = null;

        public Visitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        @Override
        public boolean visitPackage(String packageName) {
            this.fMonitor.subTask(MessageFormat.format((String)BuilderMessages.ReferenceAnalyzer_checking_api_used_by, (Object[])new Object[]{packageName}));
            return true;
        }

        @Override
        public void endVisitPackage(String packageName) {
            this.fMonitor.worked(1);
        }

        @Override
        public void visit(String packageName, IApiTypeRoot classFile) {
            if (!this.fMonitor.isCanceled()) {
                try {
                    IApiType type = classFile.getStructure();
                    if (type == null) {
                        return;
                    }
                    if (type.isMemberType() || type.isLocal() || type.isAnonymous()) {
                        return;
                    }
                    List<IReference> references = type.extractReferences(ReferenceAnalyzer.this.fAllReferenceKinds, null);
                    for (IReference ref : references) {
                        int index = ReferenceAnalyzer.this.getLog2(ref.getReferenceKind());
                        IApiProblemDetector[] detectors = ReferenceAnalyzer.this.fIndexedDetectors[index];
                        boolean added = false;
                        if (detectors == null) continue;
                        IApiProblemDetector[] iApiProblemDetectorArray = detectors;
                        int n = detectors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IApiProblemDetector detector = iApiProblemDetectorArray[n2];
                            if (detector.considerReference(ref) && !added) {
                                ReferenceAnalyzer.this.fReferences.add(ref);
                                added = true;
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    ReferenceAnalyzer.this.fStatus.add(e.getStatus());
                }
            }
        }
    }
}

