/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.internal.core.AbstractRootSession;
import org.eclipse.rcptt.ecl.internal.core.AbstractSession;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.parser.EclCoreParser;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UISelector;
import org.eclipse.rcptt.tesla.core.protocol.WindowUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.utils.AbstractFeatureManager;
import org.eclipse.rcptt.tesla.ecl.TeslaErrorStatus;
import org.eclipse.rcptt.tesla.ecl.impl.BoundControlHandleRuntime;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.BoundControlHandle;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.core.queue.TeslaQClient;
import org.eclipse.rcptt.tesla.internal.core.queue.TeslaQPlayer;
import org.eclipse.rcptt.tesla.internal.ui.IBasicMappingNode;
import org.eclipse.rcptt.tesla.internal.ui.player.ReportScreenshotProvider;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.swt.events.ITeslaEventListener;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.util.Base64;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class TeslaBridge {
    private static TeslaQPlayer player;
    private static TeslaQClient client;
    private static ITeslaEventListener listener;
    private static AdvancedInformation lastInfo;
    private static WindowUIElement eclipseWindow;
    private static ControlUIElement lastControlUIElement;
    private static boolean noErrorMode;

    static {
        eclipseWindow = null;
        noErrorMode = false;
    }

    public static synchronized void setup() {
        lastInfo = null;
        noErrorMode = false;
        lastControlUIElement = null;
        if (player != null) {
            try {
                player.shutdown();
                player = null;
            }
            catch (Throwable e) {
                TeslaImplPlugin.err("Failed to deinialize player", e);
            }
        }
        if (client != null) {
            client.shutdown();
            client = null;
        }
        client = new TeslaQClient();
        try {
            client.clean();
        }
        catch (Throwable e) {
            TeslaImplPlugin.err("Failed to clean client", e);
        }
        player = new TeslaQPlayer(client){

            protected void notifyUI() {
                client.notifyUI();
            }
        };
        if (listener != null) {
            TeslaEventManager.getManager().removeEventListener(listener);
        }
        listener = new ITeslaEventListener(){

            public boolean doProcessing(ContextManagement.Context context) {
                Q7WaitInfoRoot info = TeslaBridge.getCurrentWaitInfo(true);
                TeslaQClient clientTemp = client;
                return clientTemp != null && clientTemp.processNext(context, info);
            }

            public void hasEvent(TeslaEventManager.HasEventKind kind, String run) {
                if (client != null) {
                    Q7WaitInfoRoot info = TeslaBridge.getCurrentWaitInfo(false);
                    client.hasEvent(kind.name(), run, info);
                }
            }
        };
        TeslaEventManager.getManager().addEventListener(listener);
    }

    public static Q7WaitInfoRoot getCurrentWaitInfo(boolean tick) {
        return ReportHelper.getWaitInfo((INodeBuilder)ReportManager.getCurrentReportNode());
    }

    public static void waitDelay() throws CoreException {
        AbstractFeatureManager.Option option = TeslaFeatures.getInstance().getOption("org.eclipse.rcptt.tesla.ecl.execution.delay");
        int delay = Integer.parseInt(option.getValue());
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", e.getMessage(), (Throwable)e));
            }
        }
    }

    public static synchronized void shutdown() {
        if (client != null) {
            lastInfo = client.getLastFailureInformation();
            client.clean();
        }
        if (player != null) {
            player.shutdown();
        }
        if (client != null) {
            client.shutdown();
        }
        if (listener != null) {
            TeslaEventManager.getManager().removeEventListener(listener);
        }
        player = null;
        client = null;
        listener = null;
        eclipseWindow = null;
        lastControlUIElement = null;
    }

    public static Element find(ControlHandler handler) throws CoreException {
        ControlUIElement control;
        String path;
        Assert.isNotNull((Object)handler);
        if (handler.getResolved() != null) {
            return handler.getResolved();
        }
        if (handler instanceof BoundControlHandle) {
            BoundControlHandle boundHandle = (BoundControlHandle)handler;
            Widget widget = BoundControlHandleRuntime.get(boundHandle.getWidgetId());
            if (widget == null) {
                throw new CoreException(TeslaImplPlugin.err("Unable to resolve bound widget by ID."));
            }
            final SWTUIProcessor processor = (SWTUIProcessor)TeslaBridge.getClient().getProcessor(SWTUIProcessor.class);
            final Element element = processor.getMapper().get((IBasicMappingNode)new SWTUIElement(widget, SWTUIPlayer.getPlayer((Display)widget.getDisplay())));
            widget.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TeslaBridge.getClient().map(element, (ITeslaCommandProcessor)processor);
                }
            });
            handler.setResolved(element);
            return element;
        }
        ElementKind kind = handler.getKind();
        UISelector selector = kind == ElementKind.Custom ? new UISelector(handler.getCustomKindId(), (IUIPlayer)TeslaBridge.getPlayer(), ControlUIElement.class) : new UISelector(kind, (IUIPlayer)TeslaBridge.getPlayer(), ControlUIElement.class);
        ControlHandler parent = handler.getParent();
        selector = parent != null ? selector.parent(TeslaBridge.find(parent)) : selector.parent(TeslaBridge.eclipseWindow());
        ControlHandler after = handler.getAfter();
        if (after != null) {
            selector = selector.after(TeslaBridge.find(after));
        }
        if ((path = handler.getPath()) != null) {
            selector = selector.pathList(TeslaBridge.parsePath(path));
        }
        String type = handler.getType();
        selector = selector.classPattern(type);
        String indexes = handler.getIndexes();
        if (indexes != null) {
            selector = selector.indexesList(TeslaBridge.parseIndexes(indexes));
        } else if (kind == ElementKind.Item && handler.getRow() != null) {
            selector = selector.indexesList(Arrays.asList(handler.getColumn(), handler.getRow()));
        }
        if (ElementKind.Region.equals((Object)kind)) {
            String rawImage = handler.getRawImage();
            byte[] image = Base64.decode((String)rawImage);
            selector = selector.image(image).indexes(new Integer[]{handler.getX(), handler.getY()});
        }
        if ((control = (ControlUIElement)selector.find(handler.getText(), handler.getIndex())) != null) {
            Element element = control.getElement();
            handler.setResolved(element);
            return element;
        }
        TeslaErrorStatus teslaFailure = TeslaBridge.getTeslaFailure();
        if (teslaFailure != null) {
            if (selector.getParent() != null) {
                lastControlUIElement = new ControlUIElement(selector.getParent(), (UIPlayer)TeslaBridge.getPlayer());
            }
            TeslaBridge.makeScreenshot(true, teslaFailure.getMessage());
            throw new CoreException((IStatus)teslaFailure);
        }
        String kindName = kind.name().toLowerCase();
        if ("text".equals(kindName)) {
            kindName = "editbox";
        }
        StringBuilder message = new StringBuilder("Cannot find ");
        message.append(kindName);
        if (handler.getText() != null) {
            message.append(" \"").append(handler.getText()).append("\"");
        } else if (handler.getPath() != null) {
            message.append(" \"").append(handler.getPath()).append("\"");
        }
        if (selector.getParent() != null) {
            lastControlUIElement = new ControlUIElement(selector.getParent(), (UIPlayer)TeslaBridge.getPlayer());
        }
        TeslaBridge.makeScreenshot(true, message.toString());
        throw new CoreException(TeslaImplPlugin.err(message.toString()));
    }

    public static TeslaErrorStatus getTeslaFailure() throws CoreException {
        List failures = TeslaBridge.getPlayer().getFailures();
        if (failures.isEmpty()) {
            return null;
        }
        Response last = (Response)failures.get(failures.size() - 1);
        return new TeslaErrorStatus(last.getMessage(), last.getAdvancedInformation());
    }

    public static List<String> parsePath(String path) throws CoreException {
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder segment = new StringBuilder();
        int i = 0;
        while (i < path.length()) {
            char next;
            char ch = path.charAt(i);
            if (ch == '/') {
                segments.add(segment.toString());
                segment = new StringBuilder();
            } else if (ch == '\\' && i + 1 < path.length() && (next = path.charAt(i + 1)) == '/') {
                ++i;
                segment.append(next);
            } else {
                segment.append(ch);
            }
            ++i;
        }
        segments.add(segment.toString());
        return segments;
    }

    public static List<Integer> parseIndexes(String path) throws CoreException {
        try {
            List<String> segments = TeslaBridge.parsePath(path);
            ArrayList<Integer> indexes = new ArrayList<Integer>(segments.size());
            for (String s : segments) {
                indexes.add(Integer.parseInt(s));
            }
            return indexes;
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException(CorePlugin.err((String)("Invalid path: " + path + ".\nMust contains integers only")));
        }
    }

    public static TeslaQPlayer getPlayer() throws CoreException {
        if (player == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        return player;
    }

    public static TeslaQClient getClient() {
        return client;
    }

    public static Element eclipseWindow() throws CoreException {
        if (eclipseWindow == null && (eclipseWindow = TeslaBridge.getPlayer().eclipseWindow()) == null) {
            TeslaErrorStatus teslaFailure = TeslaBridge.getTeslaFailure();
            if (teslaFailure != null) {
                throw new CoreException((IStatus)teslaFailure);
            }
            throw new CoreException(TeslaImplPlugin.err("Cannot find Eclipse window"));
        }
        return eclipseWindow.getElement();
    }

    public static AdvancedInformation getLastInfo() {
        if (noErrorMode) {
            return null;
        }
        AdvancedInformation last = lastInfo;
        lastInfo = null;
        return last;
    }

    public static void waitExecution() {
        if (player != null) {
            player.nop();
        }
    }

    public static void makeScreenshot(boolean onError, String message) {
        if (noErrorMode && onError) {
            return;
        }
        if (TeslaFeatures.getInstance().isTrue(TeslaFeatures.CAPTURE_EXECUTION) || onError) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            ReportScreenshotProvider.takeScreenshot((Display)display, (boolean)onError, (String)message);
        }
    }

    public static void storeLastControlUIElement(ControlUIElement element) {
        lastControlUIElement = element;
    }

    public static ControlUIElement getLastControlUIElement() {
        return lastControlUIElement;
    }

    public static void beginNoErrorMode() {
        noErrorMode = true;
    }

    public static void endNoErrorMode() {
        noErrorMode = false;
    }

    public static Widget resolveWidget(String selector, IProcess process, String ... classNames) throws CoreException {
        ArrayList classes = new ArrayList(classNames.length);
        int i = 0;
        while (i < classNames.length) {
            try {
                classes.add(Class.forName(classNames[i]));
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++i;
        }
        return TeslaBridge.resolveWidget(selector, process, classes.toArray(new Class[classes.size()]));
    }

    public static Widget resolveWidget(String selector, IProcess process, Class<?> ... classes) throws CoreException {
        Widget widget = TeslaBridge.resolveWidget(Widget.class, selector, process);
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.isInstance(widget)) {
                return widget;
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        Class<?>[] classArray2 = classes;
        int n3 = classes.length;
        n = 0;
        while (n < n3) {
            Class<?> cl = classArray2[n];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(cl.getSimpleName());
            ++n;
        }
        String classesList = sb.toString();
        throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", String.format("Wrong type of a widget. %s expected, got %s.", classesList, widget.getClass().getSimpleName())));
    }

    public static <T> T resolveWidget(Class<T> class_, String selector, IProcess process) throws CoreException {
        SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement(selector, process);
        Widget widget = swtuiElement.widget;
        if (!class_.isInstance(widget)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", String.format("Wrong type of a widget. %s expected, got %s.", class_.getSimpleName(), widget.getClass().getSimpleName())));
        }
        return class_.cast(widget);
    }

    public static SWTUIElement resolveSWTUIElement(String selector, IProcess process) throws CoreException {
        ISession session = process.getSession();
        if (!(session instanceof AbstractSession)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", "Unable to resolve widget (no session)."));
        }
        AbstractRootSession rootSession = ((AbstractSession)session).getRoot();
        Command command = EclCoreParser.newCommand((String)selector);
        boolean doShutdown = false;
        if (client == null) {
            doShutdown = true;
            TeslaBridge.setup();
        }
        try {
            SWTUIElement swtuiElement;
            IProcess result = rootSession.execute(command);
            try {
                IStatus status = result.waitFor();
                if (!status.isOK()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", "Unable to resolve widget."));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", "Unable to resolve widget (timeout)."));
            }
            Object wannabeControlHandler = result.getOutput().take(1000L);
            if (!(wannabeControlHandler instanceof ControlHandler)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", "Unable to resolve widget (not a ControlHandler)."));
            }
            ControlHandler controlHandler = (ControlHandler)wannabeControlHandler;
            Element element = TeslaBridge.find(controlHandler);
            SWTUIElement sWTUIElement = swtuiElement = (SWTUIElement)((SWTUIProcessor)TeslaBridge.getClient().getProcessor(SWTUIProcessor.class)).getMapper().get(element);
            return sWTUIElement;
        }
        finally {
            if (doShutdown) {
                TeslaBridge.shutdown();
            }
        }
    }
}

