/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.canvas;

import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTEvents;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class CanvasProcessor
implements ITeslaCommandProcessor {
    private AbstractTeslaClient client;

    public int getPriority() {
        return 275;
    }

    public String getFeatureID() {
        return "canvas";
    }

    public boolean isSelectorSupported(String kind) {
        return false;
    }

    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        return null;
    }

    public boolean isCommandSupported(Command cmd) {
        return cmd instanceof MouseCommand;
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        if (command instanceof MouseCommand) {
            return this.handleMouseCommand((MouseCommand)command);
        }
        return null;
    }

    private Response handleMouseCommand(final MouseCommand command) {
        final SWTUIElement element = (SWTUIElement)this.getSWTProcessor().getMapper().get(command.getElement());
        final Canvas canvas = (Canvas)PlayerWrapUtils.unwrapWidget((SWTUIElement)element);
        final Rectangle oldBounds = canvas.getBounds();
        this.getPlayer().exec("Set bounds and location", new Runnable(){

            @Override
            public void run() {
                if (command.getBoundsHeight() != 0 && command.getBoundsWidth() != 0) {
                    canvas.setBounds(0, 0, command.getBoundsWidth(), command.getBoundsHeight());
                }
            }
        });
        this.getPlayer().exec("Canvas executable", new Runnable(){

            @Override
            public void run() {
                SWTEvents events = CanvasProcessor.this.getPlayer().getEvents();
                Event e = events.createEvent(element);
                e.x = command.getX();
                e.y = command.getY();
                CanvasProcessor.this.getPlayer().addMouseWidgetInfo((Widget)canvas, e.x, e.y);
                e.button = command.getButton();
                e.stateMask = command.getStateMask();
                switch (command.getKind()) {
                    case DOWN: {
                        e.type = 3;
                        events.sendEvent(element, e);
                        break;
                    }
                    case ENTER: {
                        e.type = 6;
                        events.sendEvent(element, e);
                        break;
                    }
                    case EXIT: {
                        e.type = 7;
                        events.sendEvent(element, e);
                        break;
                    }
                    case HOVER: {
                        e.type = 32;
                        events.sendEvent(element, e);
                        break;
                    }
                    case UP: {
                        e.type = 4;
                        events.sendEvent(element, e);
                        break;
                    }
                    case MOVE: {
                        e.type = 5;
                        events.sendEvent(element, e);
                        break;
                    }
                    case DOUBLE_CLICK: {
                        e.type = 8;
                        e.count = 2;
                        events.sendEvent(element, e);
                    }
                }
                if (!canvas.isDisposed()) {
                    canvas.setBounds(oldBounds);
                }
            }
        });
        return ProtocolFactory.eINSTANCE.createBooleanResponse();
    }

    private SWTUIPlayer getPlayer() {
        return this.getSWTProcessor().getPlayer();
    }

    private SWTUIProcessor getSWTProcessor() {
        return (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        return null;
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
        if (element.getKind().equals(ElementKind.Canvas.name()) || element.getKind().equals(ElementKind.Window.name()) || element.getKind().equals(ElementKind.Link.name()) || element.getKind().equals(ElementKind.Text.name()) || element.getKind().equals(ElementKind.Expandable.name())) {
            mapper.map(element, (ITeslaCommandProcessor)this);
        }
    }

    public boolean isInactivityRequired() {
        return false;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        return true;
    }

    public void clean() {
    }

    public void terminate() {
        this.client = null;
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
    }

    public void notifyUI() {
    }
}

