/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JarEntryEditorInputFactory;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;

public class JarEntryEditorInput
implements IStorageEditorInput {
    private final IStorage fJarEntryFile;

    public JarEntryEditorInput(IStorage jarEntryFile) {
        Assert.isNotNull((Object)jarEntryFile);
        this.fJarEntryFile = jarEntryFile;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JarEntryEditorInput)) {
            return false;
        }
        JarEntryEditorInput other = (JarEntryEditorInput)obj;
        return this.fJarEntryFile.equals(other.fJarEntryFile);
    }

    public int hashCode() {
        return this.fJarEntryFile.hashCode();
    }

    public IPersistableElement getPersistable() {
        if (this.fJarEntryFile instanceof IJarEntryResource) {
            return new IPersistableElement(){

                public void saveState(IMemento memento) {
                    JarEntryEditorInputFactory.saveState(memento, (IJarEntryResource)JarEntryEditorInput.this.fJarEntryFile);
                }

                public String getFactoryId() {
                    return "org.eclipse.jdt.ui.internal.JarEntryEditorInputFactory";
                }
            };
        }
        return null;
    }

    public String getName() {
        return this.fJarEntryFile.getName();
    }

    public String getContentType() {
        return this.fJarEntryFile.getFullPath().getFileExtension();
    }

    public String getToolTipText() {
        if (this.fJarEntryFile instanceof IJarEntryResource) {
            IJarEntryResource jarEntry = (IJarEntryResource)this.fJarEntryFile;
            IPackageFragmentRoot root = jarEntry.getPackageFragmentRoot();
            IPath fullPath = root.getPath().append(this.fJarEntryFile.getFullPath());
            return BasicElementLabels.getPathLabel(fullPath, root.isExternal());
        }
        IPath fullPath = this.fJarEntryFile.getFullPath();
        if (fullPath == null) {
            return null;
        }
        return BasicElementLabels.getPathLabel(fullPath, false);
    }

    public ImageDescriptor getImageDescriptor() {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        return registry.getImageDescriptor(this.getContentType());
    }

    public boolean exists() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public IStorage getStorage() {
        return this.fJarEntryFile;
    }
}

