/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.views.Page;

public class ErrorPage
extends Page {
    private String message;
    private IStatus status;

    public ErrorPage() {
    }

    public ErrorPage(String errorMessage) {
        this.message = errorMessage;
    }

    public ErrorPage(IStatus status) {
        this.status = status;
    }

    @Override
    public void createPart(Composite parent) {
        super.createPart(parent);
        if (this.status != null) {
            this.showStatus(this.status);
        } else {
            String errorString = null;
            errorString = this.message == null ? Messages.ERROR_PAGE_MESSAGE : this.message;
            Label errorLabel = this.toolkit.createLabel(this.form.getBody(), errorString, 64);
            errorLabel.setLayoutData((Object)new TableWrapData(256));
        }
    }

    private void showStatus(IStatus status) {
        StatusSorter sorter = new StatusSorter(status);
        List<IStatus> sorted = sorter.getSortedStatus();
        for (IStatus nextStatus : sorted) {
            Label imageLabel = this.toolkit.createLabel(this.form.getBody(), "");
            imageLabel.setImage(this.getImage(nextStatus.getSeverity()));
            Label messageLabel = this.toolkit.createLabel(this.form.getBody(), nextStatus.getMessage(), 64);
            TableWrapData layoutData = new TableWrapData(256);
            layoutData.indent = 10;
            messageLabel.setLayoutData((Object)layoutData);
        }
    }

    private Image getImage(int severity) {
        switch (severity) {
            case 4: {
                return CheatSheetPlugin.getPlugin().getImage("ERROR");
            }
            case 2: {
                return CheatSheetPlugin.getPlugin().getImage("WARNING");
            }
        }
        return CheatSheetPlugin.getPlugin().getImage("INFORMATION");
    }

    @Override
    protected String getTitle() {
        return Messages.ERROR_LOADING_CHEATSHEET_CONTENT;
    }

    @Override
    public void initialized() {
    }

    private class StatusSorter {
        private List<IStatus> errors = new ArrayList<IStatus>();
        private List<IStatus> warnings = new ArrayList<IStatus>();
        private List<IStatus> info = new ArrayList<IStatus>();

        public StatusSorter(IStatus status) {
            this.sortStatus(status);
        }

        private void sortStatus(IStatus status) {
            if (status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.sortStatus(children[i]);
                    ++i;
                }
            } else {
                switch (status.getSeverity()) {
                    case 4: {
                        this.errors.add(status);
                        break;
                    }
                    case 2: {
                        this.warnings.add(status);
                        break;
                    }
                    default: {
                        this.info.add(status);
                    }
                }
            }
        }

        public List<IStatus> getSortedStatus() {
            ArrayList<IStatus> result = new ArrayList<IStatus>();
            result.addAll(this.errors);
            result.addAll(this.warnings);
            result.addAll(this.info);
            return result;
        }
    }
}

