/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;

class SnippetFinder
extends GenericVisitor {
    private List<Match> fResult = new ArrayList<Match>(2);
    private Match fMatch;
    private ASTNode[] fSnippet;
    private int fIndex;
    private Matcher fMatcher;
    private int fTypes;

    private SnippetFinder(ASTNode[] snippet) {
        super(true);
        this.fSnippet = snippet;
        this.fMatcher = new Matcher();
        this.reset();
    }

    public static Match[] perform(ASTNode start, ASTNode[] snippet) {
        Assert.isTrue((start instanceof AbstractTypeDeclaration || start instanceof AnonymousClassDeclaration ? 1 : 0) != 0);
        SnippetFinder finder = new SnippetFinder(snippet);
        start.accept((ASTVisitor)finder);
        Iterator<Match> iter = finder.fResult.iterator();
        while (iter.hasNext()) {
            Match match = iter.next();
            ASTNode[] nodes = match.getNodes();
            if (nodes.length != 1 || !SnippetFinder.isLeftHandSideOfAssignment(nodes[0])) continue;
            iter.remove();
        }
        return finder.fResult.toArray(new Match[finder.fResult.size()]);
    }

    private static boolean isLeftHandSideOfAssignment(ASTNode node) {
        Assignment assignment = (Assignment)ASTNodes.getParent(node, 7);
        if (assignment != null) {
            Expression leftHandSide = assignment.getLeftHandSide();
            if (leftHandSide == node) {
                return true;
            }
            if (ASTNodes.isParent(node, (ASTNode)leftHandSide)) {
                switch (leftHandSide.getNodeType()) {
                    case 42: {
                        return true;
                    }
                    case 22: {
                        return node == ((FieldAccess)leftHandSide).getName();
                    }
                    case 40: {
                        return node == ((QualifiedName)leftHandSide).getName();
                    }
                    case 47: {
                        return node == ((SuperFieldAccess)leftHandSide).getName();
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        if (++this.fTypes > 1) {
            return false;
        }
        return super.visit(node);
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        --this.fTypes;
        super.endVisit(node);
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        if (++this.fTypes > 1) {
            return false;
        }
        return super.visit(node);
    }

    @Override
    public void endVisit(EnumDeclaration node) {
        --this.fTypes;
        super.endVisit(node);
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        if (++this.fTypes > 1) {
            return false;
        }
        return super.visit(node);
    }

    @Override
    public void endVisit(AnnotationTypeDeclaration node) {
        --this.fTypes;
        super.endVisit(node);
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        if (this.matches(node)) {
            return false;
        }
        if (!this.isResetted()) {
            this.reset();
            if (this.matches(node)) {
                return false;
            }
        }
        return true;
    }

    private boolean matches(ASTNode node) {
        if (this.isSnippetNode(node)) {
            return false;
        }
        if (node.subtreeMatch((ASTMatcher)this.fMatcher, (Object)this.fSnippet[this.fIndex]) && this.fMatch.hasCorrectNesting(node)) {
            this.fMatch.add(node);
            ++this.fIndex;
            if (this.fIndex == this.fSnippet.length) {
                this.fResult.add(this.fMatch);
                this.reset();
            }
            return true;
        }
        return false;
    }

    private boolean isResetted() {
        return this.fIndex == 0 && this.fMatch.isEmpty();
    }

    private void reset() {
        this.fIndex = 0;
        this.fMatch = new Match();
    }

    private boolean isSnippetNode(ASTNode node) {
        int i = 0;
        while (i < this.fSnippet.length) {
            if (node == this.fSnippet[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class Match {
        private List<ASTNode> fNodes = new ArrayList<ASTNode>(10);
        private Map<IVariableBinding, SimpleName> fLocalMappings = new HashMap<IVariableBinding, SimpleName>();

        public void add(ASTNode node) {
            this.fNodes.add(node);
        }

        public boolean hasCorrectNesting(ASTNode node) {
            if (this.fNodes.size() == 0) {
                return true;
            }
            ASTNode parent = node.getParent();
            if (this.fNodes.get(0).getParent() != parent) {
                return false;
            }
            int nodeType = parent.getNodeType();
            return nodeType == 8 || nodeType == 50;
        }

        public ASTNode[] getNodes() {
            return this.fNodes.toArray(new ASTNode[this.fNodes.size()]);
        }

        public void addLocal(IVariableBinding org, SimpleName local) {
            this.fLocalMappings.put(org, local);
        }

        public SimpleName getMappedName(IVariableBinding org) {
            return this.fLocalMappings.get(org);
        }

        public IVariableBinding getMappedBinding(IVariableBinding org) {
            SimpleName name = this.fLocalMappings.get(org);
            return ASTNodes.getVariableBinding((Name)name);
        }

        public boolean isEmpty() {
            return this.fNodes.isEmpty() && this.fLocalMappings.isEmpty();
        }

        public boolean isInvalidNode() {
            ASTNode first = this.fNodes.get(0);
            ASTNode candidate = first.getParent();
            if (candidate == null) {
                return false;
            }
            return candidate.getNodeType() == 31;
        }

        public MethodDeclaration getEnclosingMethod() {
            ASTNode first = this.fNodes.get(0);
            return (MethodDeclaration)ASTNodes.getParent(first, 31);
        }

        public boolean isNodeInStaticContext() {
            ASTNode first = this.fNodes.get(0);
            return ASTResolving.isInStaticContext(first);
        }
    }

    private class Matcher
    extends ASTMatcher {
        private Matcher() {
        }

        public boolean match(SimpleName candidate, Object s) {
            if (!(s instanceof SimpleName)) {
                return false;
            }
            SimpleName snippet = (SimpleName)s;
            if (candidate.isDeclaration() != snippet.isDeclaration()) {
                return false;
            }
            IBinding cb = candidate.resolveBinding();
            IBinding sb = snippet.resolveBinding();
            if (cb == null || sb == null) {
                return false;
            }
            IVariableBinding vcb = ASTNodes.getVariableBinding((Name)candidate);
            IVariableBinding vsb = ASTNodes.getVariableBinding((Name)snippet);
            if (vcb == null || vsb == null) {
                return Bindings.equals(cb, sb);
            }
            if (!vcb.isField() && !vsb.isField() && Bindings.equals((IBinding)vcb.getType(), (IBinding)vsb.getType())) {
                IVariableBinding mappedBinding;
                SimpleName mapped = SnippetFinder.this.fMatch.getMappedName(vsb);
                if (mapped != null && !Bindings.equals((IBinding)vcb, (IBinding)(mappedBinding = ASTNodes.getVariableBinding((Name)mapped)))) {
                    return false;
                }
                SnippetFinder.this.fMatch.addLocal(vsb, candidate);
                return true;
            }
            return Bindings.equals(cb, sb);
        }
    }
}

