/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filebuffers.IPersistableAnnotationModel;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationMap;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public abstract class AbstractMarkerAnnotationModel
extends AnnotationModel
implements IPersistableAnnotationModel {
    private List<Annotation> fDeletedAnnotations = new ArrayList<Annotation>(2);
    private List<IMarkerUpdater> fInstantiatedMarkerUpdaters = null;
    private List<IConfigurationElement> fMarkerUpdaterSpecifications = null;
    private static final String ID = "id";

    protected abstract IMarker[] retrieveMarkers() throws CoreException;

    protected abstract void deleteMarkers(IMarker[] var1) throws CoreException;

    protected abstract void listenToMarkerChanges(boolean var1);

    protected abstract boolean isAcceptable(IMarker var1);

    protected AbstractMarkerAnnotationModel() {
    }

    protected void addMarkerUpdater(IMarkerUpdater markerUpdater) {
        if (!this.fInstantiatedMarkerUpdaters.contains(markerUpdater)) {
            this.fInstantiatedMarkerUpdaters.add(markerUpdater);
        }
    }

    protected void removeMarkerUpdater(IMarkerUpdater markerUpdater) {
        this.fInstantiatedMarkerUpdaters.remove(markerUpdater);
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        return new MarkerAnnotation(marker);
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
    }

    protected Position createPositionFromMarker(IMarker marker) {
        int line;
        int end;
        int start = MarkerUtilities.getCharStart(marker);
        if (start > (end = MarkerUtilities.getCharEnd(marker))) {
            end = start + end;
            start = end - start;
            end -= start;
        }
        if (start == -1 && end == -1 && (line = MarkerUtilities.getLineNumber(marker)) > 0 && this.fDocument != null) {
            try {
                end = start = this.fDocument.getLineOffset(line - 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        if (start > -1 && end > -1) {
            return new Position(start, end - start);
        }
        return null;
    }

    protected final void addMarkerAnnotation(IMarker marker) {
        Position p;
        if (this.isAcceptable(marker) && (p = this.createPositionFromMarker(marker)) != null) {
            try {
                MarkerAnnotation annotation = this.createMarkerAnnotation(marker);
                if (annotation != null) {
                    this.addAnnotation(annotation, p, false);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected void connected() {
        block2: {
            this.listenToMarkerChanges(true);
            try {
                this.catchupWithMarkers();
            }
            catch (CoreException x) {
                if (x.getStatus().getCode() == 368) break block2;
                this.handleCoreException(x, TextEditorMessages.AbstractMarkerAnnotationModel_connected);
            }
        }
        this.fireModelChanged();
    }

    private void installMarkerUpdaters() {
        this.fInstantiatedMarkerUpdaters = new ArrayList<IMarkerUpdater>(2);
        HashMap<String, Integer> markerUpdaterOrderMap = new HashMap<String, Integer>(2);
        LinkedList<IConfigurationElement> markerUpdaterSpecificationsLinkedList = new LinkedList<IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "markerUpdaters");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                markerUpdaterSpecificationsLinkedList.add(elements[i]);
                markerUpdaterOrderMap.put(elements[i].getAttribute(ID), new Integer(i));
                ++i;
            }
            HashMap<String, ArrayList> markerUpdaterRequiredByOrderMap = new HashMap<String, ArrayList>(2);
            int i2 = 0;
            while (i2 < elements.length) {
                IConfigurationElement[] requiredUpdaters = elements[i2].getChildren("required-updater");
                if (requiredUpdaters.length > 0) {
                    int j = 0;
                    while (j < requiredUpdaters.length) {
                        String requiredID = requiredUpdaters[j].getAttribute(ID);
                        if (requiredID == null || markerUpdaterOrderMap.get(requiredID) == null) {
                            String msg = NLSUtility.format(TextEditorMessages.AbstractMarkerAnnotationModel_updaterInvalidDefinition, new Object[]{elements[i2].getAttribute(ID), requiredID});
                            EditorsPlugin.log((IStatus)new Status(4, "org.eclipse.ui", msg));
                        } else {
                            ArrayList requiredByUpdaters = markerUpdaterRequiredByOrderMap.get(requiredID) == null ? new ArrayList(2) : (ArrayList)markerUpdaterRequiredByOrderMap.get(requiredID);
                            if (markerUpdaterRequiredByOrderMap.get(elements[i2].getAttribute(ID)) != null) {
                                ArrayList requiredByList = (ArrayList)markerUpdaterRequiredByOrderMap.get(elements[i2].getAttribute(ID));
                                requiredByUpdaters.addAll(requiredByList);
                            }
                            if (requiredByUpdaters.contains(requiredID)) {
                                String msg = NLSUtility.format(TextEditorMessages.AbstractMarkerAnnotationModel_markerUpdaterCyclicDefinition, new Object[]{elements[i2].getAttribute(ID), requiredID});
                                EditorsPlugin.log((IStatus)new Status(4, "org.eclipse.ui", msg));
                            } else {
                                requiredByUpdaters.add(elements[i2].getAttribute(ID));
                                markerUpdaterRequiredByOrderMap.put(requiredID, requiredByUpdaters);
                                Integer requiredLocation = (Integer)markerUpdaterOrderMap.get(requiredID);
                                if (requiredLocation > (Integer)markerUpdaterOrderMap.get(elements[i2].getAttribute(ID))) {
                                    int newLocation = (Integer)markerUpdaterOrderMap.get(elements[i2].getAttribute(ID)) == 0 ? 0 : (Integer)markerUpdaterOrderMap.get(elements[i2].getAttribute(ID)) - 1;
                                    IConfigurationElement requiredMarker = (IConfigurationElement)markerUpdaterSpecificationsLinkedList.remove(requiredLocation);
                                    markerUpdaterSpecificationsLinkedList.add(newLocation, requiredMarker);
                                    markerUpdaterOrderMap.put(requiredID, new Integer(newLocation));
                                    markerUpdaterOrderMap.put(elements[i2].getAttribute(ID), new Integer(newLocation + 1));
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            this.fMarkerUpdaterSpecifications = new ArrayList<IConfigurationElement>(markerUpdaterSpecificationsLinkedList);
        }
    }

    private void uninstallMarkerUpdaters() {
        if (this.fInstantiatedMarkerUpdaters != null) {
            this.fInstantiatedMarkerUpdaters.clear();
            this.fInstantiatedMarkerUpdaters = null;
        }
        if (this.fMarkerUpdaterSpecifications != null) {
            this.fMarkerUpdaterSpecifications.clear();
            this.fMarkerUpdaterSpecifications = null;
        }
    }

    protected void disconnected() {
        this.listenToMarkerChanges(false);
        this.uninstallMarkerUpdaters();
    }

    public Position getMarkerPosition(IMarker marker) {
        MarkerAnnotation a = this.getMarkerAnnotation(marker);
        if (a != null) {
            return (Position)this.getAnnotationMap().get((Object)a);
        }
        return null;
    }

    protected void modifyMarkerAnnotation(IMarker marker) {
        MarkerAnnotation a = this.getMarkerAnnotation(marker);
        if (a != null) {
            Position p = this.createPositionFromMarker(marker);
            if (p != null) {
                a.update();
                this.modifyAnnotationPosition(a, p, false);
            }
        } else {
            this.addMarkerAnnotation(marker);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void removeAnnotations(List<? extends Annotation> annotations, boolean fireModelChanged, boolean modelInitiated) {
        if (annotations != null && annotations.size() > 0) {
            ArrayList<Annotation> markerAnnotations = new ArrayList<Annotation>();
            for (Annotation annotation : annotations) {
                if (annotation instanceof MarkerAnnotation) {
                    markerAnnotations.add(annotation);
                }
                this.removeAnnotation(annotation, false);
            }
            if (markerAnnotations.size() > 0) {
                if (modelInitiated) {
                    this.listenToMarkerChanges(false);
                    try {
                        void var6_9;
                        IMarker[] m = new IMarker[markerAnnotations.size()];
                        boolean bl = false;
                        while (var6_9 < m.length) {
                            MarkerAnnotation ma = (MarkerAnnotation)((Object)markerAnnotations.get((int)var6_9));
                            m[var6_9] = ma.getMarker();
                            ++var6_9;
                        }
                        this.deleteMarkers(m);
                    }
                    catch (CoreException x) {
                        this.handleCoreException(x, TextEditorMessages.AbstractMarkerAnnotationModel_removeAnnotations);
                    }
                    this.listenToMarkerChanges(true);
                } else {
                    this.fDeletedAnnotations.addAll(markerAnnotations);
                }
            }
            if (fireModelChanged) {
                this.fireModelChanged();
            }
        }
    }

    protected final void removeMarkerAnnotation(IMarker marker) {
        MarkerAnnotation a = this.getMarkerAnnotation(marker);
        if (a != null) {
            this.removeAnnotation(a, false);
        }
    }

    private void catchupWithMarkers() throws CoreException {
        Iterator e = this.getAnnotationIterator(false);
        while (e.hasNext()) {
            Annotation a = (Annotation)e.next();
            if (!(a instanceof MarkerAnnotation)) continue;
            this.removeAnnotation(a, false);
        }
        IMarker[] markers = this.retrieveMarkers();
        if (markers != null) {
            int i = 0;
            while (i < markers.length) {
                this.addMarkerAnnotation(markers[i]);
                ++i;
            }
        }
    }

    public final MarkerAnnotation getMarkerAnnotation(IMarker marker) {
        Iterator e = this.getAnnotationIterator(false);
        while (e.hasNext()) {
            MarkerAnnotation a;
            Object o = e.next();
            if (!(o instanceof MarkerAnnotation) || !marker.equals((Object)(a = (MarkerAnnotation)((Object)o)).getMarker())) continue;
            return a;
        }
        return null;
    }

    private IMarkerUpdater createMarkerUpdater(IConfigurationElement element) {
        try {
            return (IMarkerUpdater)element.createExecutableExtension("class");
        }
        catch (CoreException x) {
            this.handleCoreException(x, TextEditorMessages.AbstractMarkerAnnotationModel_createMarkerUpdater);
            return null;
        }
    }

    private void checkMarkerUpdaters(IMarker marker) {
        ArrayList<IConfigurationElement> toBeDeleted = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < this.fMarkerUpdaterSpecifications.size()) {
            IConfigurationElement spec = this.fMarkerUpdaterSpecifications.get(i);
            String markerType = spec.getAttribute("markerType");
            if (markerType == null || MarkerUtilities.isMarkerType(marker, markerType)) {
                toBeDeleted.add(spec);
                IMarkerUpdater updater = this.createMarkerUpdater(spec);
                if (updater != null) {
                    this.addMarkerUpdater(updater);
                }
            }
            ++i;
        }
        i = 0;
        while (i < toBeDeleted.size()) {
            this.fMarkerUpdaterSpecifications.remove(toBeDeleted.get(i));
            ++i;
        }
    }

    @Deprecated
    public boolean updateMarker(IMarker marker, IDocument document, Position position) throws CoreException {
        if (this.fMarkerUpdaterSpecifications == null) {
            this.installMarkerUpdaters();
        }
        if (!this.fMarkerUpdaterSpecifications.isEmpty()) {
            this.checkMarkerUpdaters(marker);
        }
        boolean isOK = true;
        int i = 0;
        while (i < this.fInstantiatedMarkerUpdaters.size()) {
            IMarkerUpdater updater = this.fInstantiatedMarkerUpdaters.get(i);
            String markerType = updater.getMarkerType();
            if (markerType == null || MarkerUtilities.isMarkerType(marker, markerType)) {
                if (position == null) {
                    position = this.createPositionFromMarker(marker);
                }
                isOK = isOK && updater.updateMarker(marker, document, position);
            }
            ++i;
        }
        return isOK;
    }

    public boolean updateMarker(IDocument document, IMarker marker, Position position) throws CoreException {
        this.listenToMarkerChanges(false);
        try {
            boolean bl = this.updateMarker(marker, document, position);
            return bl;
        }
        finally {
            this.listenToMarkerChanges(true);
        }
    }

    public void updateMarkers(IDocument document) throws CoreException {
        Assert.isTrue((this.fDocument == document ? 1 : 0) != 0);
        IAnnotationMap annotationMap = this.getAnnotationMap();
        if (annotationMap.size() == 0 && this.fDeletedAnnotations.size() == 0) {
            return;
        }
        if (this.fMarkerUpdaterSpecifications == null) {
            this.installMarkerUpdaters();
        }
        this.listenToMarkerChanges(false);
        try {
            Iterator e = this.getAnnotationIterator(false);
            while (e.hasNext()) {
                Position position;
                MarkerAnnotation a;
                IMarker marker;
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation) || this.updateMarker(marker = (a = (MarkerAnnotation)((Object)o)).getMarker(), document, position = (Position)annotationMap.get((Object)a)) || this.fDeletedAnnotations.contains((Object)a)) continue;
                this.fDeletedAnnotations.add(a);
            }
            if (!this.fDeletedAnnotations.isEmpty()) {
                this.removeAnnotations(this.fDeletedAnnotations, true, true);
                this.fDeletedAnnotations.clear();
            }
        }
        finally {
            this.listenToMarkerChanges(true);
        }
    }

    public void resetMarkers() {
        MarkerAnnotation a;
        Position p;
        Iterator<Annotation> e = this.getAnnotationIterator(false);
        while (e.hasNext()) {
            Object e2 = e.next();
            if (!(e2 instanceof MarkerAnnotation) || (p = this.createPositionFromMarker((a = (MarkerAnnotation)((Object)e2)).getMarker())) == null) continue;
            this.removeAnnotation(a, false);
            try {
                this.addAnnotation(a, p, false);
            }
            catch (BadLocationException badLocationException) {}
        }
        for (Annotation annotation : this.fDeletedAnnotations) {
            if (!(annotation instanceof MarkerAnnotation) || (p = this.createPositionFromMarker((a = (MarkerAnnotation)annotation).getMarker())) == null) continue;
            try {
                this.addAnnotation(a, p, false);
            }
            catch (BadLocationException badLocationException) {}
        }
        this.fDeletedAnnotations.clear();
        this.fireModelChanged();
    }

    public void commit(IDocument document) throws CoreException {
        this.updateMarkers(document);
    }

    public void revert(IDocument document) {
        this.resetMarkers();
    }

    public void reinitialize(IDocument document) {
        this.resetMarkers();
    }
}

