/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.workingsets;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class WorkingSetsContentProvider
implements ICommonContentProvider {
    public static final String EXTENSION_ID = "org.eclipse.ui.navigator.resources.workingSets";
    public static final String SHOW_TOP_LEVEL_WORKING_SETS = "org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets";
    private static final Object[] NO_CHILDREN = new Object[0];
    private WorkingSetHelper helper;
    private IAggregateWorkingSet workingSetRoot;
    private IExtensionStateModel extensionStateModel;
    private CommonNavigator projectExplorer;
    private CommonViewer viewer;
    private IPropertyChangeListener rootModeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (WorkingSetsContentProvider.SHOW_TOP_LEVEL_WORKING_SETS.equals(event.getProperty())) {
                WorkingSetsContentProvider.this.updateRootMode();
            }
        }
    };

    public void init(ICommonContentExtensionSite aConfig) {
        NavigatorContentService cs = (NavigatorContentService)aConfig.getService();
        this.viewer = (CommonViewer)cs.getViewer();
        this.projectExplorer = this.viewer.getCommonNavigator();
        this.extensionStateModel = aConfig.getExtensionStateModel();
        this.extensionStateModel.addPropertyChangeListener(this.rootModeListener);
        this.updateRootMode();
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkingSet) {
            IWorkingSet workingSet = (IWorkingSet)parentElement;
            if (workingSet.isAggregateWorkingSet() && this.projectExplorer != null) {
                switch (this.projectExplorer.getRootMode()) {
                    case 0: {
                        return ((IAggregateWorkingSet)workingSet).getComponents();
                    }
                    case 1: {
                        return this.getWorkingSetElements(workingSet);
                    }
                }
            }
            return this.getWorkingSetElements(workingSet);
        }
        return NO_CHILDREN;
    }

    private IAdaptable[] getWorkingSetElements(IWorkingSet workingSet) {
        IAdaptable[] children = workingSet.getElements();
        int i = 0;
        while (i < children.length) {
            Object resource = children[i].getAdapter(IResource.class);
            if (resource instanceof IProject) {
                children[i] = (IProject)resource;
            }
            ++i;
        }
        return children;
    }

    public Object getParent(Object element) {
        if (this.helper != null) {
            return this.helper.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.helper = null;
        this.extensionStateModel.removePropertyChangeListener(this.rootModeListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IWorkingSet) {
            IWorkingSet rootSet = (IWorkingSet)newInput;
            this.helper = new WorkingSetHelper(rootSet);
        }
    }

    private void updateRootMode() {
        if (this.projectExplorer == null) {
            return;
        }
        if (this.extensionStateModel.getBooleanProperty(SHOW_TOP_LEVEL_WORKING_SETS)) {
            this.projectExplorer.setRootMode(0);
        } else {
            this.projectExplorer.setRootMode(1);
        }
    }

    protected class WorkingSetHelper {
        private final IWorkingSet workingSet;
        private final Map<IAdaptable, IAdaptable> parents = new WeakHashMap<IAdaptable, IAdaptable>();

        public WorkingSetHelper(IWorkingSet set) {
            this.workingSet = set;
            if (this.workingSet.isAggregateWorkingSet()) {
                IWorkingSet[] components;
                IAggregateWorkingSet aggregateSet = (IAggregateWorkingSet)this.workingSet;
                if (WorkingSetsContentProvider.this.workingSetRoot == null) {
                    WorkingSetsContentProvider.this.workingSetRoot = aggregateSet;
                }
                IWorkingSet[] iWorkingSetArray = components = aggregateSet.getComponents();
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable[] elements;
                    IWorkingSet component = iWorkingSetArray[n2];
                    IAdaptable[] iAdaptableArray = elements = WorkingSetsContentProvider.this.getWorkingSetElements(component);
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAdaptable element = iAdaptableArray[n4];
                        this.parents.put(element, (IAdaptable)component);
                        ++n4;
                    }
                    this.parents.put((IAdaptable)component, (IAdaptable)aggregateSet);
                    ++n2;
                }
            } else {
                IAdaptable[] elements = WorkingSetsContentProvider.this.getWorkingSetElements(this.workingSet);
                int elementsIndex = 0;
                while (elementsIndex < elements.length) {
                    this.parents.put(elements[elementsIndex], (IAdaptable)this.workingSet);
                    ++elementsIndex;
                }
            }
        }

        public Object getParent(Object element) {
            if (element instanceof IWorkingSet && element != WorkingSetsContentProvider.this.workingSetRoot) {
                return WorkingSetsContentProvider.this.workingSetRoot;
            }
            return this.parents.get(element);
        }
    }
}

