/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public abstract class RuntimeClasspathAction
extends SelectionListenerAction {
    public static final int DEFAULT = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int MOVE = 3;
    private IClasspathViewer fViewer;
    private Button fButton;
    private Shell fShell;

    public RuntimeClasspathAction(String label, IClasspathViewer viewer) {
        super(label);
        this.setViewer(viewer);
    }

    public void setViewer(IClasspathViewer viewer) {
        if (this.fViewer != null) {
            this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fViewer = viewer;
        if (this.fViewer != null) {
            this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.update();
        }
    }

    protected IClasspathViewer getViewer() {
        return this.fViewer;
    }

    protected List<IRuntimeClasspathEntry> getOrderedSelection() {
        ArrayList<IRuntimeClasspathEntry> targets = new ArrayList<IRuntimeClasspathEntry>();
        List selection = ((IStructuredSelection)this.getViewer().getSelection()).toList();
        IRuntimeClasspathEntry[] entries = this.getViewer().getEntries();
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry target = entries[i];
            if (selection.contains(target)) {
                targets.add(target);
            }
            ++i;
        }
        return targets;
    }

    protected List<IRuntimeClasspathEntry> getEntriesAsList() {
        IRuntimeClasspathEntry[] entries = this.getViewer().getEntries();
        ArrayList<IRuntimeClasspathEntry> list = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            list.add(entries[i]);
            ++i;
        }
        return list;
    }

    protected void setEntries(List<IRuntimeClasspathEntry> list) {
        this.getViewer().setEntries(list.toArray(new IRuntimeClasspathEntry[list.size()]));
        this.getViewer().setSelection(this.getViewer().getSelection());
    }

    protected boolean isIndexSelected(IStructuredSelection selection, int index) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator entries = selection.iterator();
        List<IRuntimeClasspathEntry> list = this.getEntriesAsList();
        while (entries.hasNext()) {
            Object next = entries.next();
            if (list.indexOf(next) != index) continue;
            return true;
        }
        return false;
    }

    public void setButton(Button button) {
        this.fButton = button;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RuntimeClasspathAction.this.run();
            }
        });
        this.fButton.setEnabled(false);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.fButton != null) {
            this.fButton.setEnabled(enabled);
        }
    }

    protected void update() {
        this.selectionChanged((IStructuredSelection)this.getViewer().getSelection());
    }

    protected Shell getShell() {
        if (this.fShell == null) {
            this.fShell = this.getViewer().getShell();
        }
        return this.fShell;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.getViewer().updateSelection(this.getActionType(), selection);
    }

    protected int getActionType() {
        return 0;
    }
}

