/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IExceptionAttribute;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.osgi.framework.BundleException;

public class PackageFinder {
    public static Set<String> findPackagesInClassFiles(IClassFile[] files, IProgressMonitor monitor) {
        HashSet<String> packages = new HashSet<String>();
        monitor.beginTask(PDEUIMessages.PackageFinder_taskName, files.length);
        int i = 0;
        while (i < files.length) {
            IClassFileReader reader = ToolFactory.createDefaultClassFileReader((IClassFile)files[i], (int)65535);
            if (reader != null) {
                PackageFinder.computeReferencedTypes(reader, packages);
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        return packages;
    }

    static void computeReferencedTypes(IClassFileReader cfr, Set<String> packages) {
        char[] scn;
        char[][] interfaces = cfr.getInterfaceNames();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                packages.add(PackageFinder.getPackage(new String(interfaces[i]).replace('/', '.')));
                ++i;
            }
        }
        if ((scn = cfr.getSuperclassName()) != null) {
            packages.add(PackageFinder.getPackage(new String(scn).replace('/', '.')));
        }
        IFieldInfo[] fieldInfo = cfr.getFieldInfos();
        int i = 0;
        while (i < fieldInfo.length) {
            String fieldName = new String(fieldInfo[i].getDescriptor());
            if (!PackageFinder.isPrimitiveTypeSignature(fieldName)) {
                String fieldDescriptor = PackageFinder.extractFullyQualifiedTopLevelType(fieldName);
                packages.add(PackageFinder.getPackage(new String(fieldDescriptor)));
            }
            ++i;
        }
        IMethodInfo[] methodInfo = cfr.getMethodInfos();
        int i2 = 0;
        while (i2 < methodInfo.length) {
            IExceptionAttribute exceptionAttribute = methodInfo[i2].getExceptionAttribute();
            if (exceptionAttribute != null) {
                char[][] exceptionNames = exceptionAttribute.getExceptionNames();
                int j = 0;
                while (j < exceptionNames.length) {
                    packages.add(PackageFinder.getPackage(new String(exceptionNames[j]).replace('/', '.')));
                    ++j;
                }
            }
            String descriptor = new String(methodInfo[i2].getDescriptor());
            String[] parameterTypes = Signature.getParameterTypes((String)descriptor);
            int j = 0;
            while (j < parameterTypes.length) {
                if (!PackageFinder.isPrimitiveTypeSignature(parameterTypes[j])) {
                    packages.add(PackageFinder.getPackage(new String(PackageFinder.extractFullyQualifiedTopLevelType(parameterTypes[j]))));
                }
                ++j;
            }
            String returnType = Signature.getReturnType((String)descriptor);
            if (!PackageFinder.isPrimitiveTypeSignature(returnType)) {
                returnType = PackageFinder.extractFullyQualifiedTopLevelType(returnType);
                packages.add(PackageFinder.getPackage(returnType));
            }
            ++i2;
        }
        IConstantPool pool = cfr.getConstantPool();
        int length = pool.getConstantPoolCount();
        int i3 = 1;
        while (i3 < length) {
            switch (pool.getEntryKind(i3)) {
                case 7: {
                    IConstantPoolEntry entry = pool.decodeEntry(i3);
                    String className = new String(entry.getClassInfoName()).replace('/', '.');
                    className = className.indexOf(59) >= 0 ? PackageFinder.extractFullyQualifiedTopLevelType(className) : className;
                    packages.add(PackageFinder.getPackage(className));
                    break;
                }
                case 12: {
                    IConstantPoolEntry entry = pool.decodeEntry(i3);
                    int descIndex = entry.getNameAndTypeInfoDescriptorIndex();
                    if (pool.getEntryKind(descIndex) != 1) break;
                    entry = pool.decodeEntry(descIndex);
                    char[] type = entry.getUtf8Value();
                    if (type[0] == '(') {
                        String descriptor = new String(type);
                        String[] parameterTypes = Signature.getParameterTypes((String)descriptor);
                        int j = 0;
                        while (j < parameterTypes.length) {
                            if (!PackageFinder.isPrimitiveTypeSignature(parameterTypes[j])) {
                                packages.add(PackageFinder.getPackage(PackageFinder.extractFullyQualifiedTopLevelType(parameterTypes[j])));
                            }
                            ++j;
                        }
                        String returnType = Signature.getReturnType((String)descriptor);
                        if (PackageFinder.isPrimitiveTypeSignature(returnType)) break;
                        returnType = PackageFinder.extractFullyQualifiedTopLevelType(returnType);
                        packages.add(PackageFinder.getPackage(returnType));
                        break;
                    }
                    String typeString = new String(type);
                    if (PackageFinder.isPrimitiveTypeSignature(typeString)) break;
                    packages.add(PackageFinder.getPackage(PackageFinder.extractFullyQualifiedTopLevelType(typeString)));
                }
            }
            ++i3;
        }
        packages.remove("");
    }

    static boolean isPrimitiveTypeSignature(String typeSig) {
        if (typeSig.length() >= 2 && typeSig.startsWith("[") && PackageFinder.isPrimitiveTypeSignature(typeSig.substring(1, typeSig.length()))) {
            return true;
        }
        if (typeSig.length() != 1) {
            return false;
        }
        return typeSig.equals("V") || typeSig.equals("Z") || typeSig.equals("B") || typeSig.equals("C") || typeSig.equals("D") || typeSig.equals("F") || typeSig.equals("I") || typeSig.equals("J") || typeSig.equals("S");
    }

    static String extractFullyQualifiedTopLevelType(String typeName) {
        int innerClassIndicator = (typeName = typeName.replace('/', '.')).indexOf(36);
        typeName = innerClassIndicator > 0 ? typeName.substring(0, innerClassIndicator).concat(";") : typeName;
        typeName = Signature.toString((String)typeName);
        typeName = typeName.endsWith("[]") ? typeName.substring(0, typeName.length() - 2) : typeName;
        return typeName;
    }

    static String getPackage(String classType) {
        int period = classType.lastIndexOf(46);
        return period == -1 ? "" : classType.substring(0, period);
    }

    public static IClassFile[] getClassFiles(IProject project, IBundlePluginModelBase base) {
        ArrayList<IClassFile> classFiles = new ArrayList<IClassFile>();
        IBundle bundle = base.getBundleModel().getBundle();
        String value = bundle.getHeader("Bundle-ClassPath");
        if (value == null) {
            value = ".";
        }
        ManifestElement[] elems = null;
        try {
            elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
        }
        catch (BundleException bundleException) {
            return new IClassFile[0];
        }
        int i = 0;
        while (i < elems.length) {
            String lib = elems[i].getValue();
            IResource res = project.findMember(lib);
            if (res != null) {
                PackageFinder.addClassFilesFromResource(res, classFiles);
            }
            ++i;
        }
        return classFiles.toArray(new IClassFile[classFiles.size()]);
    }

    private static void addClassFilesFromResource(IResource res, List<IClassFile> classFiles) {
        if (res == null) {
            return;
        }
        Stack<IResource> stack = new Stack<IResource>();
        if (res instanceof IContainer) {
            stack.push(res);
            while (!stack.isEmpty()) {
                try {
                    IResource[] children = ((IContainer)stack.pop()).members();
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IFile && "class".equals(children[i].getFileExtension())) {
                            classFiles.add(JavaCore.createClassFileFrom((IFile)((IFile)children[i])));
                        } else if (children[i] instanceof IContainer) {
                            stack.push(children[i]);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        } else if (res instanceof IFile) {
            if (res.getFileExtension().equals("jar") || res.getFileExtension().equals("zip")) {
                IPackageFragmentRoot root = JavaCore.create((IProject)res.getProject()).getPackageFragmentRoot(res);
                if (root == null) {
                    return;
                }
                try {
                    IJavaElement[] children = root.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IPackageFragment) {
                            IPackageFragment frag = (IPackageFragment)children[i];
                            IClassFile[] files = frag.getClassFiles();
                            int j = 0;
                            while (j < files.length) {
                                classFiles.add(files[j]);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else if (res.getFileExtension().equals("class")) {
                JavaCore.createClassFileFrom((IFile)((IFile)res));
            }
        }
    }
}

