/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.ecl.impl.AbstractActionService;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.GetTableData;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class GetTableDataService
extends AbstractActionService {
    private static final String DEFAULT_COLUMN = "text";
    private static final String CHECKED_COLUMN = "checked";

    @Override
    protected Object exec(Command command) throws CoreException {
        final GetTableData gtd = (GetTableData)command;
        ControlHandler control = gtd.getControl();
        Element tableElement = TeslaBridge.find(control);
        final Widget table = ((SWTUIElement)((SWTUIProcessor)TeslaBridge.getClient().getProcessor(SWTUIProcessor.class)).getMapper().get((Element)tableElement)).widget;
        if (!(table instanceof Tree) && !(table instanceof Table)) {
            throw new CoreException(TeslaImplPlugin.err("'get-table-data' can be used only on table or tree"));
        }
        final org.eclipse.rcptt.ecl.data.objects.Table data = ObjectsFactory.eINSTANCE.createTable();
        table.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                GetTableDataService.getTableData(data, table, gtd.isIncludeChecked(), gtd.isExcludeHidden());
            }
        });
        return data;
    }

    private static void getTableData(org.eclipse.rcptt.ecl.data.objects.Table table, Widget widget, boolean includeChecked, boolean excludeHidden) {
        Widget[] columns;
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Integer> columnIndices = new ArrayList<Integer>();
        if (includeChecked) {
            columnNames.add(CHECKED_COLUMN);
        }
        if ((columns = TableTreeUtil.getColumns((Widget)widget)).length == 0) {
            columnNames.add(DEFAULT_COLUMN);
        } else {
            int i = 0;
            while (i < columns.length) {
                Widget column = columns[i];
                if (!excludeHidden || TableTreeUtil.getColumnWidth((Widget)column) != 0) {
                    columnNames.add(TableTreeUtil.getName((Widget)column));
                    columnIndices.add(i);
                }
                ++i;
            }
        }
        table.getColumns().addAll(columnNames);
        Item[] itemArray = TableTreeUtil.getItems((Widget)widget);
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            table.getRows().add((Object)GetTableDataService.toRow(item, includeChecked, columnIndices));
            ++n2;
        }
    }

    private static Row toRow(Item item, boolean includeChecked, List<Integer> columnIndices) {
        Row result = ObjectsFactory.eINSTANCE.createRow();
        if (includeChecked) {
            result.getValues().add((Object)Boolean.toString(TableTreeUtil.isChecked((Widget)item)));
        }
        if (columnIndices.isEmpty()) {
            result.getValues().add((Object)TableTreeUtil.getValue((Item)item));
        } else {
            for (int index : columnIndices) {
                result.getValues().add((Object)TableTreeUtil.getValue((Item)item, (int)index));
            }
        }
        Item[] itemArray = TableTreeUtil.getChildren((Widget)item);
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item child = itemArray[n2];
            result.getChildren().add((Object)GetTableDataService.toRow(child, includeChecked, columnIndices));
            ++n2;
        }
        return result;
    }
}

