/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeConfig;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class MergeTargetSelectionDialog
extends AbstractBranchSelectionDialog {
    private boolean mergeSquash;
    private MergeCommand.FastForwardMode fastForwardMode;
    private boolean mergeCommit;

    public MergeTargetSelectionDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, MergeTargetSelectionDialog.getMergeTarget(repo), 0x4E | MergeTargetSelectionDialog.getSelectSetting(repo));
        MergeConfig config = MergeConfig.getConfigForCurrentBranch((Repository)repo);
        this.fastForwardMode = config.getFastForwardMode();
        this.mergeSquash = config.isSquash();
        this.mergeCommit = this.mergeSquash ? false : config.isCommit();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.MergeTargetSelectionDialog_ButtonMerge);
    }

    @Override
    protected String getMessageText() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.MergeTargetSelectionDialog_SelectRefWithBranch, branch);
        }
        return UIText.MergeTargetSelectionDialog_SelectRef;
    }

    @Override
    protected String getTitle() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.MergeTargetSelectionDialog_TitleMergeWithBranch, branch);
        }
        return UIText.MergeTargetSelectionDialog_TitleMerge;
    }

    @Override
    protected void refNameSelected(String refName) {
        boolean currentSelected;
        boolean tagSelected = refName != null && refName.startsWith("refs/tags/");
        boolean branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        try {
            currentSelected = refName != null && refName.equals(this.repo.getFullBranch());
        }
        catch (IOException iOException) {
            currentSelected = false;
        }
        this.getButton(0).setEnabled(!currentSelected && (branchSelected || tagSelected));
    }

    @Override
    protected void createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)main);
        Group mergeTypeGroup = new Group(main, 0);
        mergeTypeGroup.setText(UIText.MergeTargetSelectionDialog_MergeTypeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)mergeTypeGroup);
        mergeTypeGroup.setLayout((Layout)new GridLayout(1, false));
        Button commit = new Button((Composite)mergeTypeGroup, 16);
        if (this.mergeCommit) {
            commit.setSelection(true);
        }
        commit.setText(UIText.MergeTargetSelectionDialog_MergeTypeCommitButton);
        commit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    MergeTargetSelectionDialog.this.mergeSquash = false;
                    MergeTargetSelectionDialog.this.mergeCommit = true;
                }
            }
        });
        Button noCommit = new Button((Composite)mergeTypeGroup, 16);
        if (!this.mergeCommit && !this.mergeSquash) {
            noCommit.setSelection(true);
        }
        noCommit.setText(UIText.MergeTargetSelectionDialog_MergeTypeNoCommitButton);
        noCommit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    MergeTargetSelectionDialog.this.mergeSquash = false;
                    MergeTargetSelectionDialog.this.mergeCommit = false;
                }
            }
        });
        Button squash = new Button((Composite)mergeTypeGroup, 16);
        if (this.mergeSquash) {
            squash.setSelection(true);
        }
        squash.setText(UIText.MergeTargetSelectionDialog_MergeTypeSquashButton);
        squash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    MergeTargetSelectionDialog.this.mergeSquash = true;
                    MergeTargetSelectionDialog.this.mergeCommit = false;
                }
            }
        });
        Group fastForwardGroup = new Group(main, 0);
        fastForwardGroup.setText(UIText.MergeTargetSelectionDialog_FastForwardGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fastForwardGroup);
        fastForwardGroup.setLayout((Layout)new GridLayout(1, false));
        this.createFastForwardButton(fastForwardGroup, UIText.MergeTargetSelectionDialog_FastForwardButton, MergeCommand.FastForwardMode.FF);
        this.createFastForwardButton(fastForwardGroup, UIText.MergeTargetSelectionDialog_NoFastForwardButton, MergeCommand.FastForwardMode.NO_FF);
        this.createFastForwardButton(fastForwardGroup, UIText.MergeTargetSelectionDialog_OnlyFastForwardButton, MergeCommand.FastForwardMode.FF_ONLY);
    }

    private void createFastForwardButton(Group grp, String text, final MergeCommand.FastForwardMode ffMode) {
        Button btn = new Button((Composite)grp, 16);
        btn.setText(text);
        btn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    MergeTargetSelectionDialog.this.fastForwardMode = ffMode;
                }
            }
        });
        btn.setSelection(this.fastForwardMode == ffMode);
    }

    public boolean isMergeSquash() {
        return this.mergeSquash;
    }

    public MergeCommand.FastForwardMode getFastForwardMode() {
        return this.fastForwardMode;
    }

    public boolean isCommit() {
        return this.mergeCommit;
    }
}

