/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;

public class TypeChangeCorrectionProposal
extends LinkedCorrectionProposal {
    private final IBinding fBinding;
    private final CompilationUnit fAstRoot;
    private final ITypeBinding fNewType;
    private final ITypeBinding[] fTypeProposals;

    public TypeChangeCorrectionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean offerSuperTypeProposals, int relevance) {
        super("", targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        Assert.isTrue((binding != null && (binding.getKind() == 4 || binding.getKind() == 3) && Bindings.isDeclarationBinding(binding) ? 1 : 0) != 0);
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        if (offerSuperTypeProposals) {
            this.fTypeProposals = ASTResolving.getRelaxingTypes(astRoot.getAST(), newType);
            this.sortTypes(this.fTypeProposals);
            this.fNewType = this.fTypeProposals[0];
        } else {
            this.fNewType = newType;
            this.fTypeProposals = null;
        }
        String typeName = BindingLabelProvider.getBindingLabel((IBinding)this.fNewType, JavaElementLabels.ALL_DEFAULT);
        if (binding.getKind() == 3) {
            IVariableBinding varBinding = (IVariableBinding)binding;
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(varBinding.getName()), BasicElementLabels.getJavaElementName(typeName)};
            if (varBinding.isField()) {
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_field_name, args));
            } else if (astRoot.findDeclaringNode(binding) instanceof SingleVariableDeclaration) {
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_param_name, args));
            } else {
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_variable_name, args));
            }
        } else {
            Object[] args = new String[]{binding.getName(), typeName};
            this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_method_name, args));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        CompilationUnit newRoot = this.fAstRoot;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            MethodDeclaration methodDecl;
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = this.createImportRewrite(newRoot);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(newRoot, declNode.getStartPosition(), imports);
            Type type = imports.addImport(this.fNewType, ast, (ImportRewrite.ImportRewriteContext)context);
            if (declNode instanceof MethodDeclaration) {
                TagElement returnTag;
                methodDecl = (MethodDeclaration)declNode;
                Type origReturnType = methodDecl.getReturnType2();
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)type, null);
                DimensionRewrite.removeAllChildren((ASTNode)methodDecl, MethodDeclaration.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                Javadoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null && origReturnType != null && origReturnType.isPrimitiveType() && ((PrimitiveType)origReturnType).getPrimitiveTypeCode() == PrimitiveType.VOID && (returnTag = JavadocTagsSubProcessor.findTag(javadoc, "@return", null)) == null) {
                    returnTag = ast.newTagElement();
                    returnTag.setTagName("@return");
                    TextElement commentStart = ast.newTextElement();
                    returnTag.fragments().add(commentStart);
                    this.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
                    ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, returnTag, null);
                }
            } else if (declNode instanceof AnnotationTypeMemberDeclaration) {
                methodDecl = (AnnotationTypeMemberDeclaration)declNode;
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)AnnotationTypeMemberDeclaration.TYPE_PROPERTY, (Object)type, null);
            } else if (declNode instanceof VariableDeclarationFragment) {
                VariableDeclarationStatement varDecl;
                VariableDeclarationFragment placeholder;
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    if (fieldDecl.fragments().size() > 1 && fieldDecl.getParent() instanceof AbstractTypeDeclaration) {
                        placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        FieldDeclaration newField = ast.newFieldDeclaration(placeholder);
                        newField.setType(type);
                        AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)fieldDecl.getParent();
                        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)typeDecl, typeDecl.getBodyDeclarationsProperty());
                        if (fieldDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newField, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newField, parent, null);
                        }
                    } else {
                        rewrite.set((ASTNode)fieldDecl, (StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY, (Object)type, null);
                        DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                    }
                } else if (parent instanceof VariableDeclarationStatement) {
                    varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        VariableDeclarationStatement newStat = ast.newVariableDeclarationStatement(placeholder);
                        newStat.setType(type);
                        ListRewrite listRewrite = rewrite.getListRewrite(varDecl.getParent(), Block.STATEMENTS_PROPERTY);
                        if (varDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newStat, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newStat, parent, null);
                        }
                    } else {
                        rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY, (Object)type, null);
                        DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                    }
                } else if (parent instanceof VariableDeclarationExpression) {
                    varDecl = (VariableDeclarationExpression)parent;
                    rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY, (Object)type, null);
                    DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                }
            } else if (declNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)declNode;
                rewrite.set((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, (Object)type, null);
                DimensionRewrite.removeAllChildren(declNode, SingleVariableDeclaration.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
            }
            this.addLinkedPosition(rewrite.track((ASTNode)type), true, "type");
            if (this.fTypeProposals != null) {
                int i = 0;
                while (i < this.fTypeProposals.length) {
                    this.addLinkedPositionProposal("type", this.fTypeProposals[i]);
                    ++i;
                }
            }
            return rewrite;
        }
        return null;
    }

    private void sortTypes(ITypeBinding[] typeProposals) {
        ITypeBinding oldType = this.fBinding instanceof IMethodBinding ? ((IMethodBinding)this.fBinding).getReturnType() : ((IVariableBinding)this.fBinding).getType();
        if (!oldType.isParameterizedType()) {
            return;
        }
        final ITypeBinding oldTypeDeclaration = oldType.getTypeDeclaration();
        Arrays.sort(typeProposals, new Comparator<ITypeBinding>(){

            @Override
            public int compare(ITypeBinding o1, ITypeBinding o2) {
                return this.rank(o2) - this.rank(o1);
            }

            private int rank(ITypeBinding type) {
                if (type.getTypeDeclaration().equals((Object)oldTypeDeclaration)) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

