/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.internal.ui.refactoring.model.ModelMessages;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RefactoringDescriptorViewer
extends Viewer {
    protected final Browser fBrowser;
    private RefactoringDescriptorProxy fDescriptor = null;

    public RefactoringDescriptorViewer(Composite parent, int style) {
        Assert.isNotNull((Object)parent);
        this.fBrowser = new Browser(parent, style);
        this.fBrowser.setJavascriptEnabled(false);
        Display display = parent.getDisplay();
        this.fBrowser.setForeground(display.getSystemColor(24));
        this.fBrowser.setBackground(display.getSystemColor(25));
    }

    public Control getControl() {
        return this.fBrowser;
    }

    public Object getInput() {
        return this.fDescriptor;
    }

    protected String getInputText(RefactoringDescriptorProxy proxy) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0);
        if (proxy != null) {
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)HTMLPrinter.convertToHTMLContent((String)proxy.getDescription()));
            RefactoringDescriptor descriptor = proxy.requestDescriptor((IProgressMonitor)new NullProgressMonitor());
            if (descriptor != null) {
                String comment = descriptor.getComment();
                if (comment != null && !"".equals(comment)) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (String)HTMLPrinter.convertToHTMLContent((String)comment));
                }
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                int flags = descriptor.getFlags();
                if ((flags & 1) > 0) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)ModelMessages.RefactoringDescriptorViewer_breaking_change_message);
                }
                if ((flags & 2) > 0) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)ModelMessages.RefactoringDescriptorViewer_structural_change_message);
                }
                if ((flags & 4) > 0) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)ModelMessages.RefactoringDescriptorViewer_closure_change_message);
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
            }
        }
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    public ISelection getSelection() {
        return new TextSelection(0, 0);
    }

    public void refresh() {
        String text = this.getInputText(this.fDescriptor);
        if (text != null && text.length() > 0 && (this.fBrowser.getShell().getStyle() & 0x4000000) != 0) {
            StringBuffer buffer = new StringBuffer(text);
            HTMLPrinter.insertStyles((StringBuffer)buffer, (String[])new String[]{"direction:rtl", "overflow:hidden"});
            text = buffer.toString();
        }
        this.fBrowser.setText(text);
    }

    public void setInput(Object input) {
        if (input instanceof RefactoringDescriptorProxy) {
            this.fDescriptor = (RefactoringDescriptorProxy)input;
            this.refresh();
        } else {
            this.fDescriptor = null;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }
}

