/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.protocol.ApplyCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.CheckItem;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ItemUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.ViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.tesla.recording.aspects.jface.IJFaceEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.jface.JFaceEventManager;
import org.eclipse.rcptt.tesla.recording.core.ICellEditsProcessor;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTWidgetLocator;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class JFaceRecordingProcessor
implements IRecordingProcessor,
IJFaceEventListener {
    private Set<CellEditor> activeCellEditors = new HashSet<CellEditor>();
    private TeslaRecorder recorder;
    public static Control lastCellEditorControl = null;

    public JFaceRecordingProcessor() {
        JFaceEventManager.addListener((IJFaceEventListener)this);
    }

    private SWTEventRecorder getSWTProcessor() {
        return (SWTEventRecorder)this.recorder.getProcessor(SWTEventRecorder.class);
    }

    public void activateCellEditor(Object cellEditorObj) {
        if (this.checkCellEditorOP()) {
            return;
        }
        CellEditor cellEditor = this.getLocator().getCellEditor(cellEditorObj);
        if (cellEditor == null) {
            return;
        }
        if (this.activeCellEditors.contains(cellEditor)) {
            return;
        }
        Control control = cellEditor.getControl();
        lastCellEditorControl = null;
        if (control == null) {
            return;
        }
        this.activeCellEditors.add(cellEditor);
        Composite parent = control.getParent();
        if (parent instanceof Tree || parent instanceof Table) {
            ControlEditor editor = TeslaSWTAccess.getControlEditor((Composite)parent);
            int column = this.getLocator().getColumnFromCellEditor(cellEditorObj, editor, cellEditor);
            ViewerUIElement e = this.getTreeTableElement((Control)parent);
            if (e != null) {
                String[][] selection = Viewers.getMultiPathSelection((SWTUIElement)this.getPlayer().wrap((Object)parent));
                e.setMultiSelection(selection);
                e.activateCellEditor(column);
            }
        } else {
            List processors = TeslaRecorder.getInstance().getProcessors(ICellEditsProcessor.class);
            for (ICellEditsProcessor p : processors) {
                if (p.activateCellEdit((Object)cellEditor, null)) break;
            }
        }
    }

    private ViewerUIElement getTreeTableElement(Control parent) {
        FindResult result = this.getLocator().findElement((Widget)parent, true, false, false);
        if (result != null && result.element != null) {
            return new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
        }
        return null;
    }

    private static Composite getCheckboxCellEditorSource(ColumnViewerEditorActivationEvent event) {
        if (event == null) {
            return null;
        }
        if (!(event.getSource() instanceof ViewerCell)) {
            return null;
        }
        ViewerRow row = (ViewerRow)TeslaSWTAccess.getField(ViewerRow.class, (Object)event.getSource(), (String)"row");
        if (row == null) {
            return null;
        }
        Item item = (Item)TeslaSWTAccess.getField(Item.class, (Object)row, (String)"item");
        if (item == null) {
            return null;
        }
        Composite parent = (Composite)TeslaSWTAccess.getField(Composite.class, (Object)item, (String)"parent");
        if (!(parent instanceof Table) && !(parent instanceof Tree)) {
            return null;
        }
        return parent;
    }

    public void activateCellEditor(CellEditor cellEditor, ColumnViewerEditorActivationEvent activationEvent) {
        block19: {
            block18: {
                ViewerUIElement e;
                int column;
                Composite parent;
                block20: {
                    if (cellEditor == null) {
                        return;
                    }
                    if (this.checkCellEditorOP()) {
                        return;
                    }
                    if (this.activeCellEditors.contains(cellEditor)) {
                        return;
                    }
                    boolean checkbox = cellEditor instanceof CheckboxCellEditor;
                    Control control = cellEditor.getControl();
                    lastCellEditorControl = null;
                    if (control == null && !checkbox) {
                        return;
                    }
                    parent = null;
                    parent = checkbox ? JFaceRecordingProcessor.getCheckboxCellEditorSource(activationEvent) : control.getParent();
                    if (parent == null) {
                        return;
                    }
                    this.activeCellEditors.add(cellEditor);
                    if (!(parent instanceof Tree) && !(parent instanceof Table)) break block18;
                    String[][] selection = Viewers.getMultiPathSelection((SWTUIElement)this.getPlayer().wrap((Object)parent));
                    ControlEditor editor = TeslaSWTAccess.getControlEditor((Composite)parent);
                    column = -1;
                    if (activationEvent.getSource() instanceof ViewerCell) {
                        ViewerCell cell = (ViewerCell)activationEvent.getSource();
                        column = cell.getColumnIndex();
                        Widget item = cell.getItem();
                        if (item instanceof TreeItem) {
                            selection = new String[][]{Viewers.getPathByTreeItem((TreeItem)((TreeItem)item))};
                        } else if (item instanceof TableItem) {
                            selection = new String[][]{Viewers.getPathByTableItem((TableItem)((TableItem)item))};
                        }
                    } else if (editor instanceof TreeEditor) {
                        column = ((TreeEditor)editor).getColumn();
                    } else if (editor instanceof TableEditor) {
                        column = ((TableEditor)editor).getColumn();
                    }
                    FindResult result = this.getLocator().findElement((Widget)parent, true, false, false);
                    if (result == null || !result.realElement.isTable() && !result.realElement.isTree()) break block19;
                    e = new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
                    if (checkbox) break block20;
                    e.setMultiSelection(selection);
                    e.activateCellEditor(column);
                    break block19;
                }
                CheckboxCellEditor checkboxCellEditor = (CheckboxCellEditor)cellEditor;
                int row = -1;
                if (parent instanceof Tree) {
                    Tree tree = (Tree)parent;
                    if (tree.getSelectionCount() > 0) {
                        row = tree.indexOf(tree.getSelection()[0]);
                    }
                } else if (parent instanceof Table) {
                    Table table = (Table)parent;
                    row = table.getSelectionIndex();
                }
                if (row == -1 || checkboxCellEditor.getValue() == null) break block19;
                ItemUIElement item = e.item(new Integer[]{column, row});
                CheckItem checkItem = ProtocolFactory.eINSTANCE.createCheckItem();
                checkItem.setElement(item.getElement());
                checkItem.setState(((Boolean)checkboxCellEditor.getValue()).booleanValue());
                this.getRecorder().safeExecuteCommand((Command)checkItem);
                break block19;
            }
            List processors = TeslaRecorder.getInstance().getProcessors(ICellEditsProcessor.class);
            for (ICellEditsProcessor p : processors) {
                if (p.activateCellEdit((Object)cellEditor, (Object)activationEvent)) break;
            }
        }
    }

    private TeslaRecorder getRecorder() {
        return this.getSWTProcessor().getRecorder();
    }

    private SWTWidgetLocator getLocator() {
        return this.getSWTProcessor().getLocator();
    }

    private SWTUIPlayer getPlayer() {
        return this.getSWTProcessor().getPlayer();
    }

    private static Composite getCheckboxCellEditorSource(CellEditor cellEditor) {
        ListenerList listeners = (ListenerList)TeslaSWTAccess.getField(ListenerList.class, (Object)cellEditor, (String)"listeners");
        Object[] objectArray = listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnViewer viewer;
            Object o = objectArray[n2];
            ColumnViewerEditor viewerEditor = (ColumnViewerEditor)TeslaSWTAccess.getField(ColumnViewerEditor.class, (Object)o, (String)"this$0");
            if (viewerEditor != null && (viewer = (ColumnViewer)TeslaSWTAccess.getField(ColumnViewer.class, (Object)viewerEditor, (String)"viewer")) != null) {
                if (viewer instanceof TableViewer) {
                    return ((TableViewer)viewer).getTable();
                }
                if (viewer instanceof TreeViewer) {
                    return ((TreeViewer)viewer).getTree();
                }
            }
            ++n2;
        }
        return null;
    }

    public void applyCellEditor(Object cellEditorObj) {
        if (this.checkCellEditorOP()) {
            return;
        }
        CellEditor cellEditor = this.getLocator().getCellEditor(cellEditorObj);
        if (cellEditor == null) {
            return;
        }
        boolean checkbox = cellEditor instanceof CheckboxCellEditor;
        lastCellEditorControl = cellEditor.getControl();
        Control control = lastCellEditorControl;
        if (control == null && !checkbox) {
            return;
        }
        if (!this.activeCellEditors.contains(cellEditor)) {
            return;
        }
        Composite parent = null;
        if (checkbox) {
            return;
        }
        parent = control.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof Tree || parent instanceof Table) {
            FindResult result = this.getLocator().findElement((Widget)parent, true, false, false);
            if (result != null && (result.realElement.isTable() || result.realElement.isTree())) {
                ViewerUIElement e = new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
                e.applyCellEditor();
            }
        } else {
            List processors = TeslaRecorder.getInstance().getProcessors(ICellEditsProcessor.class);
            for (ICellEditsProcessor p : processors) {
                if (p.applyCellEdit((Object)cellEditor)) break;
            }
        }
    }

    public void deactivateCellEditor(Object cellEditorObj) {
        if (this.checkCellEditorOP()) {
            return;
        }
        CellEditor cellEditor = this.getLocator().getCellEditor(cellEditorObj);
        if (cellEditor == null) {
            return;
        }
        boolean checkbox = cellEditor instanceof CheckboxCellEditor;
        if (this.activeCellEditors.contains(cellEditor)) {
            this.activeCellEditors.remove(cellEditor);
        } else if (!checkbox) {
            return;
        }
        Control control = lastCellEditorControl = cellEditor.getControl();
        if (control == null && !checkbox) {
            return;
        }
        Composite parent = null;
        if (checkbox) {
            return;
        }
        parent = control.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof Tree || parent instanceof Table) {
            FindResult result = this.getLocator().findElement((Widget)parent, true, false, false);
            if (result != null && (result.realElement.isTable() || result.realElement.isTree())) {
                ViewerUIElement e = new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
                e.deactivateCellEditor();
            }
        } else {
            List processors = TeslaRecorder.getInstance().getProcessors(ICellEditsProcessor.class);
            for (ICellEditsProcessor p : processors) {
                if (p.deactivateCellEdit((Object)cellEditor)) break;
            }
        }
    }

    private boolean checkCellEditorOP() {
        if (this.getRecorder() == null) {
            return true;
        }
        if (!this.getRecorder().hasListeners()) {
            return true;
        }
        ContextManagement.Context ctx = ContextManagement.currentContext();
        return ctx.contains("org.eclipse.jface.viewers.AbstractTableViewer", "internalRefresh");
    }

    public void cancelCellEditor(Object cellEditorObj) {
        if (this.checkCellEditorOP()) {
            return;
        }
        Command last = this.getRecorder().getContainer().getLast();
        if (last != null && last instanceof ApplyCellEditor) {
            return;
        }
        CellEditor cellEditor = this.getLocator().getCellEditor(cellEditorObj);
        if (cellEditor == null) {
            return;
        }
        lastCellEditorControl = cellEditor.getControl();
        Control control = lastCellEditorControl;
        if (control == null) {
            return;
        }
        Composite parent = control.getParent();
        if (parent instanceof Tree || parent instanceof Table) {
            FindResult result = this.getLocator().findElement((Widget)parent, true, false, false);
            if (result != null && (result.realElement.isTable() || result.realElement.isTree())) {
                ViewerUIElement e = new ViewerUIElement(result.element, (UIPlayer)this.getRecorder());
                e.cancelCellEditor();
            }
        } else {
            List processors = TeslaRecorder.getInstance().getProcessors(ICellEditsProcessor.class);
            for (ICellEditsProcessor p : processors) {
                if (p.cancelCellEdit((Object)cellEditor)) break;
            }
        }
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        this.recorder = teslaRecorder;
    }

    public int getInitLevel() {
        return 100;
    }

    public void clear() {
        this.activeCellEditors.clear();
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    public void resetAssertSelection() {
    }

    public IRecordingHelper<?> getHelper() {
        return null;
    }

    public void recordOpenStrategyEvent(OpenStrategy str, SelectionEvent e) {
        FindResult element;
        if (OpenStrategy.getOpenMethod() == 1 && e.widget != null && (element = this.getSWTProcessor().getLocator().findElement(e.widget, false, false, false)) != null) {
            ControlUIElement el = new ControlUIElement(element.element, (UIPlayer)this.getRecorder());
            el.click();
        }
    }
}

