/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.internal.core.IWorkspaceModel;
import org.eclipse.pde.internal.core.plugin.IWritableDelimiter;
import org.eclipse.pde.internal.core.util.XMLComponentRegistry;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageContentOutline;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.MissingResourcePage;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class PDEFormEditor
extends FormEditor
implements IInputContextListener,
IGotoMarker,
ISearchEditorAccess {
    private static final String F_DIALOG_EDITOR_SECTION_KEY = "pde-form-editor";
    private PDEFormEditorChangeListener fEditorSelectionChangedListener;
    private Clipboard clipboard;
    private Menu fContextMenu;
    protected InputContextManager fInputContextManager;
    private ISortableContentOutlinePage fFormOutline;
    private PDEMultiPageContentOutline fContentOutline;
    private String fLastActivePageId;
    private boolean fLastDirtyState;
    private boolean fError;

    public PDEFormEditor() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        XMLComponentRegistry.Instance().connect((Object)this);
        this.fInputContextManager = this.createInputContextManager();
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new PDEMultiPageEditorSite((MultiPageEditorPart)this, editor);
    }

    public IProject getCommonProject() {
        return this.fInputContextManager.getCommonProject();
    }

    public IBaseModel getAggregateModel() {
        if (this.fInputContextManager != null) {
            return this.fInputContextManager.getAggregateModel();
        }
        return null;
    }

    protected abstract InputContextManager createInputContextManager();

    public boolean hasInputContext(String contextId) {
        return this.fInputContextManager.hasContext(contextId);
    }

    public InputContextManager getContextManager() {
        return this.fInputContextManager;
    }

    protected void createInputContexts(InputContextManager contextManager) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.createResourceContexts(contextManager, (IFileEditorInput)input);
        } else if (input instanceof IStorageEditorInput) {
            this.createStorageContexts(contextManager, (IStorageEditorInput)input);
        } else if (input instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)input;
            try {
                IFileStore store = EFS.getStore((URI)uriEditorInput.getURI());
                if (!"file".equals(store.getFileSystem().getScheme())) {
                    return;
                }
                FileStoreEditorInput sinput = new FileStoreEditorInput(store);
                this.createSystemFileContexts(contextManager, sinput);
            }
            catch (CoreException coreException) {
                return;
            }
        }
    }

    protected abstract void createResourceContexts(InputContextManager var1, IFileEditorInput var2);

    protected abstract void createSystemFileContexts(InputContextManager var1, FileStoreEditorInput var2);

    protected abstract void createStorageContexts(InputContextManager var1, IStorageEditorInput var2);

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(PDEPlugin.getDefault().getFormColors(display));
    }

    protected void createPages() {
        this.clipboard = new Clipboard(this.getContainer().getDisplay());
        MenuManager manager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PDEFormEditor.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        this.fContextMenu = manager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(this.fContextMenu);
        this.createInputContexts(this.fInputContextManager);
        super.createPages();
        this.fInputContextManager.addInputContextListener(this);
        String pageToShow = this.computeInitialPageId();
        if (pageToShow != null) {
            this.setActivePage(pageToShow);
        }
        this.updateTitle();
        if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
        PDEModelUtility.connect(this);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IFormPage page = this.getActivePageInstance();
        this.updateContentOutline(page);
        if (page != null) {
            this.fLastActivePageId = page.getId();
        }
    }

    public void setFocus() {
        super.setFocus();
        IFormPage page = this.getActivePageInstance();
        if (page != null && page instanceof PDEFormPage) {
            ((PDEFormPage)page).updateFormSelection();
        }
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        PDEFormEditorContributor contributor = this.getContributor();
        IFormPage page = this.getActivePageInstance();
        if (page instanceof PDEFormPage) {
            ((PDEFormPage)page).contextMenuAboutToShow(manager);
        }
        if (contributor != null) {
            contributor.contextMenuAboutToShow(manager);
        }
    }

    public PDEFormEditorContributor getContributor() {
        return (PDEFormEditorContributor)this.getEditorSite().getActionBarContributor();
    }

    protected String computeInitialPageId() {
        String invalidContextId;
        String firstPageId = null;
        String storedFirstPageId = this.loadDefaultPage();
        if (storedFirstPageId != null) {
            firstPageId = storedFirstPageId;
        }
        if ((invalidContextId = this.getFirstInvalidContextId()) != null) {
            return invalidContextId;
        }
        return firstPageId;
    }

    private String getFirstInvalidContextId() {
        InputContext[] invalidContexts = this.fInputContextManager.getInvalidContexts();
        if (invalidContexts.length == 0) {
            return null;
        }
        int i = 0;
        while (i < invalidContexts.length) {
            if (invalidContexts[i].isPrimary()) {
                return invalidContexts[i].getId();
            }
            ++i;
        }
        return invalidContexts[0].getId();
    }

    public String getTitle() {
        if (this.fInputContextManager == null) {
            return super.getTitle();
        }
        InputContext context = this.fInputContextManager.getPrimaryContext();
        if (context == null) {
            return super.getTitle();
        }
        return context.getInput().getName();
    }

    public void updateTitle() {
        this.firePropertyChange(1);
    }

    public String getTitleProperty() {
        return "";
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
        this.fInputContextManager.save(monitor);
        this.editorDirtyStateChanged();
    }

    public void doRevert() {
        boolean reverted;
        IFormPage formPage = this.getActivePageInstance();
        if (formPage != null && formPage instanceof PDEFormPage) {
            formPage.getManagedForm().commit(true);
        }
        if (!(reverted = this.doRevertSourcePages())) {
            reverted = this.doRevertFormPage();
        }
        if (reverted) {
            this.editorDirtyStateChanged();
        }
    }

    private boolean doRevertFormPage() {
        boolean reverted = false;
        IBaseModel model = this.getAggregateModel();
        if (model instanceof IWorkspaceModel) {
            IWorkspaceModel workspaceModel = (IWorkspaceModel)model;
            workspaceModel.reload();
            reverted = true;
        }
        return reverted;
    }

    private boolean doRevertSourcePages() {
        boolean reverted = false;
        IFormPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] instanceof PDESourcePage) {
                PDESourcePage sourcePage = (PDESourcePage)pages[i];
                sourcePage.getInputContext().flushEditorInput();
                sourcePage.doRevertToSaved();
                reverted = true;
            }
            ++i;
        }
        return reverted;
    }

    public void doRevert(IEditorInput input) {
        InputContext context;
        IFormPage page;
        IFormPage currentPage = this.getActivePageInstance();
        if (currentPage != null && currentPage instanceof PDEFormPage) {
            ((PDEFormPage)currentPage).cancelEdit();
        }
        if ((page = this.findPage((context = this.fInputContextManager.getContext(input)).getId())) != null && page instanceof PDESourcePage) {
            PDESourcePage spage = (PDESourcePage)page;
            spage.doRevertToSaved();
        }
        this.editorDirtyStateChanged();
    }

    public void flushEdits() {
        IFormPage[] pages = this.getPages();
        IManagedForm mForm = pages[this.getActivePage()].getManagedForm();
        if (mForm != null) {
            mForm.commit(false);
        }
        int i = 0;
        while (i < pages.length) {
            if (pages[i] instanceof PDESourcePage) {
                PDESourcePage sourcePage = (PDESourcePage)pages[i];
                sourcePage.getInputContext().flushEditorInput();
            }
            ++i;
        }
    }

    public String getContextIDForSaveAs() {
        return null;
    }

    public void doSaveAs() {
        try {
            String contextID = this.getContextIDForSaveAs();
            this.getContextManager().saveAs(this.getProgressMonitor(), contextID);
            IEditorInput input = this.getContextManager().findContext(contextID).getInput();
            this.setInputWithNotify(input);
            this.setPartName(input.getName());
            this.firePropertyChange(257);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            String title = PDEUIMessages.PDEFormEditor_errorTitleProblemSaveAs;
            String message = PDEUIMessages.PDEFormEditor_errorMessageSaveNotCompleted;
            if (e.getMessage() != null) {
                message = String.valueOf(message) + ' ' + e.getMessage();
            }
            PDEPlugin.logException(e, title, message);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void storeDefaultPage() {
        IEditorInput input = this.getEditorInput();
        String pageId = this.fLastActivePageId;
        if (pageId == null) {
            return;
        }
        if (input instanceof IFileEditorInput) {
            this.setPropertyEditorPageKey((IFileEditorInput)input, pageId);
        } else if (input instanceof IStorageEditorInput) {
            this.setDialogEditorPageKey(pageId);
        }
    }

    protected void setDialogEditorPageKey(String pageID) {
        IDialogSettings section = this.getSettingsSection();
        section.put(this.getEditorID(), pageID);
    }

    protected String getDialogEditorPageKey() {
        IDialogSettings section = this.getSettingsSection();
        return section.get(this.getEditorID());
    }

    protected abstract String getEditorID();

    protected void setPropertyEditorPageKey(IFileEditorInput input, String pageId) {
        IFile file = input.getFile();
        try {
            file.setPersistentProperty(IPDEUIConstants.PROPERTY_EDITOR_PAGE_KEY, pageId);
        }
        catch (CoreException coreException) {}
    }

    private String loadDefaultPage() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return this.getPropertyEditorPageKey((IFileEditorInput)input);
        }
        if (input instanceof IStorageEditorInput) {
            return this.getDialogEditorPageKey();
        }
        return null;
    }

    protected String getPropertyEditorPageKey(IFileEditorInput input) {
        IFile file = input.getFile();
        try {
            return file.getPersistentProperty(IPDEUIConstants.PROPERTY_EDITOR_PAGE_KEY);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void dispose() {
        this.storeDefaultPage();
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSite().getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        XMLComponentRegistry.Instance().disconnect((Object)this);
        PDEModelUtility.disconnect(this);
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
        this.fInputContextManager.dispose();
        this.fInputContextManager = null;
    }

    public boolean isDirty() {
        this.fLastDirtyState = this.computeDirtyState();
        return this.fLastDirtyState;
    }

    private boolean computeDirtyState() {
        IFormPage page = this.getActivePageInstance();
        if (page != null && page.isDirty() || this.fInputContextManager != null && this.fInputContextManager.isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    public boolean getLastDirtyState() {
        return this.fLastDirtyState;
    }

    public void fireSaveNeeded(String contextId, boolean notify) {
        if (contextId == null) {
            return;
        }
        InputContext context = this.fInputContextManager.findContext(contextId);
        if (context != null) {
            this.fireSaveNeeded(context.getInput(), notify);
        }
    }

    public void fireSaveNeeded(IEditorInput input, boolean notify) {
        if (notify) {
            this.editorDirtyStateChanged();
        }
        if (this.isDirty()) {
            this.validateEdit(input);
        }
    }

    public void editorDirtyStateChanged() {
        super.editorDirtyStateChanged();
        PDEFormEditorContributor contributor = this.getContributor();
        if (contributor != null) {
            contributor.updateActions();
        }
    }

    private void validateEdit(IEditorInput input) {
        final InputContext context = this.fInputContextManager.getContext(input);
        if (!context.validateEdit()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PDEFormEditor.this.doRevert(context.getInput());
                    context.setValidated(false);
                }
            });
        }
    }

    private IDialogSettings getSettingsSection() {
        IDialogSettings root = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection(F_DIALOG_EDITOR_SECTION_KEY);
        if (section == null) {
            section = root.addNewSection(F_DIALOG_EDITOR_SECTION_KEY);
        }
        return section;
    }

    public void gotoMarker(IMarker marker) {
        IResource resource = marker.getResource();
        InputContext context = this.fInputContextManager.findContext(resource);
        if (context == null) {
            return;
        }
        IFormPage page = this.getActivePageInstance();
        if (!context.getId().equals(page.getId())) {
            page = this.setActivePage(context.getId());
        }
        IDE.gotoMarker((IEditorPart)page, (IMarker)marker);
    }

    public void openToSourcePage(Object object, int offset, int length) {
        PDESourcePage page;
        InputContext context = null;
        context = object instanceof InputContext ? (InputContext)object : this.getInputContext(object);
        if (context != null && (page = (PDESourcePage)this.setActivePage(context.getId())) != null) {
            page.selectAndReveal(offset, length);
        }
    }

    public void setSelection(ISelection selection) {
        this.getSite().getSelectionProvider().setSelection(selection);
        this.getContributor().updateSelectableActions(selection);
    }

    public ISelection getSelection() {
        return this.getSite().getSelectionProvider().getSelection();
    }

    public <T> T getAdapter(Class<T> key) {
        if (key.equals(IContentOutlinePage.class)) {
            return (T)((Object)this.getContentOutline());
        }
        if (key.equals(IGotoMarker.class)) {
            return (T)this;
        }
        if (key.equals(ISearchEditorAccess.class)) {
            return (T)this;
        }
        return (T)super.getAdapter(key);
    }

    public Menu getContextMenu() {
        return this.fContextMenu;
    }

    public PDEMultiPageContentOutline getContentOutline() {
        if (this.fContentOutline == null || this.fContentOutline.isDisposed()) {
            this.fContentOutline = new PDEMultiPageContentOutline(this);
            this.updateContentOutline(this.getActivePageInstance());
        }
        return this.fContentOutline;
    }

    protected ISortableContentOutlinePage getFormOutline() {
        if (this.fFormOutline == null) {
            this.fFormOutline = this.createContentOutline();
            if (this.fFormOutline != null) {
                this.fEditorSelectionChangedListener = new PDEFormEditorChangeListener();
                this.fEditorSelectionChangedListener.install(this.getSite().getSelectionProvider());
            }
        }
        return this.fFormOutline;
    }

    protected abstract ISortableContentOutlinePage createContentOutline();

    private void updateContentOutline(IFormPage page) {
        if (this.fContentOutline == null) {
            return;
        }
        ISortableContentOutlinePage outline = null;
        if (page instanceof PDESourcePage) {
            outline = ((PDESourcePage)page).getContentOutline();
        } else {
            outline = this.getFormOutline();
            if (outline != null && outline instanceof FormOutlinePage) {
                ((FormOutlinePage)outline).refresh();
            }
        }
        this.fContentOutline.setPageActive(outline);
    }

    public IFormPage setActivePage(String pageId) {
        IFormPage page = super.setActivePage(pageId);
        if (page != null) {
            this.updateContentOutline(page);
        }
        return page;
    }

    IFormPage[] getPages() {
        ArrayList formPages = new ArrayList();
        int i = 0;
        while (i < this.pages.size()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage) {
                formPages.add(page);
            }
            ++i;
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    protected void performGlobalAction(String id) {
        IFormPage page;
        ISelection selection = this.getSelection();
        boolean handled = ((PDEFormPage)this.getActivePageInstance()).performGlobalAction(id);
        if (!handled && (page = this.getActivePageInstance()) instanceof PDEFormPage) {
            if (id.equals(ActionFactory.UNDO.getId())) {
                this.fInputContextManager.undo();
                return;
            }
            if (id.equals(ActionFactory.REDO.getId())) {
                this.fInputContextManager.redo();
                return;
            }
            if (id.equals(ActionFactory.CUT.getId()) || id.equals(ActionFactory.COPY.getId())) {
                this.copyToClipboard(selection);
                return;
            }
        }
    }

    private void copyToClipboard(ISelection selection) {
        Object[] objects = null;
        String textVersion = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel.size() == 0) {
                return;
            }
            objects = ssel.toArray();
            StringWriter writer = new StringWriter();
            PrintWriter pwriter = new PrintWriter(writer);
            Class<?> objClass = null;
            int i = 0;
            while (i < objects.length) {
                Object obj = objects[i];
                if (objClass == null) {
                    objClass = obj.getClass();
                } else if (!objClass.equals(obj.getClass())) {
                    return;
                }
                if (obj instanceof IWritable) {
                    if (i != 0 && obj instanceof IWritableDelimiter) {
                        ((IWritableDelimiter)obj).writeDelimeter(pwriter);
                    }
                    ((IWritable)obj).write("", pwriter);
                } else if (obj instanceof String) {
                    pwriter.println((String)obj);
                }
                ++i;
            }
            pwriter.flush();
            textVersion = writer.toString();
            try {
                pwriter.close();
                writer.close();
            }
            catch (IOException iOException) {}
        } else if (selection instanceof ITextSelection) {
            textVersion = ((ITextSelection)selection).getText();
        }
        if ((textVersion == null || textVersion.length() == 0) && objects == null) {
            return;
        }
        Object[] o = null;
        Transfer[] t = null;
        if (objects == null) {
            o = new Object[]{textVersion};
            t = new Transfer[]{TextTransfer.getInstance()};
        } else if (textVersion == null || textVersion.length() == 0) {
            o = new Object[]{objects};
            t = new Transfer[]{ModelDataTransfer.getInstance()};
        } else {
            o = new Object[]{objects, textVersion};
            t = new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
        }
        this.clipboard.setContents(o, t);
    }

    public boolean canPasteFromClipboard() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof PDEFormPage) {
            return ((PDEFormPage)page).canPaste(this.getClipboard());
        }
        return false;
    }

    public boolean canCopy(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            return !selection.isEmpty();
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            return textSelection.getLength() > 0;
        }
        return false;
    }

    public boolean canCut(ISelection selection) {
        return this.canCopy(selection);
    }

    void updateUndo(IAction undoAction, IAction redoAction) {
        IModelUndoManager undoManager = this.fInputContextManager.getUndoManager();
        if (undoManager != null) {
            undoManager.setActions(undoAction, redoAction);
        }
    }

    public void synchronizeOutlinePage() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof PDESourcePage) {
            ((PDESourcePage)page).synchronizeOutlinePage();
        } else if (this.getFormOutline() != null) {
            this.getFormOutline().setSelection(this.getSelection());
        }
    }

    public IDocument getDocument(Match match) {
        InputContext context = this.getInputContext(match.getElement());
        return context == null ? null : context.getDocumentProvider().getDocument((Object)context.getInput());
    }

    public IAnnotationModel getAnnotationModel(Match match) {
        InputContext context = this.getInputContext(match.getElement());
        return context == null ? null : context.getDocumentProvider().getAnnotationModel((Object)context.getInput());
    }

    protected abstract InputContext getInputContext(Object var1);

    protected final void addPages() {
        boolean bl = this.fError = this.getAggregateModel() == null;
        if (this.fError) {
            try {
                this.addPage((IFormPage)new MissingResourcePage(this));
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
            }
        } else {
            this.addEditorPages();
        }
    }

    protected abstract void addEditorPages();

    @Override
    public final void contextAdded(InputContext context) {
        if (this.fError) {
            this.removePage(0);
            this.addPages();
            if (!this.fError) {
                this.setActivePage("overview");
            }
        } else {
            this.editorContextAdded(context);
        }
    }

    public abstract void editorContextAdded(InputContext var1);

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor monitor = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            monitor = manager.getProgressMonitor();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.getEditorSite().getActionBars().getStatusLineManager();
    }

    public void contributeToToolbar(IToolBarManager manager) {
    }

    public class PDEFormEditorChangeListener
    implements ISelectionChangedListener {
        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (PDEPlugin.getDefault().getPreferenceStore().getBoolean("ToggleLinkWithEditorAction.isChecked") && PDEFormEditor.this.getFormOutline() != null) {
                PDEFormEditor.this.getFormOutline().setSelection(event.getSelection());
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private static class PDEMultiPageEditorSite
    extends MultiPageEditorSite {
        public PDEMultiPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
            super(multiPageEditor, editor);
        }

        public IEditorActionBarContributor getActionBarContributor() {
            PDEFormEditor editor = (PDEFormEditor)this.getMultiPageEditor();
            PDEFormEditorContributor contributor = editor.getContributor();
            return contributor.getSourceContributor();
        }

        public IWorkbenchPart getPart() {
            return this.getMultiPageEditor();
        }
    }
}

