/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.utils;

import java.util.Collection;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class SearchXMLGenerator {
    public static String serialize(Collection<SearchHit> results) {
        return SearchXMLGenerator.serialize(results != null ? results.toArray(new SearchHit[results.size()]) : null, false);
    }

    public static String serialize(SearchHit[] hits, boolean boolIsCategory) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<searchHits>\n");
        if (hits != null) {
            SearchHit[] searchHitArray = hits;
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                SearchHit hit = searchHitArray[n2];
                SearchXMLGenerator.serialize(hit, buf, "   ", boolIsCategory);
                ++n2;
            }
        }
        buf.append("</searchHits>\n");
        return buf.toString();
    }

    private static void serialize(SearchHit hit, StringBuffer buf, String indent, boolean boolIsCategory) {
        String summary;
        IHelpResource categoryResource;
        buf.append(String.valueOf(indent) + "<hit");
        if (hit.getHref() != null) {
            buf.append(String.valueOf('\n') + indent + "      href=\"" + XMLGenerator.xmlEscape(hit.getHref()) + '\"');
        }
        if (hit.getLabel() != null) {
            buf.append(String.valueOf('\n') + indent + "      label=\"" + XMLGenerator.xmlEscape(hit.getLabel()) + '\"');
        }
        if (hit.isPotentialHit()) {
            buf.append(String.valueOf('\n') + indent + "      isPotentialHit=\"true\"");
        }
        buf.append(String.valueOf('\n') + indent + "      score=\"" + hit.getScore() + '\"');
        buf.append(">\n");
        if (boolIsCategory && (categoryResource = hit.getCategory()) != null) {
            SearchXMLGenerator.serializeCategory(categoryResource, buf, String.valueOf(indent) + "  ");
        }
        if ((summary = hit.getSummary()) != null) {
            SearchXMLGenerator.serialize(summary, buf, String.valueOf(indent) + "   ");
        }
        buf.append(String.valueOf(indent) + "</hit>\n");
    }

    private static void serialize(String summary, StringBuffer buf, String indent) {
        buf.append(String.valueOf(indent) + "<summary>");
        buf.append(XMLGenerator.xmlEscape(summary));
        buf.append("</summary>\n");
    }

    private static void serializeCategory(IHelpResource categoryResource, StringBuffer buf, String indent) {
        String category = categoryResource.getLabel();
        if (category == null) {
            return;
        }
        buf.append(String.valueOf(indent) + "<category");
        String catHref = SearchXMLGenerator.getCategoryHref(categoryResource);
        if (catHref != null) {
            buf.append(String.valueOf('\n') + indent + "      href=\"" + XMLGenerator.xmlEscape(catHref) + '\"');
        }
        buf.append(">\n");
        buf.append(XMLGenerator.xmlEscape(category));
        buf.append("</category>\n");
    }

    private static String getCategoryHref(IHelpResource categoryResource) {
        String tocHref = categoryResource.getHref();
        IToc[] tocs = HelpSystem.getTocs();
        int j = 0;
        while (j < tocs.length) {
            if (tocHref.equals(tocs[j].getHref())) {
                ITopic topic = tocs[j].getTopic(null);
                String topicHref = topic.getHref();
                if (topicHref != null) {
                    return UrlUtil.getHelpURL(topicHref);
                }
                return "../nav/" + j;
            }
            ++j;
        }
        return null;
    }
}

