/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.actions.CollapseAllAction;
import org.eclipse.debug.internal.ui.actions.ConfigureColumnsAction;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueAction;
import org.eclipse.debug.internal.ui.actions.variables.ShowTypesAction;
import org.eclipse.debug.internal.ui.actions.variables.ToggleDetailPaneAction;
import org.eclipse.debug.internal.ui.viewers.model.VirtualFindAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewActionProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputRequestor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ViewerInputService;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.SelectionDragAdapter;
import org.eclipse.debug.internal.ui.views.variables.ToggleLogicalStructureAction;
import org.eclipse.debug.internal.ui.views.variables.ToggleShowColumnsAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.debug.internal.ui.views.variables.details.AvailableDetailPanesAction;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer2;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public class VariablesView
extends AbstractDebugView
implements IDebugContextListener,
IPropertyChangeListener,
IDebugExceptionHandler,
IPerspectiveListener,
IModelChangedListener,
IViewerUpdateListener,
IDetailPaneContainer2,
ISaveablePart2 {
    private static final String COLLAPSE_ALL = "CollapseAll";
    protected VariablesViewModelPresentation fModelPresentation;
    private SashForm fSashForm;
    private Composite fDetailsAnchor;
    private Composite fDetailsComposite;
    private Label fSeparator;
    private Composite fParent;
    private boolean fPaneBuilt = false;
    private DetailPaneProxy fDetailPane;
    private boolean fTreeHasFocus = true;
    private ISelectionChangedListener fTreeSelectionChangedListener;
    private Listener fDetailPaneActivatedListener;
    private ViewerInputService fInputService;
    private Map<String, IAction> fGlobalActionMap = new HashMap<String, IAction>();
    private IViewerInputRequestor fRequester = new IViewerInputRequestor(){

        @Override
        public void viewerInputComplete(IViewerInputUpdate update) {
            if (!update.isCanceled()) {
                VariablesView.this.viewerInputUpdateComplete(update);
            }
        }
    };
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{13, 6};
    private int[] fLastSashWeights;
    private boolean fToggledDetailOnce;
    private String fCurrentDetailPaneOrientation = "Variables.detail.orientation.hidden";
    private ToggleDetailPaneAction[] fToggleDetailPaneActions;
    private ConfigureColumnsAction fConfigureColumnsAction;
    protected String PREF_STATE_MEMENTO = "pref_state_memento.";
    public static final String LOGICAL_STRUCTURE_TYPE_PREFIX = "VAR_LS_";
    public static final String PRESENTATION_SHOW_LOGICAL_STRUCTURES = "PRESENTATION_SHOW_LOGICAL_STRUCTURES";
    protected static final String SASH_VIEW_PART = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".SASH_VIEW_PART";
    protected static final String SASH_DETAILS_PART = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".SASH_DETAILS_PART";
    protected static final String DETAIL_PANE_TYPE = "DETAIL_PANE_TYPE";
    private Visitor fVisitor = new Visitor();
    private Job fTriggerDetailsJob = new UIJob("trigger details"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            VariablesView.this.refreshDetailPaneContents();
            return Status.OK_STATUS;
        }
    };
    private SelectionProviderWrapper fSelectionProvider;
    private IPresentationContext fPresentationContext;

    @Override
    public void dispose() {
        DebugUITools.removePartDebugContextListener(this.getSite(), this);
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        TreeModelViewer viewer = this.getVariablesViewer();
        if (viewer != null) {
            viewer.removeModelChangedListener(this);
            viewer.removeViewerUpdateListener(this);
        }
        if (this.fPresentationContext != null) {
            this.fPresentationContext.dispose();
            this.fPresentationContext = null;
        }
        if (this.fDetailPane != null) {
            this.fDetailPane.dispose();
        }
        this.fInputService.dispose();
        this.fSelectionProvider.dispose();
        super.dispose();
    }

    protected void viewerInputUpdateComplete(IViewerInputUpdate update) {
        this.setViewerInput(update.getInputElement());
        this.updateAction(FIND_ACTION);
    }

    protected void setViewerInput(Object context) {
        Object current;
        if (context == null) {
            this.refreshDetailPaneContents();
        }
        if ((current = this.getViewer().getInput()) == null && context == null) {
            return;
        }
        if (current != null && current.equals(context)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(context);
        this.updateObjects();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.changedDebugElement") || propertyName.equals("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND") || propertyName.equals("org.eclipse.debug.ui.VariableTextFont")) {
            this.getViewer().refresh();
        }
    }

    @Override
    public Viewer createViewer(Composite parent) {
        this.addResizeListener(parent);
        this.fParent = parent;
        this.fTriggerDetailsJob.setSystem(true);
        this.fSashForm = new SashForm(parent, 0);
        this.getModelPresentation();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        TreeModelViewer variablesViewer = this.createTreeViewer((Composite)this.fSashForm);
        this.fInputService = new ViewerInputService(variablesViewer, this.fRequester);
        this.fSashForm.setMaximizedControl(variablesViewer.getControl());
        this.fDetailsAnchor = SWTFactory.createComposite((Composite)this.fSashForm, parent.getFont(), 1, 1, 1808, 0, 0);
        this.fSashForm.setWeights(this.getLastSashWeights());
        this.fSelectionProvider = new SelectionProviderWrapper(variablesViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        this.createOrientationActions(variablesViewer);
        IPreferenceStore prefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String orientation = prefStore.getString(this.getDetailPanePreferenceKey());
        int i = 0;
        while (i < this.fToggleDetailPaneActions.length) {
            this.fToggleDetailPaneActions[i].setChecked(this.fToggleDetailPaneActions[i].getOrientation().equals(orientation));
            ++i;
        }
        this.fDetailPane = new DetailPaneProxy(this);
        this.fDetailPane.addProperyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                VariablesView.this.firePropertyChange(propId);
            }
        });
        this.setDetailPaneOrientation(orientation);
        IMemento memento = this.getMemento();
        if (memento != null) {
            variablesViewer.initState(memento);
        }
        variablesViewer.addModelChangedListener(this);
        variablesViewer.addViewerUpdateListener(this);
        this.initDragAndDrop(variablesViewer);
        return variablesViewer;
    }

    protected void initDragAndDrop(TreeModelViewer viewer) {
        viewer.addDragSupport(1, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SelectionDragAdapter(viewer));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        int[] weights;
        block18: {
            super.init(site, memento);
            this.PREF_STATE_MEMENTO = String.valueOf(this.PREF_STATE_MEMENTO) + site.getId();
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String string = store.getString(this.PREF_STATE_MEMENTO);
            if (string.length() > 0) {
                try {
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try {
                        ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
                        try {
                            try (InputStreamReader reader = new InputStreamReader(bin);){
                                XMLMemento stateMemento = XMLMemento.createReadRoot((Reader)reader);
                                this.setMemento((IMemento)stateMemento);
                            }
                            if (bin == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bin == null) throw throwable;
                            bin.close();
                            throw throwable;
                        }
                        bin.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (WorkbenchException workbenchException) {
                }
                catch (IOException iOException) {}
            }
        }
        IMemento mem = this.getMemento();
        this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
        if (mem != null && (weights = this.getWeights(mem)) != null) {
            this.setLastSashWeights(weights);
        }
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    private int[] getWeights(IMemento memento) {
        Integer sw = memento.getInteger(SASH_VIEW_PART);
        if (sw != null) {
            int details;
            int view = sw;
            sw = memento.getInteger(SASH_DETAILS_PART);
            if (sw != null && view > -1 & (details = sw.intValue()) > -1) {
                return new int[]{view, details};
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void partDeactivated(IWorkbenchPart part) {
        block16: {
            String id = part.getSite().getId();
            if (id.equals(this.getSite().getId())) {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        try {
                            try (OutputStreamWriter writer = new OutputStreamWriter(bout);){
                                XMLMemento memento = XMLMemento.createWriteRoot((String)"VariablesViewMemento");
                                this.saveViewerState((IMemento)memento);
                                memento.save((Writer)writer);
                                IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                                String xmlString = bout.toString();
                                store.putValue(this.PREF_STATE_MEMENTO, xmlString);
                            }
                            if (bout == null) break block16;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bout == null) throw throwable;
                            bout.close();
                            throw throwable;
                        }
                        bout.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        super.partDeactivated(part);
    }

    public void saveViewerState(IMemento memento) {
        if (this.fSashForm != null && !this.fSashForm.isDisposed()) {
            int[] weights = this.fSashForm.getWeights();
            memento.putInteger(SASH_VIEW_PART, weights[0]);
            memento.putInteger(SASH_DETAILS_PART, weights[1]);
        }
        this.getVariablesViewer().saveState(memento);
    }

    protected String getDetailPanePreferenceKey() {
        return "Variables.detail.orientation";
    }

    protected TreeModelViewer createTreeViewer(Composite parent) {
        int style = this.getViewerStyle();
        this.fPresentationContext = new DebugModelPresentationContext(this.getPresentationContextId(), (IWorkbenchPart)this, this.fModelPresentation);
        final TreeModelViewer variablesViewer = new TreeModelViewer(parent, style, this.fPresentationContext);
        variablesViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                VariablesView.this.fTreeHasFocus = true;
                VariablesView.this.fSelectionProvider.setActiveProvider(variablesViewer);
                VariablesView.this.setGlobalActions();
            }

            public void focusLost(FocusEvent e) {
                VariablesView.this.clearGlobalActions();
                VariablesView.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        variablesViewer.getPresentationContext().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IAction action;
                if ("PROPERTY_COLUMNS".equals(event.getProperty()) && (action = VariablesView.this.getAction("ShowTypeNames")) != null) {
                    action.setEnabled(event.getNewValue() == null);
                }
            }
        });
        variablesViewer.addPostSelectionChangedListener(this.getTreeSelectionChangedListener());
        DebugUITools.addPartDebugContextListener(this.getSite(), this);
        return variablesViewer;
    }

    private void setGlobalActions() {
        for (Map.Entry<String, IAction> entry : this.fGlobalActionMap.entrySet()) {
            String actionID = entry.getKey();
            IAction action = this.getOverrideAction(actionID);
            if (action == null) {
                action = entry.getValue();
            }
            this.setAction(actionID, action);
        }
        this.getViewSite().getActionBars().updateActionBars();
    }

    @Override
    protected void createContextMenu(Control menuControl) {
        super.createContextMenu(menuControl);
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (!this.fGlobalActionMap.containsKey(SELECT_ALL_ACTION)) {
            this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, actionBars.getGlobalActionHandler(SELECT_ALL_ACTION));
        }
        if (!this.fGlobalActionMap.containsKey(COPY_ACTION)) {
            this.setGlobalAction(COPY_ACTION, actionBars.getGlobalActionHandler(COPY_ACTION));
        }
        if (!this.fGlobalActionMap.containsKey(PASTE_ACTION)) {
            this.setGlobalAction(PASTE_ACTION, actionBars.getGlobalActionHandler(PASTE_ACTION));
        }
    }

    private void clearGlobalActions() {
        for (String id : this.fGlobalActionMap.keySet()) {
            this.setAction(id, null);
        }
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected ISelection getDebugContext() {
        IViewSite site = (IViewSite)this.getSite();
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        return contextService.getActiveContext(site.getId(), site.getSecondaryId());
    }

    protected String getPresentationContextId() {
        return "org.eclipse.debug.ui.VariableView";
    }

    protected String getPresentationContextSecondaryId() {
        return ((IViewSite)this.getSite()).getSecondaryId();
    }

    protected int getViewerStyle() {
        return 268501762;
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.variable_view_context";
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if ("Variables.detail.orientation.auto".equals(VariablesView.this.fCurrentDetailPaneOrientation)) {
                    VariablesView.this.setDetailPaneOrientation("Variables.detail.orientation.auto");
                }
            }
        });
    }

    int computeOrientation() {
        Point size = this.fParent.getSize();
        if (size.x != 0 && size.y != 0) {
            if (size.x / 3 > size.y) {
                return 256;
            }
            return 512;
        }
        return 256;
    }

    public void setDetailPaneOrientation(String orientation) {
        if (!"Variables.detail.orientation.auto".equals(orientation) && orientation.equals(this.fCurrentDetailPaneOrientation)) {
            return;
        }
        this.fCurrentDetailPaneOrientation = orientation;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue(this.getDetailPanePreferenceKey(), orientation);
        if (orientation.equals("Variables.detail.orientation.hidden")) {
            this.hideDetailPane();
        } else {
            int vertOrHoriz = -1;
            if (orientation.equals("Variables.detail.orientation.auto")) {
                vertOrHoriz = this.computeOrientation();
                if (this.fPaneBuilt && this.fSashForm.getOrientation() == vertOrHoriz) {
                    this.showDetailPane();
                    return;
                }
            } else {
                vertOrHoriz = orientation.equals("Variables.detail.orientation.underneath") ? 512 : 256;
            }
            this.buildDetailPane(vertOrHoriz);
            this.revealTreeSelection();
        }
    }

    private void buildDetailPane(int orientation) {
        try {
            this.fDetailsAnchor.setRedraw(false);
            if (this.fDetailsComposite != null) {
                this.fDetailPane.dispose();
                this.fDetailsComposite.dispose();
            }
            this.fSashForm.setOrientation(orientation);
            if (orientation == 512) {
                this.fDetailsComposite = SWTFactory.createComposite(this.fDetailsAnchor, this.fDetailsAnchor.getFont(), 1, 1, 1808, 0, 0);
                GridLayout layout = (GridLayout)this.fDetailsComposite.getLayout();
                layout.verticalSpacing = 0;
                this.fSeparator = new Label(this.fDetailsComposite, 258);
                this.fSeparator.setLayoutData((Object)new GridData(4, 128, true, false));
            } else {
                this.fDetailsComposite = SWTFactory.createComposite(this.fDetailsAnchor, this.fDetailsAnchor.getFont(), 2, 1, 1808, 0, 0);
                GridLayout layout = (GridLayout)this.fDetailsComposite.getLayout();
                layout.horizontalSpacing = 0;
                this.fSeparator = new Label(this.fDetailsComposite, 514);
                this.fSeparator.setLayoutData((Object)new GridData(128, 4, false, true));
            }
            this.showDetailPane();
        }
        finally {
            this.fDetailsAnchor.layout(true);
            this.fDetailsAnchor.setRedraw(true);
            this.fPaneBuilt = true;
        }
    }

    private void hideDetailPane() {
        if (this.fToggledDetailOnce) {
            this.setLastSashWeights(this.fSashForm.getWeights());
        }
        this.fSashForm.setMaximizedControl(this.getViewer().getControl());
    }

    private void showDetailPane() {
        this.fSashForm.setMaximizedControl(null);
        this.fSashForm.setWeights(this.getLastSashWeights());
        this.refreshDetailPaneContents();
        this.fToggledDetailOnce = true;
    }

    protected void revealTreeSelection() {
        Object selected;
        ISelection selection;
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) != null) {
            viewer.reveal(selected);
        }
    }

    protected int[] getLastSashWeights() {
        if (this.fLastSashWeights == null) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        } else if (this.fLastSashWeights[0] < 0 || this.fLastSashWeights[1] < 0) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        }
        return this.fLastSashWeights;
    }

    protected void setLastSashWeights(int[] weights) {
        this.fLastSashWeights = weights;
    }

    @Override
    protected void createActions() {
        Object action = new ShowTypesAction(this);
        this.setAction("ShowTypeNames", (IAction)action);
        action = new ToggleLogicalStructureAction(this);
        this.setAction("ToggleContentProviders", (IAction)action);
        action = new CollapseAllAction((TreeModelViewer)this.getViewer());
        this.setAction(COLLAPSE_ALL, (IAction)action);
        IHandlerService hs = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (hs != null) {
            hs.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler((IAction)action));
        }
        action = new ChangeVariableValueAction(this);
        action.setEnabled(false);
        this.setAction("ChangeVariableValue", (IAction)action);
        action = new VirtualFindAction(this.getVariablesViewer());
        this.setGlobalAction(FIND_ACTION, (IAction)action);
    }

    protected void setGlobalAction(String actionID, IAction action) {
        this.fGlobalActionMap.put(actionID, action);
    }

    @Override
    public IAction getAction(String actionID) {
        IAction overrideAction;
        if (!this.fGlobalActionMap.containsKey(actionID) && (overrideAction = this.getOverrideAction(actionID)) != null) {
            return overrideAction;
        }
        return super.getAction(actionID);
    }

    private IAction getOverrideAction(String actionID) {
        IAction action;
        IViewActionProvider actionProvider;
        Viewer viewer = this.getViewer();
        if (viewer != null && (actionProvider = (IViewActionProvider)DebugPlugin.getAdapter((Object)viewer.getInput(), IViewActionProvider.class)) != null && (action = actionProvider.getAction(this.getPresentationContext(), actionID)) != null) {
            return action;
        }
        return null;
    }

    @Override
    public void updateObjects() {
        super.updateObjects();
        if (this.fTreeHasFocus) {
            this.setGlobalActions();
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    private void createOrientationActions(TreeModelViewer viewer) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fToggleDetailPaneActions = new ToggleDetailPaneAction[4];
        this.fToggleDetailPaneActions[0] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.underneath", null);
        this.fToggleDetailPaneActions[1] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.right", null);
        this.fToggleDetailPaneActions[2] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.auto", null);
        this.fToggleDetailPaneActions[3] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.hidden", this.getToggleActionLabel());
        viewMenu.add((IContributionItem)new Separator());
        final MenuManager layoutSubMenu = new MenuManager(VariablesViewMessages.VariablesView_40);
        layoutSubMenu.setRemoveAllWhenShown(true);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[0]);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[1]);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[2]);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[3]);
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        this.fConfigureColumnsAction = new ConfigureColumnsAction(viewer);
        this.setAction("ToggleColmns", (IAction)new ToggleShowColumnsAction(viewer));
        layoutSubMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[0]);
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[1]);
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[2]);
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[3]);
                IAction action = VariablesView.this.getAction("ToggleColmns");
                ((IUpdate)action).update();
                if (action.isEnabled()) {
                    layoutSubMenu.add(action);
                }
                VariablesView.this.fConfigureColumnsAction.update();
                if (VariablesView.this.fConfigureColumnsAction.isEnabled()) {
                    layoutSubMenu.add((IAction)VariablesView.this.fConfigureColumnsAction);
                }
            }
        });
    }

    protected String getToggleActionLabel() {
        return VariablesViewMessages.VariablesView_41;
    }

    @Override
    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("ShowTypeNames"));
        tbm.add(this.getAction("ToggleContentProviders"));
        tbm.add(this.getAction(COLLAPSE_ALL));
    }

    @Override
    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyVariableGroup"));
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction(FIND_ACTION));
        ChangeVariableValueAction changeValueAction = (ChangeVariableValueAction)this.getAction("ChangeVariableValue");
        if (changeValueAction.isApplicable()) {
            menu.add((IAction)changeValueAction);
        }
        menu.add((IContributionItem)new Separator());
        Action action = new AvailableLogicalStructuresAction(this);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        action = new AvailableDetailPanesAction(this);
        if (this.isDetailPaneVisible() && action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected ISelectionChangedListener getTreeSelectionChangedListener() {
        if (this.fTreeSelectionChangedListener == null) {
            this.fTreeSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals(VariablesView.this.getViewer())) {
                        VariablesView.this.clearStatusLine();
                        if (VariablesView.this.fSashForm.getMaximizedControl() == VariablesView.this.getViewer().getControl()) {
                            return;
                        }
                        VariablesView.this.refreshDetailPaneContents();
                        VariablesView.this.treeSelectionChanged(event);
                    }
                }
            };
        }
        return this.fTreeSelectionChangedListener;
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
    }

    @Override
    public String getCurrentPaneID() {
        return this.fDetailPane.getCurrentPaneID();
    }

    @Override
    public IStructuredSelection getCurrentSelection() {
        if (this.getViewer() != null) {
            return (IStructuredSelection)this.getViewer().getSelection();
        }
        return null;
    }

    @Override
    public Composite getParentComposite() {
        return this.fDetailsComposite;
    }

    @Override
    public IWorkbenchPartSite getWorkbenchPartSite() {
        return this.getSite();
    }

    @Override
    public void refreshDetailPaneContents() {
        if (this.isDetailPaneVisible()) {
            String currentPaneID = this.getCurrentPaneID();
            if (currentPaneID != null) {
                this.fLastSashWeights = this.fSashForm.getWeights();
            }
            this.fDetailPane.display(this.getCurrentSelection());
            Control control = this.fDetailPane.getCurrentControl();
            if (control.getBackground().equals((Object)this.fSashForm.getDisplay().getSystemColor(22))) {
                this.fSashForm.setBackground(this.fSashForm.getDisplay().getSystemColor(25));
                this.fSeparator.setVisible(true);
                this.fSeparator.setBackground(control.getBackground());
            } else {
                this.fSashForm.setBackground(this.fSashForm.getDisplay().getSystemColor(22));
                this.fSeparator.setVisible(false);
            }
        }
    }

    @Override
    public void paneChanged(String newPaneID) {
        if (this.fDetailPaneActivatedListener == null) {
            this.fDetailPaneActivatedListener = new Listener(){

                public void handleEvent(Event event) {
                    VariablesView.this.fTreeHasFocus = false;
                }
            };
        }
        this.fDetailPane.getCurrentControl().addListener(26, this.fDetailPaneActivatedListener);
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new VariablesViewModelPresentation();
        }
        return this.fModelPresentation;
    }

    @Override
    public <T> T getAdapter(Class<T> required) {
        Object adapter;
        if (IDebugModelPresentation.class.equals(required)) {
            return (T)this.getModelPresentation();
        }
        if (this.fDetailPane != null && (adapter = this.fDetailPane.getAdapter(required)) != null) {
            return (T)adapter;
        }
        return super.getAdapter(required);
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action == null) {
            action = this.fGlobalActionMap.get(actionId);
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected boolean isDetailPaneVisible() {
        return !this.fToggleDetailPaneActions[3].isChecked();
    }

    @Override
    protected Control getDefaultControl() {
        return this.fSashForm;
    }

    @Override
    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    protected void contextActivated(ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Object source = ((IStructuredSelection)selection).getFirstElement();
            this.fInputService.resolveViewerInput(source);
        }
    }

    @Override
    public void doubleClick(DoubleClickEvent event) {
        IAction action = this.getAction("Double_Click_ActionId");
        if (action != null && action.isEnabled()) {
            action.run();
        } else {
            Widget item;
            TreeSelection ss;
            ISelection selection = this.getVariablesViewer().getSelection();
            if (selection instanceof TreeSelection && (ss = (TreeSelection)selection).size() == 1 && (item = this.getVariablesViewer().findItem(ss.getPaths()[0])) instanceof TreeItem) {
                TreeItem ti = (TreeItem)item;
                if (ti.getExpanded()) {
                    ti.setExpanded(false);
                } else {
                    this.getVariablesViewer().expandToLevel(ss.getPaths()[0], 1);
                }
            }
        }
    }

    @Override
    public IDebugModelPresentation getPresentation(String id) {
        if (this.getViewer() instanceof StructuredViewer) {
            IDebugModelPresentation lp = this.getModelPresentation();
            if (lp instanceof DelegatingModelPresentation) {
                return ((DelegatingModelPresentation)lp).getPresentation(id);
            }
            if (lp instanceof LazyModelPresentation && ((LazyModelPresentation)lp).getDebugModelIdentifier().equals(id)) {
                return lp;
            }
        }
        return null;
    }

    public boolean isMainViewerAvailable() {
        return this.isAvailable();
    }

    protected IPresentationContext getPresentationContext() {
        return this.getVariablesViewer().getPresentationContext();
    }

    public void setShowLogicalStructure(boolean flag) {
        this.getPresentationContext().setProperty(PRESENTATION_SHOW_LOGICAL_STRUCTURES, flag);
    }

    public boolean isShowLogicalStructure() {
        Boolean show = (Boolean)this.getPresentationContext().getProperty(PRESENTATION_SHOW_LOGICAL_STRUCTURES);
        return show != null && show != false;
    }

    @Override
    protected void becomesHidden() {
        this.fInputService.resolveViewerInput(ViewerInputService.NULL_INPUT);
        super.becomesHidden();
    }

    @Override
    protected void becomesVisible() {
        super.becomesVisible();
        ISelection selection = this.getDebugContext();
        this.contextActivated(selection);
    }

    protected TreeModelViewer getVariablesViewer() {
        return (TreeModelViewer)this.getViewer();
    }

    protected void clearStatusLine() {
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.setErrorMessage(null);
        manager.setMessage(null);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId.equals("reset")) {
            this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
            this.fSashForm.setWeights(DEFAULT_SASH_WEIGHTS);
            this.fSashForm.layout(true);
        }
    }

    @Override
    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        this.fVisitor.reset();
        delta.accept(this.fVisitor);
        this.updateAction(FIND_ACTION);
        this.updateAction(COLLAPSE_ALL);
    }

    @Override
    public void updateComplete(IViewerUpdate update) {
        IStatus status = update.getStatus();
        if (!update.isCanceled()) {
            if (status != null && !status.isOK()) {
                this.showMessage(status.getMessage());
            } else {
                this.showViewer();
            }
            if (TreePath.EMPTY.equals((Object)update.getElementPath())) {
                this.updateAction(FIND_ACTION);
                this.updateAction(COLLAPSE_ALL);
            }
        }
    }

    @Override
    public void updateStarted(IViewerUpdate update) {
    }

    @Override
    public synchronized void viewerUpdatesBegin() {
        this.fTriggerDetailsJob.cancel();
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            progressService.incrementBusy();
        }
    }

    @Override
    public synchronized void viewerUpdatesComplete() {
        IWorkbenchSiteProgressService progressService;
        if (this.fVisitor.isTriggerDetails()) {
            this.fTriggerDetailsJob.schedule();
        }
        if ((progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            progressService.decrementBusy();
        }
    }

    public void setFocus() {
        boolean success = false;
        if (!this.fTreeHasFocus && this.fDetailPane != null) {
            success = this.fDetailPane.setFocus();
        }
        if (!success && this.getViewer() != null) {
            this.getViewer().getControl().setFocus();
        }
    }

    protected ToggleDetailPaneAction getToggleDetailPaneAction(String orientation) {
        int i = 0;
        while (i < this.fToggleDetailPaneActions.length) {
            if (this.fToggleDetailPaneActions[i].getOrientation().equals(orientation)) {
                return this.fToggleDetailPaneActions[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setSelectionProvider(ISelectionProvider provider) {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        this.fSelectionProvider.setActiveProvider(provider);
    }

    public void doSave(IProgressMonitor monitor) {
        this.fDetailPane.doSave(monitor);
    }

    public void doSaveAs() {
        this.fDetailPane.doSaveAs();
    }

    public boolean isDirty() {
        return this.fDetailPane.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return this.fDetailPane.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.fDetailPane.isSaveOnCloseNeeded();
    }

    public int promptToSaveOnClose() {
        return 0;
    }

    private static class SelectionProviderWrapper
    implements ISelectionProvider {
        private final ListenerList fListenerList = new ListenerList(1);
        private final ISelectionChangedListener fListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectionProviderWrapper.this.fireSelectionChanged(event);
            }
        };
        private ISelectionProvider fActiveProvider;

        private SelectionProviderWrapper(ISelectionProvider provider) {
            this.setActiveProvider(provider);
        }

        private void setActiveProvider(ISelectionProvider provider) {
            if (this.fActiveProvider == provider || this == provider) {
                return;
            }
            if (this.fActiveProvider != null) {
                this.fActiveProvider.removeSelectionChangedListener(this.fListener);
            }
            if (provider != null) {
                provider.addSelectionChangedListener(this.fListener);
            }
            this.fActiveProvider = provider;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void dispose() {
            this.fListenerList.clear();
            this.setActiveProvider(null);
        }

        private void fireSelectionChanged(SelectionChangedEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fActiveProvider != null) {
                return this.fActiveProvider.getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListenerList.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            if (this.fActiveProvider != null) {
                this.fActiveProvider.setSelection(selection);
            }
        }
    }

    class Visitor
    implements IModelDeltaVisitor {
        private boolean fTriggerDetails = false;

        Visitor() {
        }

        @Override
        public boolean visit(IModelDelta delta, int depth) {
            if ((delta.getFlags() & 0x400) > 0) {
                this.fTriggerDetails = true;
                return false;
            }
            return true;
        }

        public void reset() {
            this.fTriggerDetails = false;
        }

        public boolean isTriggerDetails() {
            return this.fTriggerDetails;
        }
    }
}

