/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.impl;

import java.io.IOException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.rcptt.ctx.preferences.impl.Activator;
import org.eclipse.rcptt.internal.preferences.PrefUtils;
import org.eclipse.rcptt.preferences.PrefData;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.PreferencesFactory;
import org.eclipse.rcptt.preferences.SecurePrefNode;
import org.eclipse.rcptt.preferences.StringPrefData;

public class SecuritySupport {
    public static SecurePrefNode collectSecureSettings() throws StorageException {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        return SecuritySupport.processSecurePreferences(preferences);
    }

    public static SecurePrefNode processSecurePreferences(ISecurePreferences preferences) throws StorageException {
        String[] keys;
        String[] childNames;
        SecurePrefNode prefNode = PreferencesFactory.eINSTANCE.createSecurePrefNode();
        prefNode.setName(preferences.name());
        String[] stringArray = childNames = preferences.childrenNames();
        int n = childNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            SecurePrefNode childNode = SecuritySupport.processSecurePreferences(preferences.node(childName));
            prefNode.getChilds().add((Object)childNode);
            ++n2;
        }
        String[] stringArray2 = keys = preferences.keys();
        int n3 = keys.length;
        n = 0;
        while (n < n3) {
            String key = stringArray2[n];
            try {
                String value = preferences.get(key, null);
                if (value != null) {
                    StringPrefData prefData = PreferencesFactory.eINSTANCE.createStringPrefData();
                    prefData.setKey(key);
                    prefData.setValue(value);
                    PrefUtils.encodeWorkspaceLocation((StringPrefData)prefData);
                    prefNode.getData().add((Object)prefData);
                }
            }
            catch (StorageException e) {
                Activator.log(e);
            }
            ++n;
        }
        return prefNode;
    }

    public static void applySecureSettings(SecurePrefNode securePrefNode, boolean clean) throws StorageException, IOException {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        if (clean) {
            String[] childs;
            root.clear();
            String[] stringArray = childs = root.childrenNames();
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                root.node(child).removeNode();
                ++n2;
            }
        }
        SecuritySupport.applySecureSettings((PrefNode)securePrefNode, root);
        root.flush();
    }

    public static void applySecureSettings(PrefNode prefNode, ISecurePreferences secureNode) throws StorageException {
        for (PrefData data : prefNode.getData()) {
            if (!(data instanceof StringPrefData)) continue;
            StringPrefData stringData = (StringPrefData)data;
            PrefUtils.decodeWorkspaceLocation((StringPrefData)stringData);
            secureNode.put(stringData.getKey(), stringData.getValue(), false);
        }
        for (PrefNode childNode : prefNode.getChilds()) {
            SecuritySupport.applySecureSettings(childNode, secureNode.node(childNode.getName()));
        }
    }
}

