/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.internal;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.util.FileUtil;
import org.osgi.framework.BundleContext;

public class Q7ReportingPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.reporting";
    private static Q7ReportingPlugin plugin;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        ReportManager.reload();
        Job cleanPreviousExecutionSessions = new Job("Q7: Clean execution sessions"){

            protected IStatus run(IProgressMonitor monitor) {
                File root = Q7ReportingPlugin.getConfigStateLocation();
                if (root.exists()) {
                    FileUtil.deleteFiles((File[])root.listFiles());
                }
                return Status.OK_STATUS;
            }
        };
        cleanPreviousExecutionSessions.setSystem(true);
        cleanPreviousExecutionSessions.schedule();
    }

    public static File getConfigStateLocation() {
        File result = null;
        Location configurationLocation = Platform.getConfigurationLocation();
        result = configurationLocation == null ? Q7ReportingPlugin.getDefault().getStateLocation().toFile() : new File(new File(configurationLocation.getURL().getFile()), PLUGIN_ID);
        result.mkdirs();
        return result;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static Q7ReportingPlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        Q7ReportingPlugin.log(t.getMessage(), t);
    }

    public static void log(String message, Throwable t) {
        Q7ReportingPlugin.getDefault().getLog().log(Q7ReportingPlugin.createStatus(message, t));
    }

    public static IStatus createStatus(String message) {
        return Q7ReportingPlugin.createStatus(message, null);
    }

    public static IStatus createStatus(Throwable t) {
        return Q7ReportingPlugin.createStatus(t.getMessage(), t);
    }

    public static IStatus createStatus(String message, Throwable t) {
        return new Status(4, PLUGIN_ID, message, t);
    }

    public static void logWarn(String message, Throwable t) {
        Status status = new Status(2, PLUGIN_ID, message, t);
        Q7ReportingPlugin.getDefault().getLog().log((IStatus)status);
    }
}

