/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rcptt.ctx.filesystem.FSUtils;
import org.eclipse.rcptt.ctx.filesystem.ui.Activator;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.FSAction;
import org.eclipse.rcptt.filesystem.FSFolder;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddFolder
extends FSAction {
    public AddFolder() {
        super("Add Folder...", Images.getImageDescriptor((String)"icons/newFolder.gif"));
    }

    @Override
    protected void init() {
        this.setEnabled(this.getFolder() != null);
    }

    public void run() {
        block5: {
            Shell shell = this.viewer.getTree().getShell();
            DirectoryDialog dialog = new DirectoryDialog(shell);
            final String path = dialog.open();
            if (path == null) {
                return;
            }
            final FSFolder parent = this.getFolder();
            final AtomicReference result = new AtomicReference();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Adding folder...", -1);
                    try {
                        result.set(FSUtils.addFolder((FSFolder)parent, (String)path));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                FSFolder folder = (FSFolder)result.get();
                if (folder == null) {
                    return;
                }
                this.viewer.setSelection((ISelection)new StructuredSelection(result.get()));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                MessageDialog.openError((Shell)shell, (String)"Error adding folder", (String)t.getMessage());
                if (t.getCause() == null && t instanceof CoreException) break block5;
                Activator.logErr(t, "Error adding folder", new Object[0]);
            }
        }
    }
}

