/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class OrRevFilter
extends RevFilter {
    public static RevFilter create(RevFilter a, RevFilter b) {
        if (a == ALL || b == ALL) {
            return ALL;
        }
        return new Binary(a, b);
    }

    public static RevFilter create(RevFilter[] list) {
        if (list.length == 2) {
            return OrRevFilter.create(list[0], list[1]);
        }
        if (list.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] subfilters = new RevFilter[list.length];
        System.arraycopy(list, 0, subfilters, 0, list.length);
        return new List(subfilters);
    }

    public static RevFilter create(Collection<RevFilter> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] subfilters = new RevFilter[list.size()];
        list.toArray(subfilters);
        if (subfilters.length == 2) {
            return OrRevFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends OrRevFilter {
        private final RevFilter a;
        private final RevFilter b;
        private final boolean requiresCommitBody;

        Binary(RevFilter one, RevFilter two) {
            this.a = one;
            this.b = two;
            this.requiresCommitBody = this.a.requiresCommitBody() || this.b.requiresCommitBody();
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.a.include(walker, c) || this.b.include(walker, c);
        }

        @Override
        public boolean requiresCommitBody() {
            return this.requiresCommitBody;
        }

        @Override
        public RevFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " OR " + this.b.toString() + ")";
        }
    }

    private static class List
    extends OrRevFilter {
        private final RevFilter[] subfilters;
        private final boolean requiresCommitBody;

        List(RevFilter[] list) {
            this.subfilters = list;
            boolean rcb = false;
            for (RevFilter filter : this.subfilters) {
                rcb |= filter.requiresCommitBody();
            }
            this.requiresCommitBody = rcb;
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            for (RevFilter f : this.subfilters) {
                if (!f.include(walker, c)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean requiresCommitBody() {
            return this.requiresCommitBody;
        }

        @Override
        public RevFilter clone() {
            RevFilter[] s = new RevFilter[this.subfilters.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = this.subfilters[i].clone();
            }
            return new List(s);
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            for (int i = 0; i < this.subfilters.length; ++i) {
                if (i > 0) {
                    r.append(" OR ");
                }
                r.append(this.subfilters[i].toString());
            }
            r.append(")");
            return r.toString();
        }
    }
}

