/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.search.dependencies.GatherUnusedDependenciesOperation;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UnusedImportsDialog
extends TrayDialog {
    private IPluginModelBase model;
    private Object[] unused;
    private WizardCheckboxTablePart checkboxTablePart;
    private CheckboxTableViewer choiceViewer;

    public UnusedImportsDialog(Shell parentShell, IPluginModelBase model, Object[] unused) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.model = model;
        this.unused = unused;
        this.checkboxTablePart = new WizardCheckboxTablePart(PDEUIMessages.UnusedDependencies_remove);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.unused_imports_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 9;
        layout.marginWidth = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.checkboxTablePart.createControl(container);
        this.choiceViewer = this.checkboxTablePart.getTableViewer();
        this.choiceViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.choiceViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.choiceViewer.setComparator((ViewerComparator)new Comparator());
        gd = (GridData)this.checkboxTablePart.getControl().getLayoutData();
        gd.widthHint = 250;
        gd.heightHint = 275;
        this.choiceViewer.setInput((Object)PDEPlugin.getDefault());
        this.checkboxTablePart.setSelection(this.unused);
        return container;
    }

    protected void okPressed() {
        GatherUnusedDependenciesOperation.removeDependencies(this.model, this.choiceViewer.getCheckedElements());
        super.okPressed();
    }

    static class Comparator
    extends ListUtil.PluginComparator {
        Comparator() {
        }

        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1.getClass() == e2.getClass()) {
                return super.compare(viewer, e1, e2);
            }
            if (e1 instanceof ImportPackageObject) {
                return 1;
            }
            return -1;
        }
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return UnusedImportsDialog.this.unused;
        }
    }
}

