/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.AbstractDebugListSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class LaunchShortcutSelectionDialog
extends AbstractDebugListSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.debug.ui.SELECT_LAUNCH_SHORTCUT_DIALOG";
    private String fModeName = null;
    private String fMode = null;
    private IResource fResource = null;
    private List<LaunchShortcutExtension> fShortcuts = null;
    private Text fDescriptionText = null;

    public LaunchShortcutSelectionDialog(List<LaunchShortcutExtension> shortcuts, IResource resource, String mode) {
        super(DebugUIPlugin.getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fShortcuts = shortcuts;
        this.fResource = resource;
        this.fMode = mode;
        ILaunchMode lmode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
        this.fModeName = mode;
        if (lmode != null) {
            this.fModeName = DebugUIPlugin.removeAccelerators(lmode.getLabel());
        }
        this.setTitle(MessageFormat.format((String)LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_0, (Object[])new Object[]{this.fModeName}));
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.select_launch_method_dialog";
    }

    @Override
    protected String getDialogSettingsId() {
        return DIALOG_SETTINGS;
    }

    @Override
    protected void addViewerListeners(StructuredViewer viewer) {
        super.addViewerListeners(viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty()) {
                    LaunchShortcutExtension shortcutSource = (LaunchShortcutExtension)((IStructuredSelection)selection).getFirstElement();
                    String description = shortcutSource.getShortcutDescription(LaunchShortcutSelectionDialog.this.fMode);
                    LaunchShortcutSelectionDialog.this.fDescriptionText.setText(description == null ? LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_3 : description);
                }
            }
        });
    }

    @Override
    protected void addCustomFooterControls(Composite parent) {
        super.addCustomFooterControls(parent);
        Group group = SWTFactory.createGroup(parent, LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_2, 1, 1, 1808);
        GridData gd = (GridData)group.getLayoutData();
        gd.heightHint = 100;
        this.fDescriptionText = SWTFactory.createText((Composite)group, 72, 1, 768);
        this.fDescriptionText.setBackground(group.getBackground());
    }

    @Override
    protected Object getViewerInput() {
        return this.fShortcuts;
    }

    @Override
    protected String getViewerLabel() {
        if (this.fResource == null) {
            return MessageFormat.format((String)LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_4, (Object[])new Object[]{this.fModeName.toLowerCase()});
        }
        return MessageFormat.format((String)LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_1, (Object[])new Object[]{this.fModeName.toLowerCase(), this.fResource.getName()});
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(!this.getViewer().getSelection().isEmpty());
    }
}

