/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import com.ibm.icu.text.BreakIterator;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class WordTokenStream
extends Tokenizer {
    private static final int BUF_LEN = 4096;
    private final Reader reader;
    private final BreakIterator boundary;
    private StringBuffer strbuf;
    private int start = 0;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public WordTokenStream(String fieldName, Reader reader, Locale locale) {
        this.reader = reader;
        this.boundary = BreakIterator.getWordInstance((Locale)locale);
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        int length = 0;
        char[] buffer = this.termAtt.buffer();
        if (this.strbuf == null) {
            int c;
            int available;
            char[] cbuf = new char[4096];
            while ((available = this.reader.read(cbuf)) <= 0) {
                if (available >= 0) continue;
                this.reader.close();
                return false;
            }
            this.strbuf = new StringBuffer(available + 80);
            this.strbuf.append(cbuf, 0, available);
            while ((c = this.reader.read()) >= 0) {
                this.strbuf.append((char)c);
                if (c == 32 || c == 13 || c == 10 || c == 9) break;
            }
            if (c < 0) {
                this.reader.close();
            }
            this.boundary.setText(this.strbuf.toString());
            this.start = this.boundary.first();
        } else {
            this.start = this.boundary.next();
        }
        int end = this.boundary.next();
        while (end != -1) {
            int i = this.start;
            while (i < end) {
                if (Character.isLetterOrDigit(this.strbuf.charAt(i))) {
                    length = end - this.start;
                    if (length >= buffer.length - 1) {
                        buffer = this.termAtt.resizeBuffer(2 + length);
                    }
                    this.termAtt.setLength(length);
                    this.strbuf.getChars(this.start, end, buffer, 0);
                    return true;
                }
                ++i;
            }
            this.start = end;
            end = this.boundary.next();
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.clearAttributes();
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

