/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import org.eclipse.equinox.frameworkadmin.BundleInfo;

public class BundleStart {
    public static BundleStart DEFAULT = new BundleStart(-1, false, true, true);
    private final int level;
    private final boolean autoStart;
    private boolean levelIsDefault;
    private boolean autoStartIsDefault;
    private static final String DEF_STR = "default";
    private static final String START_STR = "start";

    private BundleStart(int level, boolean autoStart, boolean levelIsDefault, boolean autostartIsDefault) {
        this.level = level;
        this.levelIsDefault = levelIsDefault;
        this.autoStart = autoStart;
        this.autoStartIsDefault = autostartIsDefault;
    }

    public boolean isDefault() {
        return this.levelIsDefault && this.autoStartIsDefault;
    }

    public String toOsgiString(int defaultStartLevel) {
        if (this.levelIsDefault && this.autoStartIsDefault) {
            return "";
        }
        if (this.autoStartIsDefault) {
            return String.format("@%d", this.level);
        }
        int resolvedLevel = this.levelIsDefault ? defaultStartLevel : this.level;
        String resolvedStart = this.autoStart ? ":start" : "";
        return String.format("@%d%s", resolvedLevel, resolvedStart);
    }

    public static BundleStart fromOsgiString(String str) {
        String autoStartStr;
        if (str == null) {
            return DEFAULT;
        }
        if (str.startsWith("@")) {
            str = str.substring(1);
        }
        if (str.length() == 0) {
            return DEFAULT;
        }
        int sep = str.indexOf(58);
        String levelStr = sep == -1 ? str : str.substring(0, sep);
        String string = autoStartStr = sep == -1 ? "" : str.substring(sep + 1);
        if (START_STR.equals(levelStr) && autoStartStr.length() == 0) {
            return new BundleStart(-1, true, true, false);
        }
        boolean isDefaultLevel = levelStr.length() == 0;
        int level = isDefaultLevel ? -1 : Integer.parseInt(levelStr);
        boolean isDefaultAutoStart = sep == -1;
        boolean autoStart = START_STR.equals(autoStartStr);
        return new BundleStart(level, autoStart, isDefaultLevel, isDefaultAutoStart);
    }

    public String toModelString() {
        return String.format("%s:%s", this.levelIsDefault ? DEF_STR : Integer.toString(this.level), this.autoStartIsDefault ? DEF_STR : Boolean.toString(this.autoStart));
    }

    public static BundleStart fromModelString(String str) {
        if (str == null || str.length() == 0) {
            return DEFAULT;
        }
        int sep = str.indexOf(58);
        String levelStr = sep == -1 ? str : str.substring(0, sep);
        String startStr = sep == -1 ? DEF_STR : str.substring(sep + 1);
        boolean isDefaultLevel = DEF_STR.equals(levelStr);
        boolean isDefaultStart = DEF_STR.equals(startStr);
        return new BundleStart(isDefaultLevel ? -1 : Integer.parseInt(levelStr), isDefaultStart ? false : Boolean.parseBoolean(startStr), isDefaultLevel, isDefaultStart);
    }

    public static BundleStart fromBundle(BundleInfo info) {
        return new BundleStart(info.getStartLevel(), info.isMarkedAsStarted(), info.getStartLevel() == -1, !info.isMarkedAsStarted());
    }

    public static BundleStart fromQ7Headers(String q7sl, String q7as) {
        return BundleStart.fromModelString(Joiner.on((char)':').join(Objects.firstNonNull((Object)q7sl, (Object)DEF_STR), Objects.firstNonNull((Object)q7as, (Object)DEF_STR), new Object[0]));
    }
}

