/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.TypeAnnotations;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.builder.BuildStamps;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class IncrementalApiBuilder {
    private static final int UNKNOWN = 0;
    private static final int CLASS_FILE = 1;
    private static final int JAVA__FILE = 2;
    private static final int STRUCTURAL = 1;
    private static final int DESCRIPTION = 2;
    ApiAnalysisBuilder builder = null;
    BuildContext context = null;
    IApiBaseline workspaceBaseline = null;

    public IncrementalApiBuilder(ApiAnalysisBuilder builder) {
        this.builder = builder;
    }

    public void build(IApiBaseline baseline, IApiBaseline wbaseline, IResourceDelta[] deltas, State state, BuildState buildstate, IProgressMonitor monitor) throws CoreException {
        IProject project = this.builder.getProject();
        this.workspaceBaseline = wbaseline;
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)BuilderMessages.IncrementalBuilder_builder_for_project, (Object)project.getName()), (int)1);
        this.context = new BuildContext();
        try {
            try {
                String[] projectNames = buildstate.getReexportedComponents();
                HashSet<IProject> depprojects = null;
                if (projectNames.length != 0) {
                    depprojects = new HashSet<IProject>();
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IProject pj = null;
                    int i = 0;
                    int max = projectNames.length;
                    while (i < max) {
                        pj = root.getProject(projectNames[i]);
                        if (pj.isAccessible() && baseline != null && baseline.getApiComponent(projectNames[i]) == null) {
                            depprojects.add(pj);
                        }
                        ++i;
                    }
                }
                long prev = buildstate.getBuildPathCRC();
                long curr = BuildState.computeBuildPathCRC(project);
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(curr != prev);
                int i = 0;
                while (i < deltas.length) {
                    deltas[i].accept((IResourceDeltaVisitor)visitor);
                    ++i;
                }
                this.buildContext(project, state, visitor.changes, depprojects);
                this.build(project, baseline, wbaseline, state, buildstate, (IProgressMonitor)localmonitor.newChild(1));
            }
            catch (OperationCanceledException operationCanceledException) {
                if (ApiPlugin.DEBUG_BUILDER) {
                    System.out.println("ApiAnalysisBuilder: Trapped OperationCanceledException");
                }
                if (!localmonitor.isCanceled()) {
                    localmonitor.done();
                }
                this.context.dispose();
            }
        }
        finally {
            if (!localmonitor.isCanceled()) {
                localmonitor.done();
            }
            this.context.dispose();
        }
    }

    void build(IProject project, IApiBaseline baseline, IApiBaseline wbaseline, State state, BuildState buildstate, IProgressMonitor monitor) {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_on_0, (int)6);
        try {
            IPluginModelBase currentModel;
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            localmonitor.subTask(NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_finding_affected_source_files, (Object)project.getName()));
            Util.updateMonitor((IProgressMonitor)localmonitor, 0);
            if (this.context.hasTypes() && (currentModel = this.builder.getCurrentModel()) != null) {
                String id = currentModel.getBundleDescription().getSymbolicName();
                IApiComponent comp = wbaseline.getApiComponent(id);
                if (comp == null) {
                    return;
                }
                this.extClean(project, buildstate, (IProgressMonitor)localmonitor.newChild(1));
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                this.builder.getAnalyzer().analyzeComponent(buildstate, null, null, baseline, comp, this.context, (IProgressMonitor)localmonitor.newChild(1));
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                this.builder.createMarkers();
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            }
        }
        finally {
            if (localmonitor != null) {
                localmonitor.done();
            }
        }
    }

    private void addDependentTypeToContext(IFile file, int kind) {
        String type = this.resolveTypeName((IResource)file, 2);
        if (type == null) {
            return;
        }
        if ((1 & kind) > 0 && !this.context.containsStructuralChange(type)) {
            this.builder.cleanupCompatibilityMarkers((IResource)file);
        }
        if ((2 & kind) > 0 && !this.context.containsDescriptionChange(type) && !this.context.containsDescriptionDependent(type)) {
            this.builder.cleanupUsageMarkers((IResource)file);
            this.builder.cleanUnusedFilterMarkers((IResource)file);
            this.context.recordDescriptionDependent(type);
        }
        this.addInnerTypesToDependents(file, kind);
    }

    private void addInnerTypesToDependents(IFile file, int kind) {
        ICompilationUnit unit = (ICompilationUnit)JavaCore.create((IFile)file);
        IType[] types = null;
        try {
            types = unit.getAllTypes();
            String typename = null;
            int i = 0;
            while (i < types.length) {
                typename = types[i].getFullyQualifiedName('$');
                if ((2 & kind) > 0 && !this.context.containsDescriptionChange(typename) && !this.context.containsDescriptionDependent(typename)) {
                    this.context.recordDescriptionDependent(typename);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void addInnerTypes(IFile file, int kind) {
        ICompilationUnit unit = (ICompilationUnit)JavaCore.create((IFile)file);
        IType[] types = null;
        try {
            types = unit.getAllTypes();
            String typename = null;
            int i = 0;
            while (i < types.length) {
                typename = types[i].getFullyQualifiedName('$');
                if ((1 & kind) > 0 && !this.context.containsStructuralChange(typename)) {
                    this.context.recordStructuralChange(typename);
                }
                if ((2 & kind) > 0 && !this.context.containsDescriptionChange(typename)) {
                    this.context.recordDescriptionChanged(typename);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    void buildContext(IProject project, State state, List<Change> changes, HashSet<IProject> depprojects) {
        String[] types;
        StringSet structural = null;
        StringSet description = null;
        for (Change change : changes) {
            IResource member;
            boolean contained = change.isContained(project, depprojects);
            if ((change.changeKind & 1) > 0) {
                if (change.deltaKind != 2) {
                    if (structural == null) {
                        structural = new StringSet(16);
                    }
                    structural.add(change.typeName);
                }
                if (contained) {
                    this.context.recordStructuralChange(change.typeName);
                    if (change.deltaKind == 2) {
                        this.context.recordRemovedType(change.typeName);
                    }
                }
            }
            if ((change.changeKind & 2) > 0) {
                if (description == null) {
                    description = new StringSet(16);
                }
                description.add(change.typeName);
                if (contained) {
                    this.context.recordDescriptionChanged(change.typeName);
                }
            }
            if (!contained) continue;
            if (change.fileKind == 2) {
                this.builder.cleanupMarkers((IResource)change.resource);
                this.addInnerTypes(change.resource, change.changeKind);
                continue;
            }
            String path = (String)state.typeLocators.get((Object)change.typeName);
            if (path == null || (member = this.builder.getProject().findMember(path)) == null || member.getType() != 1) continue;
            IFile source = (IFile)member;
            this.builder.cleanupMarkers((IResource)source);
            this.addInnerTypes(source, change.changeKind);
        }
        if (changes.size() == 1 && structural != null && description != null) {
            types = structural.values;
            if (types.length > 0) {
                this.addDependents(project, state, types, 3);
            }
        } else {
            if (structural != null && (types = structural.values).length > 0) {
                this.addDependents(project, state, types, 1);
            }
            if (description != null && (types = description.values).length > 0) {
                this.addDependents(project, state, types, 2);
            }
        }
    }

    private void addDependents(IProject project, State state, String[] types, int kind) {
        char[][] internedSimpleNames;
        StringSet packages = new StringSet(16);
        StringSet typenames = new StringSet(16);
        int i = 0;
        while (i < types.length) {
            if (types[i] != null) {
                this.splitName(types[i], packages, typenames);
            }
            ++i;
        }
        char[][][] internedQualifiedNames = ReferenceCollection.internQualifiedNames((StringSet)packages);
        if (internedQualifiedNames.length < packages.elementSize) {
            internedQualifiedNames = null;
        }
        if ((internedSimpleNames = ReferenceCollection.internSimpleNames((StringSet)typenames, (boolean)true)).length < typenames.elementSize) {
            internedSimpleNames = null;
        }
        Object[] keyTable = state.getReferences().keyTable;
        Object[] valueTable = state.getReferences().valueTable;
        IFile file = null;
        String typeLocator = null;
        int i2 = 0;
        while (i2 < valueTable.length) {
            ReferenceCollection refs;
            typeLocator = (String)keyTable[i2];
            if (typeLocator != null && (refs = (ReferenceCollection)valueTable[i2]).includes(internedQualifiedNames, internedSimpleNames, null) && (file = project.getFile(typeLocator)) != null) {
                if (ApiPlugin.DEBUG_BUILDER) {
                    System.out.println("ApiAnalysisBuilder:   adding affected source file " + file.getName());
                }
                this.addDependentTypeToContext(file, kind);
            }
            ++i2;
        }
    }

    void splitName(String typename, StringSet packages, StringSet simpleTypes) {
        int idx = typename.lastIndexOf(47);
        String packageName = idx < 0 ? "" : typename.substring(0, idx);
        String typeName = idx < 0 ? typename : typename.substring(idx + 1, typename.length());
        if ((idx = typeName.indexOf(36)) > 0) {
            typeName = typeName.substring(0, idx);
        }
        if (simpleTypes.add(typeName) && packages.add(packageName) && ApiPlugin.DEBUG_BUILDER) {
            System.out.println("ApiAnalysisBuilder:   will look for dependents of " + typeName + " in " + packageName);
        }
    }

    void extClean(IProject project, BuildState state, IProgressMonitor monitor) {
        String[] types = this.context.getRemovedTypes();
        int i = 0;
        while (i < types.length) {
            state.cleanup(types[i]);
            ++i;
        }
        Util.updateMonitor(monitor, 0);
        IResource resource = project.findMember(ApiAnalysisBuilder.MANIFEST_PATH);
        if (resource != null) {
            try {
                IMarker[] markers = resource.findMarkers("org.eclipse.pde.api.tools.compatibility", false, 0);
                String tname = null;
                int i2 = 0;
                while (i2 < markers.length) {
                    tname = Util.getTypeNameFromMarker(markers[i2]);
                    if (this.context.containsStructuralChange(tname)) {
                        markers[i2].delete();
                    }
                    ++i2;
                }
                Util.updateMonitor(monitor, 0);
                markers = resource.findMarkers("org.eclipse.pde.api.tools.unused_filters", false, 0);
                i2 = 0;
                while (i2 < markers.length) {
                    tname = Util.getTypeNameFromMarker(markers[i2]);
                    if (this.context.containsStructuralChange(tname)) {
                        markers[i2].delete();
                    }
                    ++i2;
                }
                Util.updateMonitor(monitor, 0);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    String resolveTypeName(IResource resource, int kind) {
        IPath typepath = resource.getFullPath();
        int type = kind;
        if (kind == 0) {
            if (Util.isClassFile(resource.getName())) {
                type = 1;
            } else if (Util.isJavaFileName(resource.getName())) {
                type = 2;
            }
        }
        HashSet<IPath> paths = null;
        switch (type) {
            case 2: {
                paths = this.builder.src_locs.get(resource.getProject());
                break;
            }
            case 1: {
                paths = this.builder.output_locs.get(resource.getProject());
                break;
            }
        }
        if (paths != null) {
            for (IPath path : paths) {
                if (!path.isPrefixOf(typepath)) continue;
                typepath = typepath.removeFirstSegments(path.segmentCount()).removeFileExtension();
                return typepath.toString();
            }
        }
        return null;
    }

    class Change {
        int changeKind;
        int fileKind;
        int deltaKind;
        IProject project;
        IFile resource;
        String typeName;

        Change(int kind, int deltaKind, IFile resource, String typeName, int fileKind) {
            this.changeKind = kind;
            this.deltaKind = deltaKind;
            this.resource = resource;
            this.project = resource.getProject();
            this.typeName = typeName;
            this.fileKind = fileKind;
        }

        boolean isContained(IProject lproject, HashSet<IProject> others) {
            return this.project.equals((Object)lproject) || others != null && others.contains(this.project);
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        List<Change> changes = new ArrayList<Change>();
        boolean buildpathChanged = false;

        ResourceDeltaVisitor(boolean pathChanged) {
            this.buildpathChanged = pathChanged;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getResource().getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 1: {
                    String type;
                    IFile resource = (IFile)delta.getResource();
                    String fileName = resource.getName();
                    if (Util.isClassFile(fileName)) {
                        String typename;
                        if (delta.getKind() == 2) {
                            String typename2 = IncrementalApiBuilder.this.resolveTypeName((IResource)resource, 1);
                            if (typename2 == null) break;
                            if (ApiPlugin.DEBUG_BUILDER) {
                                System.out.println("ApiAnalysisBuilder: Found removed class file " + typename2);
                            }
                            this.changes.add(new Change(1, delta.getKind(), resource, typename2, 1));
                            break;
                        }
                        if (!this.buildpathChanged || delta.getKind() != 4 || (delta.getFlags() & 0x100) <= 0 || (typename = IncrementalApiBuilder.this.resolveTypeName((IResource)resource, 1)) == null) break;
                        this.changes.add(new Change(1, delta.getKind(), resource, typename, 1));
                        break;
                    }
                    if (!Util.isJavaFileName(fileName) || (type = IncrementalApiBuilder.this.resolveTypeName((IResource)resource, 2)) == null) break;
                    Change change = new Change(1, delta.getKind(), resource, type, 2);
                    this.changes.add(change);
                    IApiComponent component = IncrementalApiBuilder.this.workspaceBaseline.getApiComponent(resource.getProject());
                    if (component == null) break;
                    try {
                        TypeAnnotations ta;
                        IApiAnnotations annotations = component.getApiDescription().resolveAnnotations(Factory.typeDescriptor(type.replace('/', '.')));
                        if (!(annotations instanceof TypeAnnotations) || (ta = (TypeAnnotations)annotations).getBuildStamp() != BuildStamps.getBuildStamp(resource.getProject())) break;
                        change.changeKind |= 2;
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e);
                    }
                    break;
                }
            }
            return false;
        }
    }
}

