/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContentsContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUISelection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUISelectionContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.MailServicesProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class NewReviewItemHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Adding New Review Items...";

    public Object execute(final ExecutionEvent event) {
        final IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        final IEditorInput input = editorPart != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput() : null;
        Job job = new Job(COMMAND_MESSAGE){

            public IStatus run(IProgressMonitor monitor) {
                R4EUIModelController.setJobInProgress(true);
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                if (selection instanceof ITextSelection) {
                    monitor.beginTask(NewReviewItemHandler.COMMAND_MESSAGE, -1);
                    NewReviewItemHandler.this.addReviewItemFromText((ITextSelection)selection, input);
                } else if (selection instanceof IStructuredSelection) {
                    if (editorPart != null && editorPart instanceof ITextEditor) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                ((ITextEditor)editorPart).getSelectionProvider().setSelection(null);
                            }
                        });
                    }
                    monitor.beginTask(NewReviewItemHandler.COMMAND_MESSAGE, ((IStructuredSelection)selection).size());
                    Iterator iterator = ((IStructuredSelection)selection).iterator();
                    while (iterator.hasNext()) {
                        NewReviewItemHandler.this.addReviewItemFromTree(iterator.next(), monitor);
                        if (!monitor.isCanceled()) continue;
                        R4EUIModelController.setJobInProgress(false);
                        return Status.CANCEL_STATUS;
                    }
                }
                R4EUIModelController.setJobInProgress(false);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private void addReviewItemFromText(ITextSelection aSelection, IEditorInput aInput) {
        try {
            R4EUITextPosition position = CommandUtils.getPosition(aSelection);
            R4EFileVersion baseVersion = CommandUtils.getBaseFileData(aInput);
            R4EFileVersion targetVersion = CommandUtils.getTargetFileData(aInput);
            if (targetVersion != null) {
                this.addReviewItem(baseVersion, targetVersion, position);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Trying to add review item to base file");
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Add Review Item Error", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "No Target File present to Add Review Item", null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            }
        }
        catch (CoreException e) {
            UIUtils.displayCoreErrorDialog(e);
        }
        catch (ReviewsFileStorageException e) {
            UIUtils.displayReviewsFileStorageErrorDialog(e);
        }
    }

    private void addReviewItemFromTree(Object aSelection, IProgressMonitor aMonitor) {
        try {
            R4EUITextPosition position = null;
            IFile workspaceFile = null;
            if (aSelection instanceof IFile) {
                position = CommandUtils.getPosition((IFile)aSelection);
                workspaceFile = (IFile)aSelection;
            } else if (R4EUIPlugin.isJDTAvailable() && aSelection instanceof org.eclipse.jdt.core.ISourceReference) {
                workspaceFile = (IFile)((IJavaElement)aSelection).getResource();
                position = CommandUtils.getPosition((org.eclipse.jdt.core.ISourceReference)aSelection, workspaceFile);
            } else if (R4EUIPlugin.isCDTAvailable() && aSelection instanceof ISourceReference) {
                ICElement cdtElement = (ICElement)aSelection;
                while (cdtElement != null) {
                    if (cdtElement.getResource() instanceof IFile) {
                        workspaceFile = (IFile)cdtElement.getResource();
                        break;
                    }
                    cdtElement = cdtElement.getParent();
                }
                if (workspaceFile == null) {
                    return;
                }
                position = CommandUtils.getPosition((ISourceReference)aSelection, workspaceFile);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Invalid selection " + aSelection.getClass().toString() + ".  Ignoring");
                return;
            }
            R4EFileVersion baseVersion = CommandUtils.updateBaseFile(workspaceFile);
            R4EFileVersion targetVersion = CommandUtils.updateTargetFile(workspaceFile);
            if (targetVersion != null) {
                aMonitor.subTask("Adding " + targetVersion.getName());
                this.addReviewItem(baseVersion, targetVersion, position);
                aMonitor.worked(1);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Trying to add review item to base file");
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Add Review Item Error", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "No Target File present to Add Review Item", null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            }
        }
        catch (CoreException e) {
            UIUtils.displayCoreErrorDialog(e);
        }
        catch (ReviewsFileStorageException e) {
            UIUtils.displayReviewsFileStorageErrorDialog(e);
        }
    }

    private void addReviewItem(R4EFileVersion aBaseFileVersion, R4EFileVersion aTargetFileVersion, IR4EUIPosition aUIPosition) {
        try {
            List<R4EUIReviewItem> reviewItems = R4EUIModelController.getActiveReview().getReviewItems();
            boolean newSelection = true;
            for (R4EUIReviewItem reviewItem : reviewItems) {
                R4EUIFileContext[] files;
                R4EUIFileContext[] r4EUIFileContextArray = files = (R4EUIFileContext[])reviewItem.getChildren();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    R4EUIContentsContainer contentContainer;
                    R4EUIFileContext file = r4EUIFileContextArray[n2];
                    if (file.getFileContext().getTarget() != null && aTargetFileVersion.getLocalVersionID().equals(file.getFileContext().getTarget().getLocalVersionID()) && (file.getFileContext().getBase() == null && (aBaseFileVersion == null || "".equals(aBaseFileVersion.getVersionID())) || file.getFileContext().getBase() != null && aBaseFileVersion != null && aBaseFileVersion.getLocalVersionID().equals(file.getFileContext().getBase().getLocalVersionID())) && (contentContainer = file.getContentsContainerElement()) instanceof R4EUISelectionContainer) {
                        R4EUIContent[] contentElements;
                        R4EUIContent[] r4EUIContentArray = contentElements = (R4EUIContent[])contentContainer.getChildren();
                        int n3 = contentElements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            R4EUIContent contentElement = r4EUIContentArray[n4];
                            if (contentElement.getPosition().isSameAs(aUIPosition)) {
                                newSelection = false;
                            }
                            ++n4;
                        }
                        if (newSelection) {
                            this.addReviewItemToExistingFileContext((R4EUISelectionContainer)contentContainer, aUIPosition);
                            R4EUIPlugin.Ftracer.traceInfo("Added review item: Target = " + file.getFileContext().getTarget().getName() + (file.getFileContext().getBase() != null ? "Base = " + file.getFileContext().getBase().getName() : "") + " Position = " + aUIPosition.toString());
                        } else {
                            R4EUIPlugin.Ftracer.traceWarning("Review Item already exists.  Ignoring");
                            final ErrorDialog dialog = new ErrorDialog(null, "R4E Warning", "Cannot add Review Item", (IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Review Item already exists", null), 2);
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    dialog.open();
                                }
                            });
                        }
                        return;
                    }
                    ++n2;
                }
            }
            this.addReviewItemToNewFileContext(aBaseFileVersion, aTargetFileVersion, aUIPosition);
            R4EUIPlugin.Ftracer.traceInfo("Added Review Item: Target = " + aTargetFileVersion.getName() + "_" + aTargetFileVersion.getVersionID() + (aBaseFileVersion != null ? "Base = " + aBaseFileVersion.getName() + "_" + aBaseFileVersion.getVersionID() : "") + " Position = " + aUIPosition.toString());
        }
        catch (ResourceHandlingException e) {
            UIUtils.displayResourceErrorDialog(e);
        }
        catch (OutOfSyncException e) {
            UIUtils.displaySyncErrorDialog(e);
        }
        catch (CoreException e) {
            UIUtils.displayCoreErrorDialog(e);
        }
    }

    private void addReviewItemToExistingFileContext(R4EUISelectionContainer aContainer, IR4EUIPosition aUIPosition) throws ResourceHandlingException, OutOfSyncException {
        R4EUISelection uiSelection = aContainer.createSelection((R4EUITextPosition)aUIPosition);
        R4EUIModelController.setJobInProgress(false);
        UIUtils.setNavigatorViewFocus(uiSelection, -1);
    }

    private void addReviewItemToNewFileContext(R4EFileVersion aBaseFileVersion, R4EFileVersion aTargetFileVersion, IR4EUIPosition aUIPosition) throws ResourceHandlingException, OutOfSyncException, CoreException {
        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
        R4EUIReviewItem uiReviewItem = uiReview.createResourceReviewItem(aTargetFileVersion.getName());
        if (uiReviewItem == null) {
            return;
        }
        R4EUIFileContext uiFileContext = uiReviewItem.createFileContext(aBaseFileVersion, aTargetFileVersion, null);
        if (uiFileContext == null) {
            uiReview.removeChildren(uiReviewItem, false);
            return;
        }
        R4EUISelectionContainer uiSelectionContainer = (R4EUISelectionContainer)uiFileContext.getContentsContainerElement();
        uiSelectionContainer.createSelection((R4EUITextPosition)aUIPosition);
        R4EUIModelController.setJobInProgress(false);
        UIUtils.setNavigatorViewFocus(uiReviewItem, 1);
        ArrayList<R4EReviewComponent> addedItems = new ArrayList<R4EReviewComponent>();
        addedItems.add((R4EReviewComponent)uiReviewItem.getItem());
        R4EReview review = uiReview.getReview();
        if (review.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL) && ((R4EFormalReview)review).getCurrent().getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION)) {
            MailServicesProxy.sendItemsAddedNotification(addedItems);
        }
    }
}

