/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class DecoratingCellLabelProvider
extends CellLabelProvider
implements ILabelProvider,
IViewerLabelProvider,
IColorProvider,
IFontProvider,
ITreePathLabelProvider {
    private final ILabelProvider provider;
    private ILabelDecorator decorator;
    private final ListenerList listeners = new ListenerList();
    private IDecorationContext decorationContext;

    public DecoratingCellLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
        Assert.isNotNull((Object)provider);
        this.provider = provider;
        this.decorator = decorator;
        this.decorationContext = this.createDefaultDecorationContext();
    }

    private IDecorationContext createDefaultDecorationContext() {
        DecorationContext newContext = new DecorationContext();
        newContext.putProperty("DecorationContext.RESOURCE_MANAGER_KEY", (Object)new LocalResourceManager(JFaceResources.getResources()));
        return newContext;
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.provider.addListener(listener);
        if (this.decorator != null) {
            this.decorator.addListener(listener);
        }
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        Object manager;
        if (this.decorationContext != null && (manager = this.decorationContext.getProperty("DecorationContext.RESOURCE_MANAGER_KEY")) != null && manager instanceof ResourceManager) {
            ((ResourceManager)manager).dispose();
        }
        this.provider.dispose();
        if (this.decorator != null) {
            this.decorator.dispose();
        }
    }

    public Image getImage(Object element) {
        Image image = this.provider.getImage(element);
        if (this.decorator != null) {
            if (this.decorator instanceof LabelDecorator) {
                LabelDecorator ld2 = (LabelDecorator)this.decorator;
                Image decorated = ld2.decorateImage(image, element, this.getDecorationContext());
                if (decorated != null) {
                    return decorated;
                }
            } else {
                Image decorated = this.decorator.decorateImage(image, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return image;
    }

    public ILabelDecorator getLabelDecorator() {
        return this.decorator;
    }

    public ILabelProvider getLabelProvider() {
        return this.provider;
    }

    public String getText(Object element) {
        String text = this.provider.getText(element);
        if (this.decorator != null) {
            if (this.decorator instanceof LabelDecorator) {
                LabelDecorator ld2 = (LabelDecorator)this.decorator;
                String decorated = ld2.decorateText(text, element, this.getDecorationContext());
                if (decorated != null) {
                    return decorated;
                }
            } else {
                String decorated = this.decorator.decorateText(text, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.provider.isLabelProperty(element, property)) {
            return true;
        }
        return this.decorator != null && this.decorator.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.provider.removeListener(listener);
        if (this.decorator != null) {
            this.decorator.removeListener(listener);
        }
        this.listeners.remove((Object)listener);
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
        ILabelDecorator oldDecorator = this.decorator;
        if (oldDecorator != decorator) {
            Object element;
            int n;
            int n2;
            Object[] objectArray;
            Object[] listenerList = this.listeners.getListeners();
            if (oldDecorator != null) {
                objectArray = listenerList;
                n2 = listenerList.length;
                n = 0;
                while (n < n2) {
                    element = objectArray[n];
                    oldDecorator.removeListener((ILabelProviderListener)element);
                    ++n;
                }
            }
            this.decorator = decorator;
            if (decorator != null) {
                objectArray = listenerList;
                n2 = listenerList.length;
                n = 0;
                while (n < n2) {
                    element = objectArray[n];
                    decorator.addListener((ILabelProviderListener)element);
                    ++n;
                }
            }
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void updateLabel(ViewerLabel settings, Object element) {
        IDelayedLabelDecorator delayedDecorator;
        ILabelDecorator currentDecorator = this.getLabelDecorator();
        String oldText = settings.getText();
        boolean decorationReady = true;
        if (currentDecorator instanceof IDelayedLabelDecorator && !(delayedDecorator = (IDelayedLabelDecorator)currentDecorator).prepareDecoration(element, oldText)) {
            decorationReady = false;
        }
        if (decorationReady || oldText == null || settings.getText().length() == 0) {
            settings.setText(this.getText(element));
        }
        Image oldImage = settings.getImage();
        if (decorationReady || oldImage == null) {
            settings.setImage(this.getImage(element));
        }
        if (decorationReady) {
            this.updateForDecorationReady(settings, element);
        }
    }

    protected void updateForDecorationReady(ViewerLabel settings, Object element) {
        Font font;
        if (this.decorator instanceof IColorDecorator) {
            IColorDecorator colorDecorator = (IColorDecorator)this.decorator;
            Color color = colorDecorator.decorateBackground(element);
            if (color != null) {
                settings.setBackground(color);
            }
            if ((color = colorDecorator.decorateForeground(element)) != null) {
                settings.setForeground(color);
            }
        }
        if (this.decorator instanceof IFontDecorator && (font = ((IFontDecorator)this.decorator).decorateFont(element)) != null) {
            settings.setFont(font);
        }
    }

    public Color getBackground(Object element) {
        if (this.provider instanceof IColorProvider) {
            return ((IColorProvider)this.provider).getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element) {
        if (this.provider instanceof IFontProvider) {
            return ((IFontProvider)this.provider).getFont(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this.provider instanceof IColorProvider) {
            return ((IColorProvider)this.provider).getForeground(element);
        }
        return null;
    }

    public Color getToolTipBackgroundColor(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipBackgroundColor(object);
        }
        return super.getToolTipBackgroundColor(object);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipDisplayDelayTime(object);
        }
        return super.getToolTipDisplayDelayTime(object);
    }

    public Font getToolTipFont(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipFont(object);
        }
        return super.getToolTipFont(object);
    }

    public Color getToolTipForegroundColor(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipForegroundColor(object);
        }
        return super.getToolTipForegroundColor(object);
    }

    public Image getToolTipImage(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipImage(object);
        }
        return super.getToolTipImage(object);
    }

    public Point getToolTipShift(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipShift(object);
        }
        return super.getToolTipShift(object);
    }

    public int getToolTipStyle(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipStyle(object);
        }
        return super.getToolTipStyle(object);
    }

    public String getToolTipText(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipText(object);
        }
        return super.getToolTipText(object);
    }

    public int getToolTipTimeDisplayed(Object object) {
        if (this.provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.provider).getToolTipTimeDisplayed(object);
        }
        return super.getToolTipTimeDisplayed(object);
    }

    public IDecorationContext getDecorationContext() {
        return this.decorationContext;
    }

    public void setDecorationContext(IDecorationContext decorationContext) {
        Assert.isNotNull((Object)decorationContext);
        this.decorationContext = decorationContext;
    }

    public void updateLabel(ViewerLabel settings, TreePath elementPath) {
        IDelayedLabelDecorator delayedDecorator;
        ILabelDecorator currentDecorator = this.getLabelDecorator();
        String oldText = settings.getText();
        Object element = elementPath.getLastSegment();
        boolean decorationReady = true;
        if (currentDecorator instanceof LabelDecorator) {
            LabelDecorator labelDecorator = (LabelDecorator)currentDecorator;
            if (!labelDecorator.prepareDecoration(element, oldText, this.getDecorationContext())) {
                decorationReady = false;
            }
        } else if (currentDecorator instanceof IDelayedLabelDecorator && !(delayedDecorator = (IDelayedLabelDecorator)currentDecorator).prepareDecoration(element, oldText)) {
            decorationReady = false;
        }
        settings.setHasPendingDecorations(!decorationReady);
        if (this.provider instanceof ITreePathLabelProvider) {
            ITreePathLabelProvider pprov = (ITreePathLabelProvider)this.provider;
            if (decorationReady || oldText == null || settings.getText().length() == 0) {
                pprov.updateLabel(settings, elementPath);
                this.decorateSettings(settings, elementPath);
            }
        } else {
            if (decorationReady || oldText == null || settings.getText().length() == 0) {
                settings.setText(this.getText(element));
            }
            Image oldImage = settings.getImage();
            if (decorationReady || oldImage == null) {
                settings.setImage(this.getImage(element));
            }
            if (decorationReady) {
                this.updateForDecorationReady(settings, element);
            }
        }
    }

    private void decorateSettings(ViewerLabel settings, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (this.decorator != null) {
            Font font;
            if (this.decorator instanceof LabelDecorator) {
                Image image;
                LabelDecorator labelDecorator = (LabelDecorator)this.decorator;
                String text = labelDecorator.decorateText(settings.getText(), element, this.getDecorationContext());
                if (text != null && text.length() > 0) {
                    settings.setText(text);
                }
                if ((image = labelDecorator.decorateImage(settings.getImage(), element, this.getDecorationContext())) != null) {
                    settings.setImage(image);
                }
            } else {
                Image image;
                String text = this.decorator.decorateText(settings.getText(), element);
                if (text != null && text.length() > 0) {
                    settings.setText(text);
                }
                if ((image = this.decorator.decorateImage(settings.getImage(), element)) != null) {
                    settings.setImage(image);
                }
            }
            if (this.decorator instanceof IColorDecorator) {
                Color foreground;
                IColorDecorator colorDecorator = (IColorDecorator)this.decorator;
                Color background = colorDecorator.decorateBackground(element);
                if (background != null) {
                    settings.setBackground(background);
                }
                if ((foreground = colorDecorator.decorateForeground(element)) != null) {
                    settings.setForeground(foreground);
                }
            }
            if (this.decorator instanceof IFontDecorator && (font = ((IFontDecorator)this.decorator).decorateFont(element)) != null) {
                settings.setFont(font);
            }
        }
    }

    public void update(ViewerCell cell) {
        ViewerLabel label = new ViewerLabel(cell.getText(), cell.getImage());
        label.setBackground(this.getBackground(cell.getElement()));
        label.setForeground(this.getForeground(cell.getElement()));
        label.setFont(this.getFont(cell.getElement()));
        this.updateLabel(label, cell.getElement());
        cell.setBackground(label.getBackground());
        cell.setForeground(label.getForeground());
        cell.setFont(label.getFont());
        if (label.hasNewText()) {
            cell.setText(label.getText());
        }
        if (label.hasNewImage()) {
            cell.setImage(label.getImage());
        }
    }
}

