/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.upgrade.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.reviews.r4e.core.utils.VersionUtils;
import org.eclipse.mylyn.reviews.r4e.upgrade.IR4EVersionUpgrader;
import org.eclipse.mylyn.reviews.r4e.upgrade.R4EUpgradePlugin;
import org.eclipse.mylyn.reviews.r4e.upgrade.UpgradePath;
import org.eclipse.mylyn.reviews.r4e.upgrade.impl.R4EUpgradeContainer;
import org.eclipse.mylyn.reviews.r4e.upgrade.impl.R4EUpgradeException;
import org.eclipse.swt.widgets.Display;

public class R4EUpgradeController {
    public static final String FRAGMENT_VERSION_DEFAULT = "0.8.0";
    public static final int VERSION_APPLICATION_OLDER = 1;
    public static final int VERSION_APPLICATION_NEWER = -1;
    public static final int DO_UPGRADE = 0;
    public static final int NO_UPGRADE = 1;
    public static final int UPGRADE_SUCCESS = 0;
    public static final int UPGRADE_NONE = 1;
    public static final int UPGRADE_FAILURE = 2;
    private static final String COMPATIBILITY_ERROR_MESSAGE = "You cannot use an older application version of R4E to open newer elements versions.  Please upgrade your application";
    private static final String NO_UPGRADER_ERROR_MESSAGE = "You are trying to open an older version of the element than the one currently handled by this version of R4E, and no upgrader is available for this upgrade path.";
    private static final String COMPATIBILITY_ERROR_DIALOG_TITLE = "Compatibility problem Detected for ";
    private static final String NO_UPGRADER_ERROR_DIALOG_TITLE = "No upgrader available for ";
    private static final String COMPATIBILITY_WARNING_DIALOG_TITLE = "Version Mismatch Detected for ";
    private static final String COMPATIBILITY_COMPATIBLE_WARNING_MESSAGE = "You are trying to load an older version of the element than the one currently handled by this version of R4E." + System.getProperty("line.separator") + System.getProperty("line.separator") + "You can open the element normally, which will convert its version to the current application meta-data, or in Read-only mode, which will preserve its version.";
    private static final String COMPATIBILITY_INCOMPATIBLE_WARNING_MESSAGE = "You are trying to load an older version of the element than the one currently handled by this version of R4E." + System.getProperty("line.separator") + System.getProperty("line.separator") + "You can open the element, which will convert its version to the current application meta-data, or cancel the action";
    private static final String[] COMPATIBLE_UPGRADE_DIALOG_BUTTONS = new String[]{"Load (Convert Version)", "Load in Read-Only Mode (Preserve Version)", "Cancel"};
    public static final String DIALOG_TITLE_ERROR = "R4E Compatibility Error";
    private static final String[] INCOMPATIBLE_UPGRADE_DIALOG_BUTTONS = new String[]{"Load (Convert Version)", "Cancel"};
    private static int fUpgradeTestDialogResult = -1;

    public static boolean upgradeCompatibilityCheck(URI aUpgradeRootURI, String aOldVersion, String aNewVersion) throws IOException {
        int checkResult = VersionUtils.compareVersions((String)aOldVersion, (String)aNewVersion);
        switch (checkResult) {
            case 1: {
                return false;
            }
            case -1: {
                IR4EVersionUpgrader upgrader = R4EUpgradeContainer.getUpgrader(new UpgradePath(aOldVersion, aNewVersion));
                if (upgrader != null) {
                    return upgrader.isCompatible();
                }
                return false;
            }
        }
        return true;
    }

    public static int upgradeCheck(URI aUpgradeRootURI, String aElementMsg, String aOldVersion, String aNewVersion, boolean aRecursive) throws IOException {
        int checkResult = VersionUtils.compareVersions((String)aOldVersion, (String)aNewVersion);
        switch (checkResult) {
            case 1: {
                R4EUpgradeController.displayOlderCompatibilityErrorDialog(aElementMsg, aOldVersion, aNewVersion);
                return 2;
            }
            case -1: {
                IR4EVersionUpgrader upgrader = R4EUpgradeContainer.getUpgrader(new UpgradePath(aOldVersion, aNewVersion));
                if (upgrader != null) {
                    if (upgrader.isCompatible()) {
                        int result = R4EUpgradeController.displayCompatibleUpgradeDialog(aElementMsg, upgrader);
                        switch (result) {
                            case 0: {
                                try {
                                    upgrader.upgrade(aUpgradeRootURI, aRecursive);
                                }
                                catch (R4EUpgradeException e) {
                                    String failureMsg = "Upgrade failure from compatible version " + upgrader.getUpgradePath().getBaseVersion() + " to " + upgrader.getUpgradePath().getTargetVersion();
                                    R4EUpgradePlugin.Ftracer.traceError(failureMsg);
                                    R4EUpgradePlugin.getDefault().logError(failureMsg, e);
                                    return 2;
                                }
                                return 0;
                            }
                            case 1: {
                                return 1;
                            }
                        }
                        return 2;
                    }
                    int result = R4EUpgradeController.displayIncompatibleUpgradeDialog(aElementMsg, upgrader);
                    switch (result) {
                        case 0: {
                            try {
                                upgrader.upgrade(aUpgradeRootURI, aRecursive);
                            }
                            catch (R4EUpgradeException e) {
                                String failureMsg = "Upgrade failure from non-compatible version " + upgrader.getUpgradePath().getBaseVersion() + " to " + upgrader.getUpgradePath().getTargetVersion();
                                R4EUpgradePlugin.Ftracer.traceError(failureMsg);
                                R4EUpgradePlugin.getDefault().logError(failureMsg, e);
                                return 2;
                            }
                            return 0;
                        }
                    }
                    return 2;
                }
                R4EUpgradeController.displayNoUpgraderCompatibilityErrorDialog(aElementMsg, aOldVersion, aNewVersion);
                return 2;
            }
        }
        return 0;
    }

    public static void displayOlderCompatibilityErrorDialog(String aElementMsg, String aDataVersion, String aApplVersion) {
        String upgraderMessage = COMPATIBILITY_ERROR_MESSAGE + System.getProperty("line.separator") + "Element meta-data Version: " + aDataVersion + System.getProperty("line.separator") + "Application meta-data Version: " + aApplVersion;
        R4EUpgradePlugin.Ftracer.traceError(upgraderMessage);
        final ErrorDialog dialog = new ErrorDialog(null, DIALOG_TITLE_ERROR, COMPATIBILITY_ERROR_DIALOG_TITLE + aElementMsg, (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.upgrade", 0, upgraderMessage, null), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static void displayNoUpgraderCompatibilityErrorDialog(String aElementMsg, String aDataVersion, String aApplVersion) {
        String upgraderMessage = NO_UPGRADER_ERROR_MESSAGE + System.getProperty("line.separator") + "Element meta-data Version: " + aDataVersion + System.getProperty("line.separator") + "Application meta-data Version: " + aApplVersion;
        R4EUpgradePlugin.Ftracer.traceError(upgraderMessage);
        final ErrorDialog dialog = new ErrorDialog(null, DIALOG_TITLE_ERROR, NO_UPGRADER_ERROR_DIALOG_TITLE + aElementMsg, (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.upgrade", 0, upgraderMessage, null), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static int displayCompatibleUpgradeDialog(final String aElementMsg, IR4EVersionUpgrader aUpgrader) {
        final int[] result = new int[1];
        if (-1 == fUpgradeTestDialogResult) {
            final String upgraderMessage = String.valueOf(COMPATIBILITY_COMPATIBLE_WARNING_MESSAGE) + System.getProperty("line.separator") + System.getProperty("line.separator") + "Element meta-data Version: " + aUpgrader.getUpgradePath().getBaseVersion() + System.getProperty("line.separator") + System.getProperty("line.separator") + "Application meta-data Version: " + aUpgrader.getUpgradePath().getTargetVersion();
            R4EUpgradePlugin.Ftracer.traceWarning(upgraderMessage);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dialog = new MessageDialog(null, R4EUpgradeController.COMPATIBILITY_WARNING_DIALOG_TITLE + aElementMsg, null, upgraderMessage, 6, COMPATIBLE_UPGRADE_DIALOG_BUTTONS, 0);
                    result[0] = dialog.open();
                }
            });
        } else {
            result[0] = fUpgradeTestDialogResult;
        }
        return result[0];
    }

    public static int displayIncompatibleUpgradeDialog(final String aElementMsg, IR4EVersionUpgrader aUpgrader) {
        final int[] result = new int[1];
        if (-1 == fUpgradeTestDialogResult) {
            final String upgraderMessage = String.valueOf(COMPATIBILITY_INCOMPATIBLE_WARNING_MESSAGE) + System.getProperty("line.separator") + System.getProperty("line.separator") + "Element meta-data Version: " + aUpgrader.getUpgradePath().getBaseVersion() + System.getProperty("line.separator") + System.getProperty("line.separator") + "Application meta-data Version: " + aUpgrader.getUpgradePath().getTargetVersion();
            R4EUpgradePlugin.Ftracer.traceWarning(upgraderMessage);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dialog = new MessageDialog(null, R4EUpgradeController.COMPATIBILITY_WARNING_DIALOG_TITLE + aElementMsg, null, upgraderMessage, 6, INCOMPATIBLE_UPGRADE_DIALOG_BUTTONS, 0);
                    result[0] = dialog.open();
                }
            });
        } else {
            result[0] = fUpgradeTestDialogResult;
        }
        return result[0];
    }

    public static String getVersionFromResourceFile(URI aResourceUri) throws IOException {
        Pattern versionPattern = Pattern.compile("fragmentVersion=\\S*\"");
        Matcher matcher = null;
        String version = null;
        File file = new File(aResourceUri.toFileString());
        if (file.exists()) {
            BufferedReader br = new BufferedReader(new FileReader(file));
            while (br.ready()) {
                String line = br.readLine();
                matcher = versionPattern.matcher(line);
                if (!matcher.find()) continue;
                version = matcher.group().split("=")[1].replace("\"", "");
                break;
            }
            br.close();
        }
        if (version == null) {
            version = FRAGMENT_VERSION_DEFAULT;
        }
        return version;
    }

    public static void setUpgradeDialogResult(int aResult) {
        fUpgradeTestDialogResult = aResult;
    }
}

