/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.sorters;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class FindUsersTableViewerSorter
extends ViewerSorter {
    private int fColumnIndex = 0;

    public FindUsersTableViewerSorter(int aColumnIndex) {
        this.fColumnIndex = aColumnIndex;
    }

    public int compare(Viewer aViewer, Object aObj1, Object aObj2) {
        if (aViewer instanceof TableViewer) {
            TableViewer tv = (TableViewer)aViewer;
            tv.getTable().setSortColumn(tv.getTable().getColumn(this.fColumnIndex));
            int idx1 = -1;
            int idx2 = -1;
            int numItems = tv.getTable().getItemCount();
            Object obj = null;
            int i = 0;
            while (i < numItems) {
                obj = tv.getElementAt(i);
                if (obj.equals(aObj1)) {
                    idx1 = i;
                } else if (obj.equals(aObj2)) {
                    idx2 = i;
                }
                if (idx1 > 0 && idx2 > 0) break;
                ++i;
            }
            int order = 0;
            if (idx1 > -1 && idx2 > -1) {
                String str1 = tv.getTable().getItems()[idx1].getText(this.fColumnIndex);
                String str2 = tv.getTable().getItems()[idx2].getText(this.fColumnIndex);
                order = str1.compareTo(str2);
                if (tv.getTable().getSortDirection() != 128) {
                    order *= -1;
                }
            }
            return order;
        }
        if (aViewer instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)aViewer;
            tv.getTree().setSortColumn(tv.getTree().getColumn(this.fColumnIndex));
            int idx1 = -1;
            int idx2 = -1;
            TreeItem[] listObj = tv.getTree().getItems();
            Object obj = null;
            int i = 0;
            while (i < listObj.length) {
                if (listObj[i] instanceof TreeItem) {
                    obj = listObj[i].getData();
                    listObj[i].setExpanded(true);
                }
                if (obj != null) {
                    if (obj.equals(aObj1)) {
                        idx1 = i;
                    } else if (obj.equals(aObj2)) {
                        idx2 = i;
                    }
                    if (idx1 > 0 && idx2 > 0) break;
                }
                ++i;
            }
            int order = 0;
            if (idx1 > -1 && idx2 > -1) {
                String str1 = tv.getTree().getItems()[idx1].getText(this.fColumnIndex);
                String str2 = tv.getTree().getItems()[idx2].getText(this.fColumnIndex);
                order = str1.compareTo(str2);
                if (tv.getTree().getSortDirection() != 128) {
                    order *= -1;
                }
            }
            return order;
        }
        return 0;
    }

    public static void bind(final TableViewer aTableViewer) {
        int numColumns = aTableViewer.getTable().getColumnCount();
        int i = 0;
        while (i < numColumns) {
            final int columnNum = i;
            TableColumn column = aTableViewer.getTable().getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FindUsersTableViewerSorter sorter = new FindUsersTableViewerSorter(columnNum);
                    Table table = aTableViewer.getTable();
                    if (table.getSortDirection() == 128) {
                        table.setSortDirection(1024);
                    } else if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(128);
                    }
                    aTableViewer.setComparator((ViewerComparator)sorter);
                }
            });
            ++i;
        }
    }

    public static void bind(final TreeViewer aTreeViewer) {
        int numColumns = aTreeViewer.getTree().getColumnCount();
        int i = 0;
        while (i < numColumns) {
            final int columnNum = i;
            TreeColumn column = aTreeViewer.getTree().getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FindUsersTableViewerSorter sorter = new FindUsersTableViewerSorter(columnNum);
                    Tree table = aTreeViewer.getTree();
                    if (table.getSortDirection() == 128) {
                        table.setSortDirection(1024);
                    } else if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(128);
                    }
                    aTreeViewer.setComparator((ViewerComparator)sorter);
                }
            });
            ++i;
        }
    }

    public static void bind(final TreeViewer aTreeViewer, final int aColumnNum) {
        int maxColumn = aTreeViewer.getTree().getColumnCount();
        if (aColumnNum < maxColumn) {
            TreeColumn column = aTreeViewer.getTree().getColumn(aColumnNum);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FindUsersTableViewerSorter sorter = new FindUsersTableViewerSorter(aColumnNum);
                    Tree table = aTreeViewer.getTree();
                    if (table.getSortDirection() == 128) {
                        table.setSortDirection(1024);
                    } else if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(128);
                    }
                    aTreeViewer.setComparator((ViewerComparator)sorter);
                }
            });
        }
    }
}

