/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general;

import org.eclipse.core.resources.IResource;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FileVersionSourceProperties
implements IPropertySource {
    private static final String FILE_VERSION_NAME_ID = "fileVersionElement.name";
    private static final PropertyDescriptor FILE_VERSION_NAME_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"fileVersionElement.name", "Name: ");
    private static final String FILE_VERSION_PATH_REPOSITORY_ID = "fileVersionElement.repositoryPath";
    private static final PropertyDescriptor FILE_VERSION_PATH_REPOSITORY_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"fileVersionElement.repositoryPath", "Repository Path: ");
    private static final String FILE_VERSION_PATH_ABSOLUTE_ID = "fileVersionElement.absolutePath";
    private static final PropertyDescriptor FILE_VERSION_PATH_ABSOLUTE_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"fileVersionElement.absolutePath", "Absolute Path: ");
    private static final String FILE_VERSION_PATH_PROJECT_ID = "fileVersionElement.projectPath";
    private static final PropertyDescriptor FILE_VERSION_PATH_PROJECT_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"fileVersionElement.projectPath", "Project Relative Path: ");
    private static final String FILE_VERSION_ID = "fileVersionElement.version";
    private static final PropertyDescriptor FILE_VERSION_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"fileVersionElement.version", "Version: ");
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{FILE_VERSION_NAME_PROPERTY_DESCRIPTOR, FILE_VERSION_PROPERTY_DESCRIPTOR, FILE_VERSION_PATH_REPOSITORY_PROPERTY_DESCRIPTOR, FILE_VERSION_PATH_ABSOLUTE_PROPERTY_DESCRIPTOR, FILE_VERSION_PATH_PROJECT_PROPERTY_DESCRIPTOR};
    private final R4EFileVersion fFileVersion;

    public FileVersionSourceProperties(R4EFileVersion aVersion) {
        this.fFileVersion = aVersion;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Object getPropertyValue(Object aId) {
        if (FILE_VERSION_NAME_ID.equals(aId)) {
            if (this.fFileVersion != null) {
                return this.fFileVersion.getName();
            }
        } else if (FILE_VERSION_PATH_REPOSITORY_ID.equals(aId)) {
            if (this.fFileVersion != null) {
                return this.fFileVersion.getRepositoryPath();
            }
        } else if (FILE_VERSION_PATH_ABSOLUTE_ID.equals(aId)) {
            IResource resource;
            if (this.fFileVersion != null && (resource = this.fFileVersion.getResource()) != null) {
                return resource.getLocation().toPortableString();
            }
        } else if (FILE_VERSION_PATH_PROJECT_ID.equals(aId)) {
            IResource resource;
            if (this.fFileVersion != null && (resource = this.fFileVersion.getResource()) != null) {
                return resource.getProjectRelativePath().toPortableString();
            }
        } else if (FILE_VERSION_ID.equals(aId) && this.fFileVersion != null) {
            return this.fFileVersion.getVersionID();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

