/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.navigator;

import org.eclipse.jface.window.Window;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class R4EUILegendControl
extends Composite {
    private final FormToolkit toolkit;
    private Window window = null;

    public R4EUILegendControl(Composite parent, FormToolkit toolkit) {
        this(parent, toolkit, true, 512);
    }

    public R4EUILegendControl(Composite parent, FormToolkit toolkit, boolean showConnectors, int style) {
        super(parent, 0);
        this.toolkit = toolkit;
        toolkit.adapt((Composite)this);
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        if (style == -1) {
            this.createContentsVertical(layout, showConnectors);
        } else if ((style & 0x100) != 0) {
            this.createContentsHorizontal(layout, showConnectors);
        } else {
            this.createContentsVertical(layout, showConnectors);
        }
        this.setLayout((Layout)layout);
        this.setLayoutData(new TableWrapData(256, 256));
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public boolean close() {
        if (this.window != null) {
            return this.window.close();
        }
        return false;
    }

    private void createContentsHorizontal(TableWrapLayout layout, boolean showConnectors) {
        layout.numColumns = 2;
        this.createNavigatorSection(this);
        this.createCommandsSection(this);
        Composite subComp = this.toolkit.createComposite((Composite)this);
        TableWrapLayout subLayout = new TableWrapLayout();
        subLayout.topMargin = 0;
        subLayout.bottomMargin = 0;
        subLayout.leftMargin = 0;
        subLayout.rightMargin = 0;
        subComp.setLayout((Layout)subLayout);
        subComp.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        this.createLinkHelpSection(subComp);
    }

    private void createContentsVertical(TableWrapLayout layout, boolean showConnectors) {
        layout.numColumns = 1;
        this.createNavigatorSection(this);
        this.createCommandsSection(this);
        this.createLinkHelpSection(this);
    }

    private void createNavigatorSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new TableWrapData(256));
        this.createNavigatorElementsSection(composite);
        this.createNavigatorDecoratorsSection(composite);
    }

    private void createCommandsSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new TableWrapData(256));
        this.createNavigatorViewCommandsSection(composite);
        this.createContextCommandsSection(composite);
    }

    private void createNavigatorElementsSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 256);
        section.setText("Navigator Tree Elements");
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite r4eClient = this.toolkit.createComposite((Composite)section);
        r4eClient.setLayout((Layout)layout);
        r4eClient.setLayoutData((Object)new TableWrapData(256));
        section.setClient((Control)r4eClient);
        Label imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/revgrp_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Review Group (Open)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/revgrpclsd_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Review Group (Closed)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/reviewbas_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Basic Review (Open)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/revbasclsd_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Basic Review (Closed)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/reviewinf_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Informal Review (Open)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/revinfclsd_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Informal Review (Closed)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/reviewfrm_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Formal Review (Open)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/revfrmclsd_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Formal Review (Closed)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/revitm_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Review Item");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/filectx_obj.gif"));
        this.toolkit.createLabel(r4eClient, "File Context");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/selcont_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Selections Container");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/sel_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Selection");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/deltacont_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Deltas Container");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/delta_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Delta");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/partcont_obj.png"));
        this.toolkit.createLabel(r4eClient, "Participants Container");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/part_obj.png"));
        this.toolkit.createLabel(r4eClient, "Participant (No role)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/partorg_obj.png"));
        this.toolkit.createLabel(r4eClient, "Participant (Organizer)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/partlead_obj.png"));
        this.toolkit.createLabel(r4eClient, "Participant (Lead)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/partauthr_obj.png"));
        this.toolkit.createLabel(r4eClient, "Participant (Author)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/partrevr_obj.png"));
        this.toolkit.createLabel(r4eClient, "Participant (Reviewer)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/anmlycont_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Anomalies Container");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/anmly_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Anomaly");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/postcont_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Imported Postponed Elements Container");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/postfile_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Imported Postponed File");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/postanmly_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Imported Postponed Anomaly");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/ruleset_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Rule Set (Open)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/rulesetclsd_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Rule Set (Closed)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/rulearea_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Rule Area");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/ruleviolation_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Rule Violation");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/rule_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Rule");
    }

    private void createNavigatorDecoratorsSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 256);
        section.setText("Navigator and Editor Elements Decorators");
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite r4eClient = this.toolkit.createComposite((Composite)section);
        r4eClient.setLayout((Layout)layout);
        r4eClient.setLayoutData((Object)new TableWrapData(256));
        section.setClient((Control)r4eClient);
        Label imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/dsbldovr_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Element Disabled");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/readonlyovr_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Element Read-Only");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/revovr_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Element Reviewed by User");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/addovr_tsk.png"));
        this.toolkit.createLabel(r4eClient, "Element Added (File Contexts only)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/removr_tsk.png"));
        this.toolkit.createLabel(r4eClient, "Element Removed (File Contexts only)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/bold_icon.gif"));
        this.toolkit.createLabel(r4eClient, "(Bold font) Active Review (Reviews Only)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/italics_icon.gif"));
        this.toolkit.createLabel(r4eClient, "(Italic font) Element of a Review User is Participating in");
        imageLabel = this.toolkit.createLabel(r4eClient, ">");
        this.toolkit.createLabel(r4eClient, "File Out of Sync with Worskspace (File Contexts only)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/anmlymkr_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Anomaly Annotation Marker (R4E Editor Views)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/delta_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Delta Annotation Marker (R4E Editor Views)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/sel_obj.gif"));
        this.toolkit.createLabel(r4eClient, "Selection Annotation Marker (R4E Editor Views)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/duedateovr_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Element is overdue");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/ovr16/unresolvedovr_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Element is not resolvable (Version Mismatch)");
    }

    private void createNavigatorViewCommandsSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 256);
        section.setText("Navigator and Editor View Commands");
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite r4eClient = this.toolkit.createComposite((Composite)section);
        r4eClient.setLayout((Layout)layout);
        r4eClient.setLayoutData((Object)new TableWrapData(256));
        section.setClient((Control)r4eClient);
        Label imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/alphasort_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Sort Elements Alphabetically");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/revtypesort_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Sort Reviews by Type");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/revgrp_obj.gif"));
        this.toolkit.createLabel(r4eClient, "New Review Group");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/ruleset_obj.gif"));
        this.toolkit.createLabel(r4eClient, "New Rule Set");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/nxtstate_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Progress (Advance) Element State");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/prevstate_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Regress (Rewind) Element State");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/chgdisplay_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Change Display Type");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/expndall_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Expand Navigator Tree");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/clpseall_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Collapse Navigator Tree");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/focus_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Go Into (Focus on selected Element)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/nxtelem_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Select Next Element (and Open if possible)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/prvelem_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Select Previous Element (and Open if possible)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/nxtanmly_menu.png"));
        this.toolkit.createLabel(r4eClient, "Go To Next Open Anomaly Annotation (Compare Editor Window)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/prevanmly_menu.png"));
        this.toolkit.createLabel(r4eClient, "Go To Previous Open Anomaly Annotation (Compare Editor Window)");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/view16/icons-legend.gif"));
        this.toolkit.createLabel(r4eClient, "Show UI Legend Dialog (You are looking at it right now!)");
    }

    private void createContextCommandsSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 256);
        section.setText("Contextual Commands");
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite r4eClient = this.toolkit.createComposite((Composite)section);
        r4eClient.setLayout((Layout)layout);
        r4eClient.setLayoutData((Object)new TableWrapData(256));
        section.setClient((Control)r4eClient);
        Label imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/view16/finditms_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Find Review Items in Version Control System");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/view16/newitm_tsk.png"));
        this.toolkit.createLabel(r4eClient, "New Review Item");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/view16/newanmly_tsk.png"));
        this.toolkit.createLabel(r4eClient, "New Anomaly");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/view16/sendmail_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Send Email or Notification");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/open_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Open (Load) Element");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/close_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Close (Unload) Element");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.toolkit.createLabel(r4eClient, "Add Child Element");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.toolkit.createLabel(r4eClient, "Remove Element");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_UNDO"));
        this.toolkit.createLabel(r4eClient, "Restore Disabled Element");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/elcl16/openfile_menu.gif"));
        this.toolkit.createLabel(r4eClient, "Open File in Editor");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/done_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Toggle Element's User Review State (Reviewed/Not Reviewed");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/assign_tsk.png"));
        this.toolkit.createLabel(r4eClient, "Assign element to Participant");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/unassign_tsk.png"));
        this.toolkit.createLabel(r4eClient, "Unassign Participant");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/view16/importpost_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Import Postponed Elements");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/report_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Generate Report for Review");
        imageLabel = this.toolkit.createLabel(r4eClient, "");
        imageLabel.setImage(UIUtils.loadIcon("icons/obj16/showProps_tsk.gif"));
        this.toolkit.createLabel(r4eClient, "Show the properties view for the selected element");
    }

    private void createLinkHelpSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        Composite hyperlinkClient = this.toolkit.createComposite(parent);
        hyperlinkClient.setLayout((Layout)layout);
        hyperlinkClient.setLayoutData((Object)new TableWrapData(256));
        Hyperlink gettingStartedLink = this.toolkit.createHyperlink(hyperlinkClient, "See also R4E online help", 64);
        gettingStartedLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                R4EUILegendControl.this.close();
                UIUtils.openUrl("http://wiki.eclipse.org/Reviews/R4E/User_Guide");
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }
}

