/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationSupport;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class R4EDiffNode
extends DiffNode {
    private IPath path;
    private String name;
    private final ITypedElement fTargetElement;
    private final ITypedElement fBaseElement;
    private final R4EUIFileContext fTargetFile;
    private final R4EUIFileContext fBaseFile;
    private IReviewAnnotationSupport fAnnotationSupport = null;

    public R4EDiffNode(R4EUIFileContext aTargetFile, R4EUIFileContext aBaseFile, boolean aUseBaseFileTargetVersion) {
        super(0);
        this.fTargetFile = aTargetFile;
        this.fBaseFile = aBaseFile;
        R4EFileVersion targetVersion = null;
        if (aTargetFile != null) {
            targetVersion = aTargetFile.getTargetFileVersion();
        }
        R4EFileVersion baseVersion = null;
        if (aBaseFile != null) {
            baseVersion = aUseBaseFileTargetVersion ? aBaseFile.getTargetFileVersion() : aBaseFile.getBaseFileVersion();
        }
        this.fTargetElement = CommandUtils.createTypedElement(targetVersion);
        this.setLeft(this.fTargetElement);
        this.fBaseElement = CommandUtils.createTypedElement(baseVersion);
        this.setRight(this.fBaseElement);
        this.setKind(this.resolveKind(targetVersion, baseVersion));
        this.setPath(Path.fromPortableString((String)this.resolvePath(targetVersion, baseVersion)));
        this.name = this.path.lastSegment();
    }

    public R4EDiffNode(String name) {
        super(0);
        this.name = name;
        this.fTargetFile = null;
        this.fBaseFile = null;
        this.fTargetElement = null;
        this.fBaseElement = null;
    }

    private int resolveKind(R4EFileVersion aTargetVersion, R4EFileVersion aBaseVersion) {
        if (aTargetVersion == null || aTargetVersion.getRepositoryPath() == null) {
            return 1;
        }
        if (aBaseVersion == null || aBaseVersion.getRepositoryPath() == null) {
            return 2;
        }
        return 3;
    }

    private String resolvePath(R4EFileVersion aTargetVersion, R4EFileVersion aBaseVersion) {
        if (aTargetVersion != null && aTargetVersion.getRepositoryPath() != null) {
            return aTargetVersion.getRepositoryPath();
        }
        if (aBaseVersion != null && aBaseVersion.getRepositoryPath() != null) {
            return aBaseVersion.getRepositoryPath();
        }
        return "";
    }

    public String getTargetLabel() {
        return this.getLabel("Target: ", this.fTargetElement);
    }

    public String getBaseLabel() {
        return this.getLabel("Base: ", this.fBaseElement);
    }

    private String getLabel(String aTitle, ITypedElement aElement) {
        StringBuilder label = new StringBuilder(String.valueOf(aTitle) + (aElement != null ? aElement.getName() : ""));
        R4EFileVersion version = this.getFileVersion(aElement);
        if (version != null && !CommandUtils.useWorkspaceResource(version)) {
            label.append(" " + version.getVersionID());
        }
        return label.toString();
    }

    public R4EUIFileContext getTargetFile() {
        return this.fTargetFile;
    }

    public R4EUIFileContext getBaseFile() {
        return this.fBaseFile;
    }

    public R4EFileVersion getTargetVersion() {
        return this.getFileVersion(this.fTargetElement);
    }

    public R4EFileVersion getBaseVersion() {
        return this.getFileVersion(this.fBaseElement);
    }

    private R4EFileVersion getFileVersion(ITypedElement aElement) {
        if (aElement instanceof R4EFileTypedElement) {
            return ((R4EFileTypedElement)aElement).getFileVersion();
        }
        if (aElement instanceof R4EFileRevisionTypedElement) {
            return ((R4EFileRevisionTypedElement)aElement).getFileVersion();
        }
        return null;
    }

    public ITypedElement getTargetTypedElement() {
        return this.fTargetElement;
    }

    public ITypedElement getBaseTypedElement() {
        return this.fBaseElement;
    }

    public void setAnnotationSupport(IReviewAnnotationSupport aSupport) {
        this.fAnnotationSupport = aSupport;
    }

    public IReviewAnnotationSupport getAnnotationSupport() {
        return this.fAnnotationSupport;
    }

    public void refreshAnnotations() {
        if (this.fAnnotationSupport != null) {
            this.fAnnotationSupport.refreshAnnotations(null);
        }
    }

    public Image getImage() {
        return this.fTargetFile == null && this.fBaseFile == null ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER") : super.getImage();
    }

    public String getName() {
        return this.name;
    }

    public IPath getPath() {
        return this.path;
    }

    public String getType() {
        return this.fTargetFile != null || this.fBaseFile != null ? super.getType() : "FOLDER";
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setName(String name) {
        this.name = name;
    }
}

