/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleClass;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleRank;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleViolation;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IRuleInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class RuleInputDialog
extends FormDialog
implements IRuleInputDialog {
    private static final String ADD_RULE_DIALOG_TITLE = "Enter Rule Details";
    private static final String ADD_RULE_ID_DIALOG_VALUE = "Rule Id:";
    private static final String ADD_RULE_TITLE_DIALOG_VALUE = "Rule Title:";
    private static final String ADD_RULE_CLASS_DIALOG_VALUE = "Rule Class:";
    private static final String ADD_RULE_RANK_DIALOG_VALUE = "Rule Rank:";
    private static final String ADD_RULE_DESCRIPTION_DIALOG_VALUE = "Rule Description:";
    private static final String BASIC_PARAMS_HEADER_MSG = "Enter the mandatory basic parameters for this Rule";
    private String fIdValue = "";
    private Text fIdInputTextField;
    private String fTitleValue = "";
    private Text fTitleInputTextField;
    private String fDescriptionValue = "";
    private Text fDescriptionInputTextField;
    private CCombo fClassCombo = null;
    private R4EDesignRuleClass fClassValue;
    private CCombo fRankCombo = null;
    private R4EDesignRuleRank fRankValue;
    private final IInputValidator fValidator;
    private R4EDesignRuleViolation fDesignRuleViolation = null;

    public RuleInputDialog(Shell aParentShell, R4EDesignRuleViolation aViolation) {
        super(aParentShell);
        this.fDesignRuleViolation = aViolation;
        this.setBlockOnOpen(true);
        this.fValidator = new R4EInputValidator();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String validateResult = this.validateEmptyInput(this.fIdInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Rule Id", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fIdValue = this.fIdInputTextField.getText().trim();
            validateResult = this.validateEmptyInput(this.fTitleInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Rule Title", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fTitleValue = this.fTitleInputTextField.getText().trim();
            this.fClassValue = UIUtils.getClassFromString(this.fClassCombo.getText());
            this.fRankValue = UIUtils.getRankFromString(this.fRankCombo.getText());
            validateResult = this.validateEmptyInput(this.fDescriptionInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Rule Description", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fDescriptionValue = this.fDescriptionInputTextField.getText().trim();
            if (!this.isValidRuleId().booleanValue()) {
                return;
            }
        } else {
            this.fIdValue = null;
            this.fTitleValue = null;
            this.fDescriptionValue = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_RULE_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText("Basic Parameters");
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RuleInputDialog.this.getShell().setSize(RuleInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        Label label = toolkit.createLabel(basicSectionClient, ADD_RULE_ID_DIALOG_VALUE);
        label.setToolTipText("An Tag that Identifies this Design Rule");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fIdInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fIdInputTextField.setToolTipText("An Tag that Identifies this Design Rule");
        this.fIdInputTextField.setLayoutData((Object)textGridData);
        this.fIdInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RuleInputDialog.this.fIdInputTextField.getText().length() > 0 && RuleInputDialog.this.fTitleInputTextField.getText().length() > 0 && RuleInputDialog.this.fDescriptionInputTextField.getText().length() > 0) {
                    RuleInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    RuleInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_RULE_TITLE_DIALOG_VALUE);
        label.setToolTipText("The Design Rule Title");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fTitleInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fTitleInputTextField.setToolTipText("The Design Rule Title");
        this.fTitleInputTextField.setLayoutData((Object)textGridData);
        this.fTitleInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RuleInputDialog.this.fIdInputTextField.getText().length() > 0 && RuleInputDialog.this.fTitleInputTextField.getText().length() > 0 && RuleInputDialog.this.fDescriptionInputTextField.getText().length() > 0) {
                    RuleInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    RuleInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_RULE_DESCRIPTION_DIALOG_VALUE);
        label.setToolTipText("A Description of the Design Rule");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fDescriptionInputTextField = toolkit.createText(basicSectionClient, "", 2626);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fDescriptionInputTextField.getLineHeight() * 3;
        this.fDescriptionInputTextField.setToolTipText("A Description of the Design Rule");
        this.fDescriptionInputTextField.setLayoutData((Object)textGridData);
        this.fDescriptionInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RuleInputDialog.this.fIdInputTextField.getText().length() > 0 && RuleInputDialog.this.fTitleInputTextField.getText().length() > 0 && RuleInputDialog.this.fDescriptionInputTextField.getText().length() > 0) {
                    RuleInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    RuleInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_RULE_CLASS_DIALOG_VALUE);
        label.setToolTipText("The Class for this Design Rule.  It will be automatically set in Anomalies that refers to this Rule");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fClassCombo = new CCombo(basicSectionClient, 2056);
        this.fClassCombo.setItems(UIUtils.getClasses());
        this.fClassCombo.select(0);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fClassCombo.setToolTipText("The Class for this Design Rule.  It will be automatically set in Anomalies that refers to this Rule");
        this.fClassCombo.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(basicSectionClient, ADD_RULE_RANK_DIALOG_VALUE);
        label.setToolTipText("The Rank (or Severity) for this Design Rule.  It will be automatically set in Anomalies that refers to this Rule");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fRankCombo = new CCombo(basicSectionClient, 2056);
        this.fRankCombo.setItems(UIUtils.getRanks());
        this.fRankCombo.select(0);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fRankCombo.setToolTipText("The Rank (or Severity) for this Design Rule.  It will be automatically set in Anomalies that refers to this Rule");
        this.fRankCombo.setLayoutData((Object)textGridData);
        this.fIdInputTextField.setFocus();
    }

    private Boolean isValidRuleId() {
        R4EUIPlugin.Ftracer.traceInfo("Rule id: " + this.fIdValue);
        EList rulesList = this.fDesignRuleViolation.getRules();
        int size = rulesList.size();
        int i = 0;
        while (i < size) {
            if (((R4EDesignRule)rulesList.get(i)).getId().equals(this.fIdValue)) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "This Rule Id already exist", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, this.fIdValue, null), 4);
                dialog.open();
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected boolean isResizable() {
        return true;
    }

    public String getIdValue() {
        return this.fIdValue;
    }

    public String getTitleValue() {
        return this.fTitleValue;
    }

    public R4EDesignRuleClass getClassValue() {
        return this.fClassValue;
    }

    public R4EDesignRuleRank getRankValue() {
        return this.fRankValue;
    }

    public String getDescriptionValue() {
        return this.fDescriptionValue;
    }

    private String validateEmptyInput(Text aText) {
        if (this.fValidator != null) {
            return this.fValidator.isValid(aText.getText());
        }
        return null;
    }
}

