/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorTreeViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class ChangeDisplayHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String COMMAND_MESSAGE = "Changing Display...";

    public Object execute(ExecutionEvent aEvent) {
        if (R4EUIModelController.getActiveReview() != null) {
            R4EUIPlugin.Ftracer.traceInfo("Changing Display Type");
            Command command = aEvent.getCommand();
            try {
                HandlerUtil.toggleCommandState((Command)command);
                if (R4EUIModelController.getNavigatorView().isDefaultDisplay()) {
                    ((ReviewNavigatorTreeViewer)R4EUIModelController.getNavigatorView().getTreeViewer()).setViewTreeTable();
                } else {
                    ((ReviewNavigatorTreeViewer)R4EUIModelController.getNavigatorView().getTreeViewer()).setViewTree();
                }
                IEvaluationService evService = (IEvaluationService)HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)aEvent).getService(IEvaluationService.class);
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.display.defaultDisplay");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.changeDisplay");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.PreviousState");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.NextState");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.sorters.AlphaSort");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.sorters.ReviewTypeSort");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsOnly");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsMy");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsParticipant");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.Anomalies");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AnomaliesMy");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsCompleted");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideRuleSets");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideDeltas");
                evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.RemoveAll");
            }
            catch (ExecutionException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.changeDisplay");
        element.setChecked(((Boolean)command.getState("org.eclipse.ui.commands.toggleState").getValue()).booleanValue());
    }
}

