/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.filters;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.FocusFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorActionGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorTreeViewer;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;

public class GoIntoFilterHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Changing focus...";

    public Object execute(final ExecutionEvent aEvent) {
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(GoIntoFilterHandler.COMMAND_MESSAGE, 1);
                ReviewNavigatorTreeViewer viewer = (ReviewNavigatorTreeViewer)R4EUIModelController.getNavigatorView().getTreeViewer();
                if (!viewer.getControl().isDisposed()) {
                    boolean oldValue;
                    Object[] elements = viewer.getVisibleExpandedElements();
                    FocusFilter filter = ((ReviewNavigatorActionGroup)R4EUIModelController.getNavigatorView().getActionSet()).getFocusFilter();
                    try {
                        oldValue = HandlerUtil.toggleCommandState((Command)aEvent.getCommand());
                    }
                    catch (ExecutionException executionException) {
                        monitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    if (!oldValue) {
                        IR4EUIModelElement element;
                        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                        if (selection != null && (element = (IR4EUIModelElement)selection.getFirstElement()) != null) {
                            R4EUIPlugin.Ftracer.traceInfo("Setting focus on current element");
                            R4EUIModelController.setCurrentFocusElement(element);
                            viewer.setInput(element.getParent());
                            viewer.setDefaultInput(element.getParent());
                            viewer.addFilter(filter);
                            viewer.setExpandedElements(elements);
                        }
                    } else {
                        R4EUIPlugin.Ftracer.traceInfo("Removing focus on current element");
                        viewer.removeFilter(filter);
                        R4EUIModelController.setCurrentFocusElement(R4EUIModelController.getRootElement());
                        if (R4EUIModelController.getNavigatorView().isDefaultDisplay()) {
                            viewer.setInput(R4EUIModelController.getRootElement());
                        } else {
                            viewer.setInput(R4EUIModelController.getActiveReview());
                            viewer.setDefaultInput(R4EUIModelController.getRootElement());
                        }
                        if (elements.length > 0) {
                            Object[] objectArray = elements;
                            int n = elements.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object element = objectArray[n2];
                                viewer.expandToLevel(element, 1);
                                ++n2;
                            }
                        }
                    }
                }
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

