/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ModelElementProperties;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class ModelElementTabPropertySection
extends AbstractPropertySection
implements IPropertyListener {
    protected ModelElementProperties fProperties;
    protected boolean fRefreshInProgress = false;

    public void setInput(IWorkbenchPart part, ISelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        IR4EUIModelElement element = (IR4EUIModelElement)((StructuredSelection)aSelection).getFirstElement();
        if (element != null) {
            this.fProperties = (ModelElementProperties)((R4EUIModelElement)element).getAdapter(IPropertySource.class);
            this.refresh();
        }
    }

    public void propertyChanged(Object source, int propId) {
        this.refresh();
    }

    public void refresh() {
        this.fRefreshInProgress = true;
        this.setEnabledFields();
        this.fRefreshInProgress = false;
    }

    protected void setEnabledFields() {
    }

    public static void scroll(ScrolledComposite aComp, int aXOffset, int aYOffset) {
        Point origin = aComp.getOrigin();
        Point contentSize = aComp.getContent().getSize();
        int xorigin = origin.x + aXOffset;
        int yorigin = origin.y + aYOffset;
        xorigin = Math.max(xorigin, 0);
        xorigin = Math.min(xorigin, contentSize.x - 1);
        yorigin = Math.max(yorigin, 0);
        yorigin = Math.min(yorigin, contentSize.y - 1);
        aComp.setOrigin(xorigin, yorigin);
    }

    public static void addScrollListener(final CCombo aCombo) {
        aCombo.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                ScrolledComposite form = FormUtil.getScrolledComposite((Control)aCombo);
                aCombo.select(aCombo.getSelectionIndex());
                if (form != null && form.getVerticalBar() != null) {
                    if (event.count < 0) {
                        ModelElementTabPropertySection.scroll(form, 0, form.getVerticalBar().getIncrement());
                    } else {
                        ModelElementTabPropertySection.scroll(form, 0, -form.getVerticalBar().getIncrement());
                    }
                }
                event.doit = false;
            }
        });
    }
}

