/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class CloseElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Closing Element...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                R4EUIModelController.setJobInProgress(true);
                monitor.beginTask(CloseElementHandler.COMMAND_MESSAGE, -1);
                if (!selectedElements.isEmpty()) {
                    IR4EUIModelElement element = (IR4EUIModelElement)selectedElements.get(0);
                    R4EUIPlugin.Ftracer.traceInfo("Closing element " + element.getName());
                    element.close();
                    UIUtils.setNavigatorViewFocus(element, 0);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

